/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.security.SecurityPolicy;
import com.filenet.api.util.Id;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Permission;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8CheckInAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonItem = new JSONObject();
        jsonArray.add(jsonItem);
        String criterias = request.getParameter("criterias");
        JSONArray criteriasJsonArray = JSONArray.parse(criterias);
        jsonItem.put("criterias", criteriasJsonArray);
        String permissionJSON = request.getParameter("acl");
        if (permissionJSON != null) {
            JSONArray permissionJSONArray = JSONArray.parse(permissionJSON);
            jsonItem.put("acl", permissionJSONArray);
        }
        request.setAttribute("json_post", (Object)jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        ClassDescription classDescription = null;
        searchResultsMediator.setResponseAsHtml(((FileUploadActionForm)form).getUploadFile() != null);
        Connection connection2 = ceConnection;
        synchronized (connection2) {
            try {
                AccessPermissionList apl;
                String checkedOutByUser;
                Document doc;
                Document checkedOutDoc;
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                String className = request.getParameter("template_name");
                String contentSourceType = request.getParameter("parm_content_source_type");
                String pid = request.getParameter("docid");
                String securityPolicyId = request.getParameter("securityPolicyId");
                AutoClassify autoClassify = this.getBooleanRequestParameter(request, "autoClassify", false) ? AutoClassify.AUTO_CLASSIFY : AutoClassify.DO_NOT_AUTO_CLASSIFY;
                CheckinType checkinType = this.getBooleanRequestParameter(request, "asMinorVersion", false) ? CheckinType.MINOR_VERSION : CheckinType.MAJOR_VERSION;
                JSONArray jsonArray = (JSONArray)this.getJSONRequest(request);
                JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                JSONArray criteriasJsonArray = (JSONArray)jsonObj.get("criterias");
                JSONArray permissionJsonArray = (JSONArray)jsonObj.get("acl");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + (serverName != null ? serverName : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: className = " + (className != null ? className : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + (pid != null ? pid : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: criterias = " + (criteriasJsonArray != null ? criteriasJsonArray.toString() : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: permissions = " + (permissionJsonArray != null ? permissionJsonArray.toString() : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: securityPolicy = " + (securityPolicyId != null ? securityPolicyId : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: autoClassify = " + (autoClassify == AutoClassify.AUTO_CLASSIFY));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: asMinorVersion = " + (checkinType == CheckinType.MINOR_VERSION));
                searchResultsMediator.setServer(connection);
                searchResultsMediator.setServerName(serverName);
                ObjectStore objectStore = P8Util.getObjectStore(request, connection, null);
                classDescription = Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)className, null);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " classDescription.get_Id(); = " + classDescription.get_Id());
                searchResultsMediator.addClassDescription(classDescription);
                SecurityPolicy securityPolicy = null;
                if (securityPolicyId != null && securityPolicyId.length() > 0) {
                    securityPolicy = Factory.SecurityPolicy.fetchInstance((ObjectStore)objectStore, (Id)new Id(securityPolicyId), null);
                }
                if ((checkedOutDoc = (Document)(doc = P8Util.getDocument(request, connection, pid)).get_Reservation()) == null) {
                    searchResultsMediator.addError("checkin.error.notCheckedOut", null);
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                int access = checkedOutDoc.getAccessAllowed();
                if (checkinType == CheckinType.MINOR_VERSION) {
                    if ((access & 0x40) != 64) {
                        searchResultsMediator.addError("checkin.error.noMinorVersionPermission", null);
                        this.writeJSONMediator(request, response);
                        Logger.logExit((Object)this, methodName, (ServletRequest)request);
                        return actionForward;
                    }
                } else if ((access & 4) != 4) {
                    searchResultsMediator.addError("checkin.error.noMajorVersionPermission", null);
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                if (checkedOutDoc.get_ReservationType() == ReservationType.EXCLUSIVE && !(checkedOutByUser = checkedOutDoc.get_Creator()).equals(connection.getUserId())) {
                    searchResultsMediator.addError("checkin.error.exclusiveDifferentUser", checkedOutByUser);
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                String docClass = checkedOutDoc.get_ClassDescription().getProperties().getStringValue("SymbolicName");
                if (!docClass.equals(className)) {
                    checkedOutDoc.changeClass(className);
                }
                P8Util.setProperties(request, (IndependentObject)checkedOutDoc, criteriasJsonArray, classDescription);
                if (contentSourceType.equalsIgnoreCase("Document") || contentSourceType.equalsIgnoreCase("ExternalURL")) {
                    this.setContent(request, checkedOutDoc, contentSourceType, form);
                }
                if (securityPolicy != null) {
                    checkedOutDoc.set_SecurityPolicy(securityPolicy);
                }
                if ((apl = P8Permission.getPermissionsFromJSON(permissionJsonArray)) != null) {
                    checkedOutDoc.set_Permissions(apl);
                }
                checkedOutDoc.checkin(autoClassify, checkinType);
                checkedOutDoc.save(RefreshMode.REFRESH);
                ArrayList<Document> hits = new ArrayList<Document>(1);
                if (checkinType == CheckinType.MINOR_VERSION) {
                    searchResultsMediator.setShowCheckoutIfReservation(true);
                    doc.refresh();
                    hits.add(doc);
                } else {
                    HashMap<String, String> updatedDocIds = new HashMap<String, String>(1);
                    updatedDocIds.put(P8Util.getDocId(checkedOutDoc.getObjectReference()), pid);
                    searchResultsMediator.setUpdatedDocIds(updatedDocIds);
                    hits.add(checkedOutDoc);
                }
                P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                searchResultsBean.setHits(hits);
                searchResultsMediator.setSearchResultsBean(searchResultsBean);
                searchResultsMediator.addMessage("checkinDocument.success", new Object[0]);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        Boolean maxFileSizeExceeded;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.createMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + (serverName != null ? serverName : ""));
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + (pid != null ? pid : ""));
        if (serverName == null || serverName.trim().length() < 1) {
            searchResultsMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        searchResultsMediator.setServerName(serverName);
        if (pid == null || pid.trim().length() < 1) {
            searchResultsMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        if ((maxFileSizeExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxFileSizeExceeded.booleanValue()) {
            searchResultsMediator.addError("import.filesize.exceed.maxlength");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        return baseMediator;
    }

    public void unlockAndUpdateSearchResults(HttpServletRequest request, HttpServletResponse response, String newDocId, String origDocId, String serverName, ClassDescription classDescription) throws Exception {
        String methodName = "unlockAndUpdateSearchResults";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + (serverName != null ? serverName : ""));
        String itemTypeName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + (itemTypeName != null ? itemTypeName : ""));
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + (pid != null ? pid : ""));
        String contentSourceType = request.getParameter("parm_content_source_type");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "contentSourceType = " + (contentSourceType != null ? contentSourceType : ""));
        if (contentSourceType.equalsIgnoreCase("Document")) {
            String partMimeType = request.getParameter("mimetype");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partMimeType = " + (partMimeType != null ? partMimeType : ""));
            String partLength = request.getParameter("parm_part_length");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partLength = " + (partLength != null ? partLength : ""));
            String partFileName = request.getParameter("parm_part_filename");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partFileName = " + (partFileName != null ? partFileName : ""));
        }
    }
}

