/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentReference;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Permission;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class P8BaseAction
extends BaseAction {
    int maxFolders = Integer.MAX_VALUE;
    protected boolean showFieldHoverHelp = false;
    private boolean initialized = false;
    protected int pageSize;
    protected HttpServletRequest request = null;
    protected WCDateFormat wcDateFormats = null;

    @Override
    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session;
        String methodName = "executeBaseAction";
        this.request = request;
        String userid = request != null ? request.getParameter("userid") : null;
        HttpSession httpSession = session = request != null ? request.getSession() : null;
        if (session != null && userid != null) {
            session.setAttribute("session_userid", (Object)userid);
        }
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        try {
            this.preUserExit(request);
            P8Connection connection = null;
            if (!(mapping.getPath().endsWith("/logon") || mapping.getPath().endsWith("/changePassword") || mapping.getPath().endsWith("/logoff") || mapping.getPath().endsWith("/getProfile"))) {
                connection = this.getConnection(request);
                if (connection != null) {
                    String altOutput;
                    request.setAttribute("p8_server", (Object)connection);
                    if (mapping.getPath().endsWith("/getContentItems") && (altOutput = request.getParameter("alt_output")) != null && altOutput.equalsIgnoreCase("JSON")) {
                        BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                        mediator.addMessage("properties.download.successful", new Object[0]);
                        request.setAttribute("mediator", (Object)mediator);
                        this.writeJSONMediator(request, response);
                        return actionForward;
                    }
                } else {
                    String altOutput;
                    Logger.logError((Object)this, methodName, (ServletRequest)request, "The connection object was not found!");
                    if (mapping.getPath().endsWith("/getDocument") && ((altOutput = request.getParameter("alt_output")) == null || !altOutput.equalsIgnoreCase("JSON"))) {
                        response.sendError(500, "error.server.connection.null");
                        return actionForward;
                    }
                    BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                    mediator.addError("error.server.connection.null");
                    request.setAttribute("mediator", (Object)mediator);
                    this.writeJSONMediator(request, response);
                    return actionForward;
                }
            }
            if (!this.initialized) {
                this.initConfigInfo(request);
                this.initialized = true;
            }
            if (connection != null) {
                UserContext.get().pushSubject(connection.getSubject());
                UserContext.get().setLocale(request.getLocale());
            }
            actionForward = this.executeAction(mapping, form, request, response);
            if (connection != null) {
                UserContext.get().pushSubject(connection.getSubject());
            }
            this.postUserExit(request);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            throw e;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected static Collection<ClassDescription> findUniqueClassDescriptions(List objects) {
        HashMap<String, ClassDescription> mapOfCDs = new HashMap<String, ClassDescription>();
        for (Object obj : objects) {
            ClassDescription cd = null;
            if (obj instanceof EngineObject) {
                cd = ((EngineObject)obj).get_ClassDescription();
            } else if (obj instanceof RepositoryRow) {
                Properties props = ((RepositoryRow)obj).getProperties();
                cd = (ClassDescription)props.get("ClassDescription");
            }
            if (cd == null) continue;
            String id = cd.getObjectReference().getObjectStoreIdentity() + "/" + cd.getObjectReference().getObjectIdentity();
            mapOfCDs.put(id, cd);
        }
        return mapOfCDs.values();
    }

    protected abstract ActionForward executeAction(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected void preUserExit(HttpServletRequest request) {
    }

    protected void postUserExit(HttpServletRequest request) {
    }

    public void getConfigInfo(HttpServletRequest request) throws Exception {
        RepositoryConfig repositoryConfig;
        DesktopConfig desktopConfig = Config.getDesktopConfig(request);
        String repositoryId = request.getParameter("repositoryId");
        if (repositoryId != null && desktopConfig.hasRepository(repositoryId) && (repositoryConfig = Config.getRepositoryConfig(request)) != null) {
            this.pageSize = repositoryConfig.getPageSize();
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
        }
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public P8Connection getConnection(HttpServletRequest request, String serverName) {
        return P8Util.getConnection(request, serverName);
    }

    protected P8Connection getConnection(HttpServletRequest request) {
        String userId;
        String methodName = "getConnection";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        P8Connection connection = null;
        String serverName = request.getParameter("repositoryId");
        connection = this.getConnection(request, serverName);
        if (connection == null) {
            return null;
        }
        if (connection != null && (userId = connection.getUserId()) != null) {
            request.getSession(false).setAttribute("session_userid", (Object)userId);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return connection;
    }

    protected AccessPermissionList getPermissionsFromJSON(JSONArray jsonPermissions, Connection ceConnection) throws Exception {
        AccessPermissionList permissions = null;
        if (jsonPermissions.size() > 0) {
            for (JSONObject jsonPermission : jsonPermissions) {
                String granteeName = jsonPermission.get("granteeName").toString();
                if (!granteeName.equals("#CREATOR-OWNER")) continue;
                User currentUser = Factory.User.fetchCurrent((Connection)ceConnection, null);
                jsonPermission.put("granteeName", currentUser.get_Name());
                break;
            }
            permissions = P8Permission.getPermissionsFromJSON(jsonPermissions);
        }
        return permissions;
    }

    protected void removeConnection(HttpServletRequest request) {
        String serverName = request.getParameter("repositoryId");
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("p8_servers");
        connectionList.remove(serverName);
    }

    protected static void setConnection(HttpServletRequest request, P8Connection connection) {
        P8BaseAction.setConnection(request, connection, null);
    }

    public static void setConnection(HttpServletRequest request, P8Connection connection, String repositoryId) {
        String methodName = "setConnection";
        Logger.logEntry(P8BaseAction.class, methodName, (ServletRequest)request);
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("p8_servers");
        Logger.logDebug(P8BaseAction.class, methodName, (ServletRequest)request, " connectionList: " + connectionList);
        if (connectionList == null) {
            P8BaseAction.createConnectionList(request);
            P8BaseAction.setConnection(request, connection, repositoryId);
        } else {
            Logger.logDebug(P8BaseAction.class, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
            String serverName = repositoryId;
            if (repositoryId == null) {
                serverName = request.getParameter("repositoryId");
            }
            Logger.logDebug(P8BaseAction.class, methodName, (ServletRequest)request, "objectstore name: " + connection.getObjectStore().get_Name());
            Logger.logDebug(P8BaseAction.class, methodName, (ServletRequest)request, "serverName: " + serverName);
            connectionList.put(serverName, connection);
        }
        Logger.logExit(P8BaseAction.class, methodName, (ServletRequest)request);
    }

    private static void createConnectionList(HttpServletRequest request) {
        Hashtable connections = new Hashtable();
        request.getSession(true).setAttribute("p8_servers", connections);
    }

    public void initConfigInfo(HttpServletRequest request) throws Exception {
        String methodName = "initConfigInfo";
        DesktopConfig desktopConfig = Config.getDesktopConfig(request);
        this.setShowFieldHoverHelp(desktopConfig.isShowFieldHoverHelp());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "showFiledFieldHelp = " + this.getShowFieldHoverHelp());
    }

    public int getMaxFolders() {
        return this.maxFolders;
    }

    public void setMaxFolders(int maxFolders) {
        this.maxFolders = maxFolders;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public FormFile getFormFile(ActionForm form) {
        FormFile formFile;
        block1: {
            formFile = ((FileUploadActionForm)form).getUploadFile();
            if (formFile != null || form.getMultipartRequestHandler() == null) break block1;
            Hashtable fileElements = form.getMultipartRequestHandler().getFileElements();
            Iterator it = fileElements.values().iterator();
            while (it.hasNext() && (formFile = (FormFile)it.next()) == null) {
            }
        }
        return formFile;
    }

    public void setContent(HttpServletRequest request, Document doc, String contentSourceType, ActionForm form) throws Exception {
        String methodName = "setContent";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String partFilePath = request.getParameter("parm_part_filename");
        if (contentSourceType.equals("Document")) {
            FormFile ff = this.getFormFile(form);
            InputStream is = ff != null ? ff.getInputStream() : request.getInputStream();
            ContentTransfer ct = Factory.ContentTransfer.createInstance();
            ct.setCaptureSource(is);
            String partFileName = Util.getFileNameFromPath(request, partFilePath);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "file name of the new item is =" + partFileName);
            ct.set_RetrievalName(partFileName);
            String partMimeType = request.getParameter("mimetype");
            if ((partMimeType == null || partMimeType.length() == 0) && partFileName != null && partFileName.length() > 0) {
                try {
                    int index = partFileName.lastIndexOf(".");
                    if (index != -1) {
                        String fileExtension = partFileName.substring(index + 1, partFileName.length());
                        partMimeType = MimeTypeUtil.getMimeTypeNoDefault(fileExtension);
                    } else {
                        partMimeType = null;
                    }
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                }
            }
            if (partMimeType != null && partMimeType.length() > 0) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "MIME type of the new document is = " + partMimeType);
                ct.set_ContentType(partMimeType);
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "MIME type of the new document is = <not provided - CE will determine the MIME type>");
            }
            ContentElementList cel = Factory.ContentElement.createList();
            cel.add((Object)ct);
            doc.set_ContentElements(cel);
        } else if (contentSourceType.equals("ExternalURL")) {
            ContentReference cr = Factory.ContentReference.createInstance();
            cr.set_ContentType("application/x-filenet-external");
            cr.set_ContentLocation(partFilePath);
            ContentElementList cel = Factory.ContentElement.createList();
            cel.add((Object)cr);
            doc.set_ContentElements(cel);
        }
    }
}

