/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.core.UpdatingBatch;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8AddToFolderAction
extends P8BaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection ceConnection;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection connection2 = ceConnection = connection.getCEConnection();
        synchronized (connection2) {
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String[] itemPIDs = request.getParameterValues("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
                String[] folderPIDs = request.getParameterValues("folderDocid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
                String folderName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + folderName);
                EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)ceConnection, null);
                Domain domain = entireNetwork.get_LocalDomain();
                UpdatingBatch updateBatch = UpdatingBatch.createUpdatingBatchInstance((Domain)domain, (RefreshMode)RefreshMode.REFRESH);
                searchResultsMediator.setServer(connection);
                if (ceConnection != null) {
                    String folderPID = null;
                    String itemPID = null;
                    int errorCount = 0;
                    for (int iFolderCounter = 0; iFolderCounter < folderPIDs.length; ++iFolderCounter) {
                        folderPID = folderPIDs[iFolderCounter];
                        for (int iItemCounter = 0; iItemCounter < itemPIDs.length; ++iItemCounter) {
                            itemPID = itemPIDs[iItemCounter];
                            try {
                                this.addItemToFolder(connection, itemPID, folderPID, updateBatch);
                                continue;
                            }
                            catch (Exception addtoFolderException) {
                                ++errorCount;
                                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)addtoFolderException);
                                searchResultsMediator.addWarning("addToFolder.warning", new Object[0]);
                            }
                        }
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Doing updates via UpdatingBatch");
                    String messageKey = null;
                    if (errorCount == 0) {
                        if (itemPIDs.length == 1 && folderPIDs.length == 1) {
                            messageKey = "addToFolder.success.singleitem.singlefolder";
                        } else if (itemPIDs.length > 1 && folderPIDs.length == 1) {
                            messageKey = "addToFolder.success.multiitem.singlefolder";
                        } else if (itemPIDs.length == 1 && folderPIDs.length > 1) {
                            messageKey = "addToFolder.success.singleitem.multifolder";
                        } else if (itemPIDs.length == 1 && folderPIDs.length > 1) {
                            messageKey = "addToFolder.success.multiitem.multifolder";
                        }
                    } else {
                        messageKey = "addToFolder.success.some.added";
                    }
                    searchResultsMediator.addMessage(messageKey, new Object[0]);
                }
            }
            catch (AlreadyInFolderException aife) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)aife);
                searchResultsMediator.addError(aife.getMessage());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void addItemToFolder(P8Connection connection, String itemPID, String folderPID, UpdatingBatch updateBatch) throws Exception {
        String methodName = "addItemToFolder";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        boolean data_id = false;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "folder was selected and the pid = " + folderPID);
        Folder folder = P8Util.getFolder(this.request, connection, folderPID);
        IndependentlyPersistableObject item = P8Util.getPersistableObject(this.request, connection, itemPID);
        ReferentialContainmentRelationship rcr = folder.file(item, AutoUniqueName.AUTO_UNIQUE, null, DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
        rcr.save(RefreshMode.NO_REFRESH);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String[] itemPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
        String pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + itemPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
        String[] folderPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
        pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + folderPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
    }

    protected class AlreadyInFolderException
    extends Exception {
        static final long serialVersionUID = 1L;

        public AlreadyInFolderException(String messageReference) {
            super(messageReference);
        }
    }
}

