/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.constants.AccessType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ObjectStore;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8TeamspaceListMediator;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.User;
import com.ibm.ecm.security.p8.P8AccessControlListData;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.TeamspaceException;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8AddTeamspaceAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        P8TeamspaceListMediator teamspaceAddMediator = (P8TeamspaceListMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        try {
            String teamspaceId = request.getParameter("workspaceId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceId = " + teamspaceId);
            String serverName = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
            String teamspaceType = request.getParameter("workspaceType");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceType = " + teamspaceType);
            String modifyWorkspace = request.getParameter("modifyWorkspace");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "modifyWorkspace = " + modifyWorkspace);
            String modifyUsers = request.getParameter("modifyUsers");
            if (modifyUsers == null) {
                modifyUsers = "false";
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "modifyUsers = " + modifyUsers);
            ObjectStore objectStore = connection.getObjectStore();
            String teamspaceJson = this.readJSON(request);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "json: " + teamspaceJson);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceJson = " + teamspaceJson);
            JSONObject jsonObject = (JSONObject)JSON.parse(teamspaceJson);
            String teamspaceState = (String)jsonObject.get("state");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceState = " + teamspaceState);
            if (teamspaceState != null && teamspaceState.length() == 0) {
                teamspaceState = "published";
            }
            String teamspaceTemplateId = (String)jsonObject.get("id");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "templateId = " + teamspaceTemplateId);
            String name = (String)jsonObject.get("name");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "name= " + name);
            String description = (String)jsonObject.get("description");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description= " + description);
            String templateName = (String)jsonObject.get("templateName");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "templateName= " + templateName);
            JSONArray rolesArray = (JSONArray)jsonObject.get("roles");
            HashMap<String, Role> rolesMap = new HashMap<String, Role>();
            for (int i = 0; i < rolesArray.size(); ++i) {
                JSONObject roleObj = (JSONObject)rolesArray.get(i);
                String roleId = (String)roleObj.get("id");
                String messageId = (String)roleObj.get("messageId");
                String roleName = (String)roleObj.get("name");
                String roleDesc = (String)roleObj.get("description");
                JSONArray privsArray = (JSONArray)roleObj.get("privileges");
                ArrayList<String> privileges = new ArrayList<String>();
                for (int j = 0; j < privsArray.size(); ++j) {
                    String priv = (String)privsArray.get(j);
                    privileges.add(priv);
                }
                Role role = new Role(roleId, roleName, roleDesc, privileges);
                role.setRoleType(SecurityConstants.RoleType.TEAMSPACE);
                role.setMessageId(messageId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add role to roleMap: " + role.toJSON());
                rolesMap.put(roleId, role);
            }
            ArrayList<AccessControlListData> secObjAclData = new ArrayList<AccessControlListData>();
            secObjAclData.add(new P8AccessControlListData(request, connection.getUserId(), null, SecurityConstants.PrincipalType.USER, Integer.parseInt("998903"), P8AccessControlListData.InheritableDepth.NONE, null, AccessType.ALLOW));
            AccessControlList secObjACL = new AccessControlList("", secObjAclData);
            ArrayList<AccessControlListData> teamspaceAclData = new ArrayList<AccessControlListData>();
            teamspaceAclData.add(new P8AccessControlListData(request, connection.getUserId(), null, SecurityConstants.PrincipalType.USER, Integer.parseInt("998903"), P8AccessControlListData.InheritableDepth.NONE, null, AccessType.ALLOW));
            AccessControlList teamspaceObjACL = new AccessControlList("", teamspaceAclData);
            JSONArray members = (JSONArray)jsonObject.get("members");
            for (int i = 0; i < members.size(); ++i) {
                List<String> userPrivs;
                JSONObject member = (JSONObject)members.get(i);
                String principalId = (String)member.get("id");
                String principalName = (String)member.get("name");
                SecurityConstants.PrincipalType principalType = SecurityConstants.PrincipalType.valueOf(((String)member.get("type")).toUpperCase());
                ArrayList<Role> usrRoles = new ArrayList<Role>();
                User usrObj = new User(principalId, principalName, "", "", "", usrRoles);
                JSONArray memberRolesArray = (JSONArray)member.get("roles");
                for (int j = 0; j < memberRolesArray.size(); ++j) {
                    String roleId = (String)memberRolesArray.get(j);
                    Role role = (Role)rolesMap.get(roleId);
                    usrRoles.add(role);
                    HashMap<String, SecurityConstants.PrincipalType> assignees = role.getAssignees();
                    if (assignees == null) {
                        assignees = new HashMap();
                        role.setAssigness(assignees);
                    }
                    if (assignees.containsKey(principalId) || assignees.containsKey(principalName)) continue;
                    if (principalId.equals("CURRENT_USER") || principalType == SecurityConstants.PrincipalType.GROUP) {
                        assignees.put(principalName, principalType);
                        continue;
                    }
                    assignees.put(principalId, principalType);
                }
                if (principalId.equals("CURRENT_USER")) {
                    secObjAclData.add(new P8AccessControlListData(request, principalName, null, principalType, Integer.parseInt("998903"), P8AccessControlListData.InheritableDepth.NONE, null, AccessType.ALLOW));
                    teamspaceAclData.add(new P8AccessControlListData(request, principalName, null, principalType, Integer.parseInt("998903"), P8AccessControlListData.InheritableDepth.NONE, null, AccessType.ALLOW));
                    continue;
                }
                String accessName = principalId;
                if (principalType == SecurityConstants.PrincipalType.GROUP) {
                    accessName = principalName;
                }
                if ((userPrivs = usrObj.getMaxPrivileges()).contains("addRemoveRoleParticipants")) {
                    secObjAclData.add(new P8AccessControlListData(request, accessName, null, principalType, Integer.parseInt("998903"), P8AccessControlListData.InheritableDepth.NONE, null, AccessType.ALLOW));
                }
                Integer denyMask = SecurityConstants.p8PrivilegeMap.get("deleteFolders");
                teamspaceAclData.add(new P8AccessControlListData(request, accessName, null, principalType, denyMask, P8AccessControlListData.InheritableDepth.NONE, null, AccessType.DENY));
            }
            ArrayList<Role> roles = new ArrayList<Role>();
            roles.addAll(rolesMap.values());
            P8TeamspaceService teamspaceService = new P8TeamspaceService(ceConnection, connection.getDomain(), objectStore, connection, request);
            String className = "ClbTeamspaceTemplate";
            if (teamspaceType.equals("instance")) {
                className = "ClbTeamspace";
            }
            Teamspace teamspace = new Teamspace(request, name, description, teamspaceType, className, teamspaceJson, null);
            teamspace.setId(teamspaceId);
            teamspace.setState(teamspaceState);
            teamspace.setTemplateId(teamspaceTemplateId);
            boolean retrieveFullTeamspaceObject = false;
            if (modifyWorkspace != null && modifyWorkspace.equalsIgnoreCase("true")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "editing teamspace template");
                teamspaceService.editTeamspace(teamspace, roles, secObjACL, modifyUsers.equalsIgnoreCase("true"), teamspaceObjACL);
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "creating teamspace template");
                AccessPermissionList permissions = null;
                if (teamspaceType.equals("template")) {
                    JSONArray jsonPermissions = (JSONArray)jsonObject.get("permissions");
                    permissions = this.getPermissionsFromJSON(jsonPermissions, ceConnection);
                    jsonObject.remove("permissions");
                    String json = jsonObject.toString();
                    teamspace.setJson(json);
                } else {
                    retrieveFullTeamspaceObject = true;
                }
                teamspaceId = teamspaceService.createTeamspace(teamspace, roles, secObjACL, permissions, teamspaceObjACL);
            }
            if (retrieveFullTeamspaceObject) {
                teamspace = teamspaceService.retrieveTeamspace(teamspaceId, "allData", teamspaceType);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Set teamspace");
            ArrayList<Teamspace> teamspaces = new ArrayList<Teamspace>();
            teamspaces.add(teamspace);
            teamspaceAddMediator.setTeamspaces(teamspaces);
        }
        catch (TeamspaceException we) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)we);
            if (we.getErrorID() == 1088) {
                teamspaceAddMediator.addError("addWorkspace.error.failed");
            } else if (we.getErrorID() == 1097) {
                teamspaceAddMediator.addError("addSearchToWorkspace.error.failed");
            } else {
                teamspaceAddMediator.addError("error.exception.general", we.getMessage());
            }
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            teamspaceAddMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8TeamspaceListMediator teamspaceAddMediator = new P8TeamspaceListMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)teamspaceAddMediator);
        return teamspaceAddMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

