/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.teamspace.TeamspaceException;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8SearchTemplateDocument;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8AddSearchTemplateAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection ceConnection;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        P8SearchResultsMediator mediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection connection2 = ceConnection = connection.getCEConnection();
        synchronized (connection2) {
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                String workspaceId = request.getParameter("workspaceId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + workspaceId);
                String t = this.readJSON(request);
                JSONObject searchTemplateJson = (JSONObject)JSON.parse(t);
                String name = (String)searchTemplateJson.get("name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "name = " + name);
                String description = (String)searchTemplateJson.get("description");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description = " + description);
                String folderPID = (String)searchTemplateJson.get("parentFolderId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parentFolderId = " + folderPID);
                AccessPermissionList permissions = this.getPermissionsFromJSON((JSONArray)searchTemplateJson.get("permissions"), ceConnection);
                if ((folderPID == null || folderPID.length() == 0) && workspaceId != null) {
                    folderPID = workspaceId;
                }
                P8SearchTemplateDocument searchDocument = new P8SearchTemplateDocument(request, connection, null, null, null);
                Document document = searchDocument.saveAs(name, description, searchTemplateJson, folderPID, permissions);
                document.checkout(ReservationType.OBJECT_STORE_DEFAULT, null, null, null);
                document.save(RefreshMode.REFRESH);
                ObjectStore os = connection.getObjectStore();
                ClassDescription classDescription = Factory.ClassDescription.fetchInstance((Scope)os, (String)"StoredSearch", null);
                mediator.setServer(connection);
                mediator.setServerName(serverName);
                mediator.addClassDescription(classDescription);
                P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                ArrayList<Document> hits = new ArrayList<Document>(1);
                hits.add(document);
                searchResultsBean.setHits(hits);
                mediator.setSearchResultsBean(searchResultsBean);
                if (workspaceId != null && workspaceId.length() > 0) {
                    P8TeamspaceService workspaceService = new P8TeamspaceService(ceConnection, connection.getDomain(), connection.getObjectStore(), connection, request);
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "adding a search to the teamspace: " + name);
                    String id = P8Util.getDocId(document.getObjectReference());
                    workspaceService.addSearchTemplate(workspaceId, id, name, description);
                }
            }
            catch (TeamspaceException we) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)we);
                mediator.addError("addSearchToWorkspace.error.failed", we.getMessage());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

