/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.core.Scope;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.security.SecurityPolicy;
import com.filenet.api.util.Id;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Permission;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8AddItemAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String contentSourceType = request.getParameter("parm_content_source_type");
        if (contentSourceType != null && contentSourceType.equalsIgnoreCase("Folder")) {
            String strJsonFormData = this.readJSON(request);
            JSONArray jsonArray = JSONArray.parse(strJsonFormData);
            request.setAttribute("json_post", (Object)jsonArray);
        } else {
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonItem = new JSONObject();
            jsonArray.add(jsonItem);
            String criterias = request.getParameter("criterias");
            JSONArray criteriasJsonArray = JSONArray.parse(criterias);
            jsonItem.put("criterias", criteriasJsonArray);
            String permissionJSON = request.getParameter("acl");
            if (permissionJSON != null) {
                JSONArray permissionJSONArray = JSONArray.parse(permissionJSON);
                jsonItem.put("acl", permissionJSONArray);
            }
            request.setAttribute("json_post", (Object)jsonArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        boolean errorMessageHandled = false;
        ActionForward actionForward = null;
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        searchResultsMediator.setResponseAsHtml(((FileUploadActionForm)form).getUploadFile() != null);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        ClassDescription classDescription = null;
        Folder parentFolder = null;
        Connection connection2 = ceConnection;
        synchronized (connection2) {
            block30: {
                try {
                    AccessPermissionList apl;
                    this.getConfigInfo(request);
                    String serverName = request.getParameter("repositoryId");
                    String className = request.getParameter("template_name");
                    String contentSourceType = request.getParameter("parm_content_source_type");
                    String folderPID = request.getParameter("docid");
                    String securityPolicyId = request.getParameter("securityPolicyId");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: className = " + className);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: contentSourceType = " + contentSourceType);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: parent folderID = " + folderPID);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: securityPolicy = " + securityPolicyId);
                    searchResultsMediator.setServer(connection);
                    searchResultsMediator.setServerName(serverName);
                    ObjectStore objectStore = P8Util.getObjectStore(request, connection, null);
                    classDescription = Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)className, null);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, " classDescription.get_Id(); = " + classDescription.get_Id());
                    SecurityPolicy securityPolicy = null;
                    if (securityPolicyId != null && securityPolicyId.length() > 0) {
                        Id secPolicyId = new Id(securityPolicyId);
                        try {
                            securityPolicy = Factory.SecurityPolicy.fetchInstance((ObjectStore)objectStore, (Id)secPolicyId, null);
                        }
                        catch (Exception e) {
                            securityPolicy = Factory.SecurityPolicy.getInstance((ObjectStore)objectStore, (String)"SecurityPolicy", (Id)secPolicyId);
                        }
                    }
                    searchResultsMediator.addClassDescription(classDescription);
                    if (folderPID != null && folderPID.length() > 0) {
                        parentFolder = P8Util.getFolder(request, connection, folderPID);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parent folder was retrieved with the id = " + parentFolder);
                    } else if (contentSourceType.equalsIgnoreCase("Folder")) {
                        parentFolder = Factory.Folder.getInstance((ObjectStore)objectStore, null, (String)"/");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "root folder is used for parent");
                    }
                    JSONArray jsonArray = (JSONArray)this.getJSONRequest(request);
                    JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                    JSONArray criteriasJsonArray = (JSONArray)jsonObj.get("criterias");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criteriasJsonArray = " + criteriasJsonArray);
                    JSONArray permissionJsonArray = (JSONArray)jsonObj.get("acl");
                    if (contentSourceType.equalsIgnoreCase("Folder")) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "create folder");
                        Folder folder = Factory.Folder.createInstance((ObjectStore)objectStore, (String)classDescription.get_Id().toString());
                        if (securityPolicy != null) {
                            folder.set_SecurityPolicy(securityPolicy);
                        }
                        folder.set_Parent(parentFolder);
                        P8Util.setProperties(request, (IndependentObject)folder, criteriasJsonArray, classDescription);
                        AccessPermissionList apl2 = P8Permission.getPermissionsFromJSON(permissionJsonArray);
                        if (apl2 != null) {
                            folder.set_Permissions(apl2);
                        }
                        try {
                            folder.save(RefreshMode.REFRESH);
                        }
                        catch (EngineRuntimeException e) {
                            String folderName = "";
                            PropertyDescriptionList propertyDescriptionList = classDescription.get_PropertyDescriptions();
                            Integer iObj = classDescription.get_NamePropertyIndex();
                            if (iObj != null) {
                                String folderNameProperty = ((PropertyDescription)propertyDescriptionList.get(iObj.intValue())).get_SymbolicName();
                                folderName = folder.getProperties().getObjectValue(folderNameProperty).toString();
                            }
                            if (folderName == null) {
                                folderName = "";
                            }
                            String parentFolderName = "";
                            if (parentFolder != null) {
                                parentFolderName = parentFolder.get_Name();
                            }
                            if (e.getExceptionCode() == ExceptionCode.E_NOT_UNIQUE) {
                                searchResultsMediator.addError("addfolder.error.name.exists.in.folder", folderName, parentFolderName);
                                errorMessageHandled = true;
                            }
                            throw e;
                        }
                        ArrayList<Folder> hits = new ArrayList<Folder>(1);
                        hits.add(folder);
                        P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                        searchResultsBean.setHits(hits);
                        searchResultsMediator.setSearchResultsBean(searchResultsBean);
                        searchResultsMediator.setResponseAsHtml(false);
                        searchResultsMediator.addMessage("addFolder.success", new Object[0]);
                        break block30;
                    }
                    String classId = classDescription.get_Id().toString();
                    Document doc = Factory.Document.createInstance((ObjectStore)objectStore, (String)classId, (Id)Id.createId());
                    P8Util.setProperties(request, (IndependentObject)doc, criteriasJsonArray, classDescription);
                    if (contentSourceType.equalsIgnoreCase("Document") || contentSourceType.equalsIgnoreCase("ExternalURL")) {
                        this.setContent(request, doc, contentSourceType, form);
                    }
                    if (securityPolicy != null) {
                        doc.set_SecurityPolicy(securityPolicy);
                    }
                    if ((apl = P8Permission.getPermissionsFromJSON(permissionJsonArray)) != null) {
                        doc.set_Permissions(apl);
                    }
                    UpdatingBatch ub = UpdatingBatch.createUpdatingBatchInstance((Domain)connection.getDomain(), (RefreshMode)RefreshMode.REFRESH);
                    ub.add((IndependentlyPersistableObject)doc, null);
                    Document updateDoc = Factory.Document.getInstance((ObjectStore)objectStore, (String)classId, (Id)new Id(doc.getObjectReference().getObjectIdentity()));
                    AutoClassify autoClassify = this.getBooleanRequestParameter(request, "autoClassify", false) ? AutoClassify.AUTO_CLASSIFY : AutoClassify.DO_NOT_AUTO_CLASSIFY;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "auto classify = " + (autoClassify == AutoClassify.AUTO_CLASSIFY));
                    CheckinType checkinType = this.getBooleanRequestParameter(request, "asMinorVersion", false) ? CheckinType.MINOR_VERSION : CheckinType.MAJOR_VERSION;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add asMinorVersion = " + (checkinType == CheckinType.MINOR_VERSION));
                    updateDoc.checkin(autoClassify, checkinType);
                    ub.add((IndependentlyPersistableObject)updateDoc, null);
                    AutoUniqueName autoUniqueName = this.getBooleanRequestParameter(request, "allowDuplicateFileNames", true) ? AutoUniqueName.AUTO_UNIQUE : AutoUniqueName.NOT_AUTO_UNIQUE;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "auto unique name = " + (autoUniqueName == AutoUniqueName.AUTO_UNIQUE));
                    boolean setSecurityParent = this.getBooleanRequestParameter(request, "set_security_parent", false);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "set security parent = " + setSecurityParent);
                    String containmentName = null;
                    if (parentFolder != null) {
                        String filePath;
                        if (contentSourceType.equalsIgnoreCase("Document") && autoUniqueName == AutoUniqueName.NOT_AUTO_UNIQUE && (filePath = request.getParameter("parm_part_filename")) != null && filePath.length() != 0 && (containmentName = Util.getFileNameFromPath(request, filePath)) != null && containmentName.length() == 0) {
                            containmentName = null;
                        }
                        ReferentialContainmentRelationship rcr = parentFolder.file((IndependentlyPersistableObject)doc, autoUniqueName, autoUniqueName == AutoUniqueName.AUTO_UNIQUE ? null : containmentName, setSecurityParent ? DefineSecurityParentage.DEFINE_SECURITY_PARENTAGE : DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
                        ub.add((IndependentlyPersistableObject)rcr, null);
                    }
                    try {
                        ub.updateBatch();
                    }
                    catch (EngineRuntimeException e) {
                        if (containmentName == null) {
                            containmentName = "";
                        }
                        String parentFolderName = "";
                        if (parentFolder != null) {
                            parentFolderName = parentFolder.get_Name();
                        }
                        if (e.getExceptionCode() == ExceptionCode.E_NOT_UNIQUE) {
                            searchResultsMediator.addError("additem.error.name.exists.in.folder", containmentName, parentFolderName);
                            errorMessageHandled = true;
                        }
                        throw e;
                    }
                    ArrayList<Document> hits = new ArrayList<Document>(1);
                    hits.add(updateDoc);
                    P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                    searchResultsBean.setHits(hits);
                    searchResultsMediator.setSearchResultsBean(searchResultsBean);
                    searchResultsMediator.addMessage("addDocument.success", new Object[0]);
                }
                catch (Exception e) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    if (errorMessageHandled) break block30;
                    searchResultsMediator.addError("error.exception.general", e.getMessage());
                }
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        Boolean maxFileSizeExceeded;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if ((maxFileSizeExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxFileSizeExceeded.booleanValue()) {
            baseMediator.addError("import.filesize.exceed.maxlength");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String contentSourceType = request.getParameter("parm_content_source_type");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "contentSourceType = " + contentSourceType);
        if (contentSourceType.equalsIgnoreCase("Document")) {
            String partMimeType = request.getParameter("mimetype");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partMimeType = " + (partMimeType != null ? partMimeType : ""));
            String partLength = request.getParameter("parm_part_length");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partLength = " + partLength);
            String partFileName = request.getParameter("parm_part_filename");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partFileName = " + partFileName);
        }
    }
}

