/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.od;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.od.ODDocumentMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.od.ODBaseAction;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.Util;
import com.ibm.edms.od.ODConfig;
import com.ibm.edms.od.ODConstant;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODFolder;
import com.ibm.edms.od.ODHit;
import com.ibm.edms.od.ODServer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class ODRetrieveDocumentAction
extends ODBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        String methodName;
        block100: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            ActionErrors errors = new ActionErrors();
            actionForward = null;
            Object servers = null;
            HttpSession session = request.getSession(false);
            MessageResources resources = this.getResources(request);
            ODServer server = null;
            ODFolder folder = null;
            Object synchObject = new Object();
            String mimetype = null;
            String fileExtension = "";
            String fileName = "";
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
            String folderName = request.getParameter("template_name");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: folderName = " + folderName);
            String documentID = request.getParameter("docid");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
            String transform = request.getParameter("transform");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
            String altOutput = request.getParameter("alt_output");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
            String includeSegmentInfoString = request.getParameter("include_segment_info");
            boolean includeSegmentInfo = false;
            if (includeSegmentInfoString != null) {
                includeSegmentInfo = Boolean.valueOf(includeSegmentInfoString);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: include_segment_info = " + includeSegmentInfoString);
            String segmentNumString = request.getParameter("segment_num");
            int segmentNum = -1;
            if (segmentNumString != null) {
                segmentNum = Integer.valueOf(segmentNumString);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: segment_num = " + segmentNumString);
            ODDocumentMediator documentMediator = (ODDocumentMediator)this.getMediator(request);
            if (repositoryId == null || repositoryId.trim().length() < 1) {
                documentMediator.addError("error.parm.null", "repositoryId");
            }
            if (folderName == null || folderName.trim().length() < 1) {
                documentMediator.addError("error.parm.null", "template_name");
            }
            if (documentID == null || documentID.trim().length() < 1) {
                documentMediator.addError("error.parm.null", "docid");
            }
            try {
                server = ODRetrieveDocumentAction.getConnection(request);
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                documentMediator.addError("error.exception.general", e.getMessage());
                this.writeJSONMediator(request, response);
                return actionForward;
            }
            Object object = synchObject = server == null ? new Object() : server;
            synchronized (object) {
                File tempFile = null;
                if (repositoryId == null) {
                    documentMediator.addError("error.parm.null", "repositoryId");
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering code area...");
                    if (altOutput == null || !altOutput.equalsIgnoreCase("JSON")) {
                        ActionForward actionForward2;
                        block98: {
                            try {
                                block99: {
                                    try {
                                        String tempZipFileName;
                                        String[] documentIDs = request.getParameterValues("docid");
                                        if (documentIDs.length == 1) {
                                            folder = this.openFolder(request, server, folderName);
                                            documentMediator.setFolder(folder);
                                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Opened folder: " + folderName);
                                            ODHit hit = folder.recreateHit(documentID);
                                            documentMediator.setDocID(hit.getDocId());
                                            documentMediator.setHit(hit);
                                            documentMediator.setShowFieldHoverHelp(this.getShowFieldHoverHelp());
                                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Recreated hit. " + folderName);
                                            ODConfig config = ODRetrieveDocumentAction.getConfig(request, repositoryId);
                                            mimetype = null;
                                            if (transform == null || transform.trim().length() < 1) {
                                                transform = ODConstant.NATIVE;
                                                if (config != null) {
                                                    if (hit.getDocType() == 'A') {
                                                        if (config.getAfpViewerType() == ODConstant.PDF || config.getAfpViewerType() == ODConstant.HTML) {
                                                            transform = config.getAfpViewerType();
                                                        }
                                                    } else if (hit.getDocType() == 'L' && (config.getLineViewerType() == ODConstant.ASCII || config.getLineViewerType() == ODConstant.PDF || config.getLineViewerType() == ODConstant.HTML)) {
                                                        transform = config.getLineViewerType();
                                                    }
                                                }
                                            }
                                            if (transform.equals(ODConstant.NATIVE) || transform.equals(ODConstant.ASCII)) {
                                                int endSegment;
                                                int startSegment;
                                                long approxDocLength;
                                                int nSegments;
                                                long maxInMemoryRetrieveLength;
                                                mimetype = MimeTypeUtil.getMimeTypeForOD(hit.getMimeType());
                                                if (mimetype == null || mimetype.equals("application/unknown")) {
                                                    String extension = hit.getFileExt();
                                                    mimetype = MimeTypeUtil.getMimeType(extension);
                                                }
                                                response.setContentType(mimetype);
                                                fileExtension = hit.getFileExt();
                                                if (fileExtension == null || fileExtension.equals("")) {
                                                    fileExtension = MimeTypeUtil.getExtFromMimeType(mimetype);
                                                }
                                                fileName = Util.getValidFileName(hit.getDocumentName() + "." + fileExtension);
                                                response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, fileName));
                                                long maxDocLength = this.getMaxDownloadSizeProperty(request, repositoryId);
                                                if (maxDocLength == 0L) {
                                                    maxDocLength = 0x7FFFFFF3L;
                                                }
                                                if ((maxInMemoryRetrieveLength = this.getMaxInMemoryRetrieveSizeProperty(request, repositoryId)) == 0L) {
                                                    maxInMemoryRetrieveLength = 0x100000L;
                                                }
                                                long firstSegmentLength = hit.getProperties().getLength();
                                                byte[] tempData = null;
                                                if (firstSegmentLength <= maxDocLength) {
                                                    if (firstSegmentLength > maxInMemoryRetrieveLength) {
                                                        tempFile = File.createTempFile("ContentNavigator", ".dat");
                                                        hit.retrieve(transform, tempFile.getCanonicalPath());
                                                    } else {
                                                        tempData = hit.retrieve(transform);
                                                        firstSegmentLength = tempData.length;
                                                    }
                                                }
                                                if ((nSegments = hit.getNumSegments()) == 0) {
                                                    nSegments = 1;
                                                }
                                                if ((approxDocLength = firstSegmentLength * (long)nSegments) > maxDocLength) {
                                                    documentMediator.addError("error.documentTooLarge");
                                                    documentMediator.sendErrorResponse(response);
                                                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                                                    actionForward2 = actionForward;
                                                    Object var50_62 = null;
                                                    if (tempFile != null) {
                                                        tempFile.delete();
                                                    }
                                                    break block98;
                                                }
                                                if (includeSegmentInfo) {
                                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Segment-Count: " + hit.getNumSegments());
                                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Segment-Page-Count: " + hit.getNumPagesInSegment());
                                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Segment-Last-Page-Count: " + hit.getNumPagesInLastSegment());
                                                    response.setHeader("Segment-Count", String.valueOf(hit.getNumSegments()));
                                                    response.setHeader("Segment-Page-Count", String.valueOf(hit.getNumPagesInSegment()));
                                                    response.setHeader("Segment-Last-Page-Count", String.valueOf(hit.getNumPagesInLastSegment()));
                                                }
                                                ServletOutputStream os = response.getOutputStream();
                                                if (segmentNum >= 0) {
                                                    startSegment = segmentNum;
                                                    endSegment = segmentNum;
                                                } else {
                                                    startSegment = 0;
                                                    endSegment = nSegments - 1;
                                                }
                                                for (int i = startSegment; i <= endSegment; ++i) {
                                                    if (tempFile != null) {
                                                        if (i > 0) {
                                                            tempFile = File.createTempFile("ContentNavigator", ".dat");
                                                            hit.retrieveSegment(i, tempFile.getCanonicalPath());
                                                        }
                                                        if (startSegment == endSegment & hit.getResourceID() == null) {
                                                            if (includeSegmentInfo) {
                                                                response.setContentLength((int)tempFile.length() + 12);
                                                            } else {
                                                                response.setContentLength((int)tempFile.length());
                                                            }
                                                        }
                                                        BufferedInputStream tempFileInputStream = new BufferedInputStream(new FileInputStream(tempFile));
                                                        byte[] buffer = new byte[(int)maxInMemoryRetrieveLength];
                                                        int readLen = ((InputStream)tempFileInputStream).read(buffer);
                                                        while (readLen > 0) {
                                                            os.write(buffer, 0, readLen);
                                                            readLen = ((InputStream)tempFileInputStream).read(buffer);
                                                        }
                                                        if (transform.equals(ODConstant.ASCII) && i != endSegment) {
                                                            os.write(12);
                                                        }
                                                        ((InputStream)tempFileInputStream).close();
                                                        tempFile.delete();
                                                        continue;
                                                    }
                                                    if (i > 0) {
                                                        tempData = hit.retrieveSegment(i);
                                                    }
                                                    if (startSegment == endSegment && hit.getResourceID() == null) {
                                                        if (includeSegmentInfo) {
                                                            response.setContentLength(tempData.length);
                                                        } else {
                                                            response.setContentLength(tempData.length);
                                                        }
                                                    }
                                                    os.write(tempData);
                                                    if (!transform.equals(ODConstant.ASCII) || i == endSegment) continue;
                                                    os.write(12);
                                                }
                                                try {
                                                    byte[] documentResources;
                                                    if (hit.getResourceID() != null && (documentResources = hit.getResources()) != null) {
                                                        os.write(documentResources);
                                                    }
                                                }
                                                catch (ODException e) {
                                                    // empty catch block
                                                }
                                                os.close();
                                                break block99;
                                            }
                                            byte[] document = hit.retrieve(transform);
                                            if (mimetype == null) {
                                                mimetype = hit.getViewMimeType();
                                            }
                                            int documentLength = 0;
                                            if (document != null) {
                                                documentLength = document.length;
                                            }
                                            if (documentLength == 0) {
                                                documentMediator.setPartSize(hit.getProperties().getLength());
                                            } else {
                                                documentMediator.setPartSize(documentLength);
                                            }
                                            fileExtension = hit.getViewExt();
                                            if (fileExtension == null || fileExtension.equals("")) {
                                                fileExtension = MimeTypeUtil.getExtFromMimeType(mimetype);
                                            }
                                            fileName = Util.getValidFileName(hit.getDocumentName() + "." + fileExtension);
                                            documentMediator.setMimeType(mimetype);
                                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Document retrieved: bytes length=" + documentLength + " transform=" + transform + " mimetype=" + mimetype + " fileName=" + fileName + " fileExtension=" + fileExtension);
                                            response.setContentType(mimetype);
                                            if ("native".equalsIgnoreCase(transform)) {
                                                response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, fileName));
                                            }
                                            response.setContentLength(document.length);
                                            ServletOutputStream os = response.getOutputStream();
                                            os.write(document);
                                            os.close();
                                            break block99;
                                        }
                                        File tempZipFile = File.createTempFile("ContentNavigator", ".zip");
                                        String responseFileName = tempZipFileName = tempZipFile.getPath();
                                        tempZipFile.delete();
                                        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempZipFileName));
                                        folder = this.openFolder(request, server, folderName);
                                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add documents to temp zip file: " + tempZipFileName);
                                        for (int docCount = 0; docCount < documentIDs.length; ++docCount) {
                                            ODHit hit = folder.recreateHit(documentIDs[docCount]);
                                            fileExtension = hit.getFileExt();
                                            if (fileExtension == null || fileExtension.equals("")) {
                                                fileExtension = MimeTypeUtil.getExtFromMimeType(MimeTypeUtil.getMimeTypeForOD(hit.getMimeType()));
                                            }
                                            fileName = Util.getValidFileName(hit.getDocumentName() + "." + fileExtension);
                                            int attemptCount = 0;
                                            boolean noException = false;
                                            String zipEntryName = fileName;
                                            while (attemptCount < documentIDs.length && !noException) {
                                                try {
                                                    zos.putNextEntry(new ZipEntry(zipEntryName));
                                                    noException = true;
                                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add document to temp zip file: " + zipEntryName);
                                                }
                                                catch (ZipException ze) {
                                                    int index = fileName.lastIndexOf(46);
                                                    zipEntryName = index > -1 ? fileName.substring(0, index) + "(" + (attemptCount + 2) + ")" + fileName.substring(index) : fileName + "(" + (attemptCount + 2) + ")";
                                                    ++attemptCount;
                                                }
                                            }
                                            if (!noException) continue;
                                            if (docCount == 0) {
                                                responseFileName = fileName;
                                            }
                                            tempFile = File.createTempFile("ContentNavigator", ".dat");
                                            hit.retrieve(transform, tempFile.getCanonicalPath());
                                            InputStream tempFileInputStream = new BufferedInputStream(new FileInputStream(tempFile));
                                            int endSegment = hit.getNumSegments() == 0 ? 1 : hit.getNumSegments();
                                            for (int i = 0; i < endSegment; ++i) {
                                                if (i != 0) {
                                                    tempFile = File.createTempFile("ContentNavigator", ".dat");
                                                    hit.retrieveSegment(i, tempFile.getCanonicalPath());
                                                    tempFileInputStream = new FileInputStream(tempFile);
                                                }
                                                Util.copyStream(tempFileInputStream, zos, false);
                                                ((InputStream)tempFileInputStream).close();
                                                tempFile.delete();
                                            }
                                            try {
                                                byte[] documentResources;
                                                if (hit.getResourceID() != null && (documentResources = hit.getResources()) != null) {
                                                    zos.write(documentResources);
                                                }
                                            }
                                            catch (ODException e) {
                                                // empty catch block
                                            }
                                            zos.closeEntry();
                                        }
                                        int index = responseFileName.lastIndexOf(46);
                                        if (index > -1) {
                                            responseFileName = responseFileName.substring(0, index);
                                        }
                                        zos.close();
                                        tempZipFile = new File(tempZipFileName);
                                        response.setHeader("Content-Type", "application/octet-stream");
                                        response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, responseFileName + ".zip"));
                                        response.setContentLength((int)tempZipFile.length());
                                        ServletOutputStream outputStream = response.getOutputStream();
                                        Util.copyStream(new FileInputStream(tempZipFile), (OutputStream)outputStream, true);
                                        tempZipFile.delete();
                                    }
                                    catch (ODException ode) {
                                        this.logFDC(request, response, null, methodName);
                                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ode);
                                        documentMediator.addError("error.exception.ondemand", ode.getErrorMsg(), new Integer(ode.getErrorId() & 0xFFFF));
                                        documentMediator.sendErrorResponse(response);
                                        Object var50_64 = null;
                                        if (tempFile != null) {
                                            tempFile.delete();
                                        }
                                        if (folder != null) {
                                            folder.close();
                                        }
                                        break block100;
                                    }
                                    catch (Exception e) {
                                        if (e.getClass().getName().endsWith("ClosedConnectionException") || e.getClass().getName().endsWith("ClientAbortException")) {
                                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Client closed connection before reading entire response");
                                        } else {
                                            this.logFDC(request, response, null, methodName);
                                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                                            documentMediator.addError("error.exception.general");
                                            documentMediator.sendErrorResponse(response);
                                        }
                                        Object var50_65 = null;
                                        if (tempFile != null) {
                                            tempFile.delete();
                                        }
                                        if (folder != null) {
                                            folder.close();
                                        }
                                        break block100;
                                    }
                                }
                                Object var50_63 = null;
                                if (tempFile != null) {
                                    tempFile.delete();
                                }
                                if (folder != null) {
                                    folder.close();
                                }
                                break block100;
                            }
                            catch (Throwable throwable) {
                                Object var50_66 = null;
                                if (tempFile != null) {
                                    tempFile.delete();
                                }
                                if (folder != null) {
                                    folder.close();
                                }
                                throw throwable;
                            }
                        }
                        if (folder != null) {
                            folder.close();
                        }
                        return actionForward2;
                    }
                    try {
                        folder = this.openFolder(request, server, folderName);
                        documentMediator.setFolder(folder);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Opened folder: " + folderName);
                        ODHit hit = folder.recreateHit(documentID);
                        documentMediator.setDocID(hit.getDocId());
                        documentMediator.setHit(hit);
                        documentMediator.setShowFieldHoverHelp(this.getShowFieldHoverHelp());
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Recreated hit. " + folderName);
                        ODConfig config = ODRetrieveDocumentAction.getConfig(request, repositoryId);
                        mimetype = null;
                        if (transform == null || transform.trim().length() < 1) {
                            transform = ODConstant.NATIVE;
                            if (config != null) {
                                if (hit.getDocType() == 'A') {
                                    if (config.getAfpViewerType() == ODConstant.PDF || config.getAfpViewerType() == ODConstant.HTML) {
                                        transform = config.getAfpViewerType();
                                    }
                                } else if (hit.getDocType() == 'L' && (config.getLineViewerType() == ODConstant.ASCII || config.getLineViewerType() == ODConstant.PDF || config.getLineViewerType() == ODConstant.HTML)) {
                                    transform = config.getLineViewerType();
                                }
                            }
                        }
                        byte[] document = null;
                        try {
                            document = hit.retrieve(transform);
                        }
                        catch (ODException e) {
                            // empty catch block
                        }
                        if (mimetype == null) {
                            mimetype = hit.getViewMimeType();
                        }
                        int documentLength = 0;
                        if (document != null) {
                            documentLength = document.length;
                        }
                        if (documentLength == 0) {
                            documentMediator.setPartSize(hit.getProperties().getLength());
                        } else {
                            documentMediator.setPartSize(documentLength);
                        }
                        fileExtension = hit.getViewExt();
                        if (fileExtension == null || fileExtension.equals("")) {
                            fileExtension = MimeTypeUtil.getExtFromMimeType(mimetype);
                        }
                        fileName = Util.getValidFileName(hit.getDocumentName() + "." + fileExtension);
                        documentMediator.setMimeType(mimetype);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Document retrieved: bytes length=" + documentLength + " transform=" + transform + " mimetype=" + mimetype + " fileName=" + fileName + " fileExtension=" + fileExtension);
                    }
                    catch (ODException ode) {
                        this.logFDC(request, response, null, methodName);
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ode);
                        documentMediator.addError("error.exception.ondemand", ode.getErrorMsg(), new Integer(ode.getErrorId() & 0xFFFF));
                    }
                    catch (Exception e) {
                        this.logFDC(request, response, null, methodName);
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        documentMediator.addError("error.exception.general");
                    }
                    response.setContentType("text/json");
                    byte[] results = documentMediator.toJSONString().getBytes("UTF8");
                    response.setContentLength(results.length);
                    ServletOutputStream os = response.getOutputStream();
                    os.write(results);
                    os.close();
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private long getMaxDownloadSizeProperty(HttpServletRequest request, String repositoryId) {
        String methodName = "getMaxDownloadSizeProperty";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        try {
            RepositoryConfig repositoryConfig = Config.getRepositoryConfig("navigator", repositoryId);
            if (repositoryConfig != null) {
                long maxDownloadSize = repositoryConfig.getMaxDownloadSize();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, String.valueOf(maxDownloadSize));
                Logger.logExit((Object)this, methodName, (ServletRequest)request);
                return maxDownloadSize;
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return 0L;
    }

    private long getMaxInMemoryRetrieveSizeProperty(HttpServletRequest request, String repositoryId) {
        String methodName = "getMaxInMemoryRetrieveSizeProperty";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        try {
            RepositoryConfig repositoryConfig = Config.getRepositoryConfig("navigator", repositoryId);
            if (repositoryConfig != null) {
                long maxInMemoryRetrieveSize = repositoryConfig.getMaxInMemoryRetrieveSize();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, String.valueOf(maxInMemoryRetrieveSize));
                Logger.logExit((Object)this, methodName, (ServletRequest)request);
                return maxInMemoryRetrieveSize;
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return 0L;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        ODDocumentMediator documentMediator = new ODDocumentMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)documentMediator);
        return documentMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String folderName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: folderName = " + folderName);
        String documentID = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
        String transform = request.getParameter("transform");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
    }
}

