/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.od;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.od.ODFoldersMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.od.ODBaseAction;
import com.ibm.edms.od.ODCabinet;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODServer;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class ODOpenCabinetAction
extends ODBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        String methodName;
        block12: {
            methodName = "executeAction";
            ActionErrors errors = new ActionErrors();
            actionForward = null;
            HttpSession session = request.getSession(false);
            MessageResources resources = this.getResources(request);
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            ODServer server = null;
            Object synchObject = new Object();
            Enumeration cabinets = null;
            ODFoldersMediator foldersMediator = (ODFoldersMediator)this.getMediator(request);
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
            String cabinetName = request.getParameter("cabinet_name");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "cabinetName = " + cabinetName);
            try {
                if (repositoryId != null) {
                    server = ODOpenCabinetAction.getConnection(request);
                    Object object = synchObject = server == null ? new Object() : server;
                    synchronized (object) {
                        if (cabinetName == null || cabinetName.trim().length() < 1) {
                            foldersMediator.addError("error.parm.null", "cabinet_name");
                        }
                        cabinets = server.getCabinets();
                        int foldersCount = 0;
                        ODCabinet cabinet = null;
                        boolean found = false;
                        while (cabinets.hasMoreElements() && !found) {
                            cabinet = (ODCabinet)cabinets.nextElement();
                            if (!cabinet.getName().equals(cabinetName)) continue;
                            found = true;
                            cabinet.open();
                            foldersCount = cabinet.getNumFolders();
                            String[] folderNames = cabinet.getFolderNames();
                            for (int i = 0; i < foldersCount; ++i) {
                                String folderDesc = server.getFolderDescription(folderNames[i]);
                                foldersMediator.addFolder(folderNames[i], folderDesc);
                            }
                        }
                        if (foldersCount == 0) {
                            foldersMediator.addMessage("cabinet.folders.notfound", new Object[0]);
                        } else {
                            foldersMediator.addMessage("folders.search.successful", foldersCount);
                        }
                        break block12;
                    }
                }
                foldersMediator.addError("error.parm.null");
            }
            catch (ODException ode) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ode);
                foldersMediator.addError("error.exception.ondemand", ode.getErrorMsg(), new Integer(ode.getErrorId() & 0xFFFF));
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                foldersMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        ODFoldersMediator foldersMediator = new ODFoldersMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)foldersMediator);
        return foldersMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String cabinetName = request.getParameter("cabinet_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "cabinetName = " + cabinetName);
    }
}

