/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.od;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ODLoginConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.od.ODLogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.SSOLogonAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.struts.actions.od.ODBaseAction;
import com.ibm.ecm.util.J2EEServerUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.edms.od.ODConfig;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODServer;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class ODLogonAction
extends ODBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    public static final String OD_SERVER_TYPE = "od";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        String methodName;
        block45: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            actionForward = null;
            HttpSession session = null;
            ODServer server = null;
            String userid = ODUtil.xSSEncode(request.getParameter("userid"));
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
            String password = request.getParameter("password");
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repository = " + repositoryId);
            String desktopName = request.getParameter("desktop");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
            String repoId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repoId = " + repoId);
            String serverIP = request.getParameter("serverName");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverIP);
            String portNumber = request.getParameter("portNumber");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "portNumber = " + portNumber);
            String useSSL = request.getParameter("useSSL");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "useSSL = " + useSSL);
            String sslKeyringDB = request.getParameter("keyringDBFile");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "keyringDBFile = " + sslKeyringDB);
            String sslKeyringStash = request.getParameter("keyringStashFile");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "keyringStashFile = " + sslKeyringStash);
            ODLogonMediator logonMediator = (ODLogonMediator)this.getMediator(request);
            if (userid != null && userid.length() > 128 || password != null && password.length() > 128) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "User ID and/or password exceeded maximum allowed sized by OD; stopping logon attempt.");
                logonMediator.addError("error.bad.userid.password");
            } else {
                session = request.getSession(true);
                if (session != null && userid != null) {
                    session.setAttribute("session_userid", (Object)userid);
                }
                try {
                    if (repositoryId != null) {
                        if (server == null || !userid.equals(server.getUserId()) || !password.equals(server.getPassword())) {
                            ApplicationConfig applicationConfig;
                            SettingsConfig settingConfig;
                            String propertyValue;
                            int maxHits;
                            int iServerPort = 0;
                            ODConfig odConfig = null;
                            RepositoryConfig repositoryConfig = null;
                            if (serverIP == null && (repositoryConfig = Config.getRepositoryConfig(request)) != null) {
                                serverIP = repositoryConfig.getServerName();
                                portNumber = repositoryConfig.getPortNumber();
                            }
                            ODLoginConfig odLoginConfig = Config.getODLoginConfig("navigator", repositoryId);
                            if (repositoryConfig == null) {
                                repositoryConfig = Config.getRepositoryConfig(request);
                            }
                            if ((maxHits = repositoryConfig.getMaxResults()) == 0) {
                                odLoginConfig.setStrMaxHits("-1");
                            } else {
                                odLoginConfig.setStrMaxHits(new Integer(maxHits).toString());
                            }
                            if (useSSL == null || useSSL.length() < 1) {
                                useSSL = repositoryConfig.getODSSL();
                            }
                            if (sslKeyringDB == null || sslKeyringDB.length() < 1) {
                                sslKeyringDB = repositoryConfig.getODKeyringDBFile();
                            }
                            if (sslKeyringStash == null || sslKeyringStash.length() < 1) {
                                sslKeyringStash = repositoryConfig.getODKeyringStashFile();
                            }
                            if ((propertyValue = repositoryConfig.getAfp2PdfConfigFile()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setAfp2PdfConfigFile(propertyValue);
                            }
                            if ((propertyValue = repositoryConfig.getTransformXMLFile()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setTransformXMLFile(propertyValue);
                            }
                            if ((propertyValue = repositoryConfig.getODSSL()) == null || propertyValue.length() < 1) {
                                propertyValue = "false";
                            }
                            odLoginConfig.setOdSSL(propertyValue);
                            propertyValue = repositoryConfig.getODKeyringDBFile();
                            if (propertyValue != null && propertyValue.length() > 0) {
                                odLoginConfig.setOdKeyringDBFile(propertyValue);
                            }
                            if ((propertyValue = repositoryConfig.getODKeyringStashFile()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setOdKeyringStashFile(propertyValue);
                            }
                            if ((propertyValue = repositoryConfig.getCustomProperties()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setCustomProperties(propertyValue);
                            }
                            if ((propertyValue = (settingConfig = Config.getSettingsConfig((applicationConfig = Config.getApplicationConfig(request)).getObjectId())).getODLanguage()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setLanguage(propertyValue);
                            }
                            if ((propertyValue = settingConfig.getODTempdir()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setTempDir(propertyValue);
                            }
                            if ((propertyValue = settingConfig.getODTracelevelString()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setStrTraceLevel(propertyValue);
                            }
                            if ((propertyValue = settingConfig.getODTracedir()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setTraceDir(propertyValue);
                            }
                            if ((propertyValue = settingConfig.getODMaxTraceFilesizeString()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setStrMaxTraceFilesize(propertyValue);
                            }
                            if ((propertyValue = settingConfig.getODAfp2pdfInstalldir()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setAfp2PdfInstallDir(propertyValue);
                            }
                            if ((propertyValue = settingConfig.getCustomProperties()) != null && propertyValue.length() > 0) {
                                odLoginConfig.setGlobalCustomProperties(propertyValue);
                            }
                            if ((odConfig = odLoginConfig.getODConfig(request)) == null) {
                                odConfig = ODLogonAction.getConfig(request, repositoryId);
                            }
                            if (logonMediator.getCurrentRepositoryId() == null) {
                                logonMediator.setCurrentRepositoryId(repoId);
                            }
                            iServerPort = Integer.parseInt(portNumber);
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "The port for server '" + serverIP + "' is " + iServerPort);
                            request.setAttribute("userid", (Object)userid);
                            request.setAttribute("password", (Object)password);
                            request.setAttribute("repositoryId", (Object)repositoryId);
                            try {
                                boolean isWebsphere = J2EEServerUtil.getJ2EEAppServerType(this.getServlet().getServletContext()) == "websphere";
                                Subject subject = new ContainerLogonAction().doContainerLogin(request, response, userid, password, isWebsphere, logonMediator);
                                if (Config.getApplicationConfig(request).checkAdminAccessForUser(userid)) {
                                    logonMediator.setIsAdminUser("true");
                                } else {
                                    logonMediator.setIsAdminUser("false");
                                }
                            }
                            catch (Throwable t) {
                                logonMediator.setIsAdminUser("false");
                            }
                            server = new ODServer(odConfig);
                            ODLogonAction.setConfig(request, repositoryId, odConfig);
                            logonMediator.setServer(server);
                            String encodedDisplayName = URLEncoder.encode(repositoryId, "UTF-8");
                            server.initialize(response.encodeURL(request.getContextPath() + "/appletCallback/" + encodedDisplayName));
                            server.setUserId(userid);
                            server.setPassword(password);
                            server.setServerName(serverIP);
                            server.setPort(iServerPort);
                            server.setConnectType('T');
                            if (useSSL != null && useSSL.equalsIgnoreCase("true")) {
                                server.setSSL(true, sslKeyringDB, sslKeyringStash);
                            }
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invoking server.logon().");
                            Date date = Logger.logPerf((Object)this, methodName, (ServletRequest)request, "OD login start");
                            server.logon();
                            Logger.logPerf(this, methodName, (ServletRequest)request, date, "OD login completed");
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Finished invoking server.logon().");
                            ODLogonAction.storeNewConnection(request, server, repositoryId);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "ODWEK version = " + this.getODWEKVersion());
                            session = Util.replaceSession(request);
                        } else {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Re-using server object from session.");
                        }
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "No action errors returned.");
                        SSOLogonAction.doSSOLogonForP8(request, logonMediator);
                        SSOLogonAction.doSSOLogonForCM8(request, logonMediator);
                        SSOLogonAction.doSSOLogonForOD(request, response, logonMediator);
                        logonMediator.addMessage("logon.successful", userid);
                        break block45;
                    }
                    logonMediator.addError("error.parm.null", "repositoryId");
                }
                catch (ODException ode) {
                    if (server != null && server.isInitialized()) {
                        server.terminate();
                    }
                    if (ode != null && (ode.getErrorId() & 0xFFFF) == 2086) {
                        logonMediator.addError("error.server.unavailable");
                    } else if (ode != null && (ode.getErrorId() & 0xFFFF) == 2061) {
                        logonMediator.addError("error.password.expired");
                    } else if (ode != null && (ode.getErrorId() & 0xFFFF) == 2107) {
                        logonMediator.addError("error.bad.userid.password");
                    } else {
                        this.logFDC(request, response, null, methodName);
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ode);
                        logonMediator.addError("error.exception.ondemand", ode.getErrorMsg(), new Integer(ode.getErrorId() & 0xFFFF));
                    }
                }
                catch (Exception e) {
                    logonMediator.addError("error.fatal");
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    if (server != null && server.isInitialized()) {
                        server.terminate();
                    }
                    throw e;
                }
                catch (Throwable t) {
                    logonMediator.addError("error.fatal");
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, t);
                    if (server == null || !server.isInitialized()) break block45;
                    server.terminate();
                }
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String portNumber;
        String sslKeyringStash;
        String sslKeyringDB;
        String serverName;
        String methodName = "validateRequest";
        ODLogonMediator logonMediator = (ODLogonMediator)this.getMediator(request);
        MessageResources resources = this.getResources(request);
        String userid = ODUtil.xSSEncode(request.getParameter("userid"));
        HttpSession session = request.getSession(true);
        if (session != null && userid != null) {
            session.setAttribute("session_userid", (Object)userid);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        if (userid == null || userid.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "User ID was not found");
            logonMediator.addError("error.parm.null", "userid");
            this.setRequestHasErrors(request, true);
        }
        if (password == null || password.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Password was not found");
            logonMediator.addError("error.parm.null", "password");
            this.setRequestHasErrors(request, true);
        }
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Repository ID was not found");
            logonMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if ((serverName = request.getParameter("serverName")) != null && serverName.length() > 249) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "server name was found, but is invalid.");
            logonMediator.addError("error.exception.general");
            this.setRequestHasErrors(request, true);
        }
        if ((sslKeyringDB = request.getParameter("keyringDBFile")) != null && sslKeyringDB.length() > 255) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invalid SSL keyring DB specified in the request.");
            logonMediator.addError("error.exception.general");
            this.setRequestHasErrors(request, true);
        }
        if ((sslKeyringStash = request.getParameter("keyringStashFile")) != null && sslKeyringStash.length() > 255) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invalid SSL keyring stash specified in the request.");
            logonMediator.addError("error.exception.general");
            this.setRequestHasErrors(request, true);
        }
        if ((portNumber = request.getParameter("portNumber")) != null) {
            try {
                Integer i = Integer.parseInt(portNumber);
                if (i > Integer.MAX_VALUE) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invalid port number specified in the request.");
                    logonMediator.addError("error.exception.general");
                    this.setRequestHasErrors(request, true);
                }
            }
            catch (NumberFormatException e) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invalid port number specified in the request.");
                logonMediator.addError("error.exception.general");
                this.setRequestHasErrors(request, true);
            }
        }
        if (this.getRequestHasErrors(request)) {
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            return false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return true;
    }

    public static void storeNewConnection(HttpServletRequest request, ODServer server, String repositoryId) {
        String methodName = "storeNewConnection";
        if (repositoryId == null) {
            repositoryId = request.getParameter("repositoryId");
        }
        String userid = request.getParameter("userid");
        ODLogonAction.setConnection(request, server, repositoryId);
    }

    public static Hashtable getServerList(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return (Hashtable)session.getAttribute("od_servers");
    }

    public static void removeServerList(HttpServletRequest request) {
        String methodName = "removeServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            Hashtable od_server_List = ODLogonAction.getServerList(request);
            Logger.logDebug(ODLogonAction.class, methodName, (ServletRequest)request, "   current OD connection list: " + od_server_List);
            if (od_server_List != null) {
                Logger.logInfo(ODLogonAction.class, methodName, (ServletRequest)request, "current OD connection list size: " + od_server_List.size());
                session.removeAttribute("od_servers");
                Logger.logDebug(ODLogonAction.class, methodName, (ServletRequest)request, "   removed all OD connections from session: " + od_server_List);
            }
        }
    }

    public static void setServerList(HttpServletRequest request, Hashtable connectionList) {
        String methodName = "setServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("od_servers");
            if (connectionList != null) {
                Logger.logDebug(ODLogonAction.class, methodName, (ServletRequest)request, "   add OD connections from session: " + connectionList);
                Object[] keys = connectionList.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    Logger.logDebug(ODLogonAction.class, methodName, (ServletRequest)request, "   add OD connection: " + (String)keys[i]);
                    ODServer connection = (ODServer)connectionList.get((String)keys[i]);
                    ODLogonAction.storeNewConnection(request, connection, (String)keys[i]);
                }
            }
        }
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        ODLogonMediator logonMediator = new ODLogonMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)logonMediator);
        return logonMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String displayName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "displayName = " + displayName);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        String repoId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repoId = " + repoId);
    }
}

