/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.od;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ODLoginConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.od.ODLogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.od.ODLogonAction;
import com.ibm.ecm.util.Util;
import com.ibm.edms.od.ODConfig;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODServer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class ODChangePasswordAction
extends ODLogonAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String displayName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repositoryId = " + displayName);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        String methodName;
        block29: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            ActionErrors errors = new ActionErrors();
            actionForward = null;
            HttpSession session = null;
            ODServer server = null;
            MessageResources resources = this.getResources(request);
            String userid = request.getParameter("userid");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
            String password = request.getParameter("password");
            String newPassword = request.getParameter("new_password");
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
            String desktopName = request.getParameter("desktop");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
            String repoId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repoId = " + repoId);
            Object synchObject = new Object();
            ODLogonMediator logonMediator = (ODLogonMediator)this.getMediator(request);
            session = request.getSession(true);
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
                if (repositoryId != null) {
                    try {
                        server = ODChangePasswordAction.getConnection(request);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Object e = synchObject = server == null ? new Object() : server;
                    synchronized (e) {
                        boolean errorPath;
                        block28: {
                            String serverIP = null;
                            String serverPort = "0";
                            RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                            if (repositoryConfig != null) {
                                serverIP = repositoryConfig.getServerName();
                                serverPort = repositoryConfig.getPortNumber();
                            }
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "The port for server '" + serverIP + "' is " + serverPort);
                            int iServerPort = Integer.parseInt(serverPort);
                            request.setAttribute("userid", (Object)userid);
                            request.setAttribute("password", (Object)password);
                            request.setAttribute("repositoryId", (Object)repositoryId);
                            if (server == null || !userid.equals(server.getUserId()) || !password.equals(server.getPassword())) {
                                ODLoginConfig odLoginConfig = Config.getODLoginConfig("navigator", repositoryId);
                                ApplicationConfig applicationConfig = Config.getApplicationConfig(request);
                                SettingsConfig settingConfig = Config.getSettingsConfig(applicationConfig.getObjectId());
                                String propertyValue = settingConfig.getODLanguage();
                                if (propertyValue != null && propertyValue.length() > 0) {
                                    odLoginConfig.setLanguage(propertyValue);
                                }
                                if ((propertyValue = settingConfig.getODTempdir()) != null && propertyValue.length() > 0) {
                                    odLoginConfig.setTempDir(propertyValue);
                                }
                                if ((propertyValue = settingConfig.getODTracelevelString()) != null && propertyValue.length() > 0) {
                                    odLoginConfig.setStrTraceLevel(propertyValue);
                                }
                                if ((propertyValue = settingConfig.getODTracedir()) != null && propertyValue.length() > 0) {
                                    odLoginConfig.setTraceDir(propertyValue);
                                }
                                if ((propertyValue = settingConfig.getODMaxTraceFilesizeString()) != null && propertyValue.length() > 0) {
                                    odLoginConfig.setStrMaxTraceFilesize(propertyValue);
                                }
                                if ((propertyValue = settingConfig.getODAfp2pdfInstalldir()) != null && propertyValue.length() > 0) {
                                    odLoginConfig.setAfp2PdfInstallDir(propertyValue);
                                }
                                if ((propertyValue = settingConfig.getCustomProperties()) != null && propertyValue.length() > 0) {
                                    odLoginConfig.setGlobalCustomProperties(propertyValue);
                                }
                                ODConfig odConfig = odLoginConfig.getODConfig(request);
                                server = new ODServer(odConfig);
                            }
                            logonMediator.setServer(server);
                            server.initialize(response.encodeURL(request.getContextPath() + "/appletCallback/" + repositoryId));
                            server.setUserId(userid);
                            server.setPassword(password);
                            server.setServerName(serverIP);
                            server.setPort(iServerPort);
                            server.setConnectType('T');
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Invoking server.logon().");
                            errorPath = false;
                            try {
                                server.logon();
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "logged into server - password must not be expired");
                            }
                            catch (ODException ode) {
                                if (ode == null || (ode.getErrorId() & 0xFFFF) != 2061) break block28;
                                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "password is expired");
                                server.logon(serverIP, userid, password, newPassword);
                                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "password is now changed");
                                errorPath = true;
                            }
                        }
                        if (!errorPath) {
                            server.changePassword(newPassword);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "password is now changed");
                        }
                        try {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Server logging OFF");
                            server.logoff();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Server logging ON");
                            server.logon();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Server log ON COMPLETED");
                        }
                        catch (Exception ode) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, ode.getLocalizedMessage());
                        }
                        synchObject = server;
                        ODChangePasswordAction.storeNewConnection(request, server, null);
                        if (session != null && userid != null) {
                            session.setAttribute("session_userid", (Object)server.getUserId());
                        }
                    }
                    session = Util.replaceSession(request);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "No action errors returned.");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The server object is connected");
                    logonMediator.addMessage("changepassword.successful", userid);
                    break block29;
                }
                logonMediator.addError("error.parm.null", "repositoryId");
            }
            catch (ODException ode) {
                this.logFDC(request, response, null, methodName);
                if (ode != null && (ode.getErrorId() & 0xFFFF) == 2061) {
                    logonMediator.addError("error.password.expired");
                } else if (ode != null && (ode.getErrorId() & 0xFFFF) == 2107) {
                    logonMediator.addError("error.bad.userid.password");
                } else {
                    logonMediator.addError("error.exception.ondemand", ode.getErrorMsg(), new Integer(ode.getErrorId() & 0xFFFF));
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                throw e;
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ODLogonMediator logonMediator = (ODLogonMediator)this.getMediator(request);
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String newPassword = request.getParameter("new_password");
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        Object server = null;
        if (userid == null || userid.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid was not found");
            logonMediator.addError("error.parm.null", "userid");
            this.setRequestHasErrors(request, true);
        }
        if (password == null || password.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "password was not found");
            logonMediator.addError("error.parm.null", "password");
            this.setRequestHasErrors(request, true);
        }
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "server name was not found");
            logonMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (newPassword == null || newPassword.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "new password was not found");
            logonMediator.addError("error.parm.null", "new_password");
            this.setRequestHasErrors(request, true);
        }
        if (this.getRequestHasErrors(request)) {
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            return false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        ODLogonMediator logonMediator = new ODLogonMediator(request, this.getResources(request), request.getLocale());
        logonMediator.setChangePassword(true);
        request.setAttribute("mediator", (Object)logonMediator);
        return logonMediator;
    }
}

