/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.od;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.util.od.ODServerConnection;
import com.ibm.edms.od.ODConfig;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODFolder;
import com.ibm.edms.od.ODServer;
import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class ODBaseAction
extends BaseAction {
    private static final String copyRight = "Licensed Materials - Property of IBM IBM Content Manager for Multiplatforms V8.2 (program number 5724-B19) (c ) Copyright IBM Corp. 1994, 2002, 2003.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    int maxCabinets = Integer.MAX_VALUE;
    int maxFolders = Integer.MAX_VALUE;
    boolean showFieldHoverHelp = false;
    boolean initialized = false;

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "execute";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        try {
            this.preUserExit(request);
            ODServer connection = null;
            if (!(mapping.getPath().endsWith("/logon") || mapping.getPath().endsWith("/changePassword") || mapping.getPath().endsWith("/logoff") || mapping.getPath().endsWith("/getProfile"))) {
                connection = ODBaseAction.getConnection(request);
                if (connection != null) {
                    String altOutput;
                    request.setAttribute("od_server", (Object)connection);
                    if (mapping.getPath().endsWith("/export") && (altOutput = request.getParameter("alt_output")) != null && altOutput.equalsIgnoreCase("JSON")) {
                        BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                        mediator.addMessage("properties.download.successful", new Object[0]);
                        request.setAttribute("mediator", (Object)mediator);
                        this.writeJSONMediator(request, response);
                        return actionForward;
                    }
                } else {
                    String altOutput;
                    Logger.logError((Object)this, methodName, (ServletRequest)request, "The connection object was not found!");
                    if (mapping.getPath().endsWith("/getDocument") && ((altOutput = request.getParameter("alt_output")) == null || !altOutput.equalsIgnoreCase("JSON"))) {
                        response.sendError(500, "error.server.connection.null");
                        return actionForward;
                    }
                    BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                    mediator.addError("error.server.connection.null");
                    request.setAttribute("mediator", (Object)mediator);
                    this.writeJSONMediator(request, response);
                    return actionForward;
                }
            }
            if (!this.initialized) {
                this.initConfigInfo(request);
                this.initialized = true;
            }
            actionForward = this.executeAction(mapping, form, request, response);
            this.postUserExit(request);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            throw e;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected abstract ActionForward executeAction(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected void preUserExit(HttpServletRequest request) {
    }

    protected void postUserExit(HttpServletRequest request) {
    }

    public static ODServer getConnection(HttpServletRequest request, String repositoryId) {
        String methodName = "getConnection";
        HttpSession session = request.getSession(false);
        ODServer connection = null;
        if (session != null) {
            String userId;
            Logger.logDebug(ODBaseAction.class, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
            Hashtable connectionList = (Hashtable)session.getAttribute("od_servers");
            if (connectionList != null) {
                connection = (ODServer)connectionList.get(repositoryId);
            }
            if (!(connection == null || !(connection instanceof ODServerConnection) || ((ODServerConnection)connection).isConnected() && connection.isInitialized())) {
                try {
                    connection.logon();
                    ((ODServerConnection)connection).setConnected(true);
                }
                catch (Exception e) {
                    Logger.logError(ODBaseAction.class, methodName, (ServletRequest)request, (Throwable)e);
                    return null;
                }
            }
            if ((userId = connection.getUserId()) != null) {
                session.setAttribute("session_userid", (Object)userId);
            }
            return connection;
        }
        return null;
    }

    public static ODConfig getConfig(HttpServletRequest request, String repositoryId) {
        String methodName = "getConfig";
        HttpSession session = request.getSession(false);
        ODConfig config = null;
        if (session != null) {
            Logger.logDebug(ODBaseAction.class, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
            Hashtable configList = ODBaseAction.getConfigList(request);
            if (configList != null) {
                config = (ODConfig)configList.get(repositoryId);
            }
            return config;
        }
        return null;
    }

    public static void setConfig(HttpServletRequest request, String repositoryId, ODConfig config) {
        String methodName = "setConfig";
        HttpSession session = request.getSession(false);
        if (session != null) {
            Logger.logDebug(ODBaseAction.class, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
            Hashtable<String, ODConfig> configList = ODBaseAction.getConfigList(request);
            if (configList == null) {
                configList = new Hashtable<String, ODConfig>(1);
            }
            configList.put(repositoryId, config);
            session.setAttribute("od_configs", configList);
        }
    }

    public static Hashtable getConfigList(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            Hashtable configListObject = session.getAttribute("od_configs");
            if (configListObject == null) {
                configListObject = new Hashtable(1);
            }
            return configListObject;
        }
        return null;
    }

    public static ODServer getConnection(HttpServletRequest request) {
        String methodName = "getConnection";
        Logger.logEntry(ODBaseAction.class, methodName, (ServletRequest)request);
        ODServer connection = null;
        String repositoryId = request.getParameter("repositoryId");
        connection = ODBaseAction.getConnection(request, repositoryId);
        Logger.logExit(ODBaseAction.class, methodName, (ServletRequest)request);
        return connection;
    }

    public static void removeConnection(HttpServletRequest request) {
        String repositoryId = request.getParameter("repositoryId");
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("od_servers");
        connectionList.remove(repositoryId);
    }

    public static void setConnection(HttpServletRequest request, ODServer connection, String repositoryId) {
        String methodName = "setConnection";
        Logger.logEntry(ODBaseAction.class, methodName, (ServletRequest)request);
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("od_servers");
        if (connectionList == null) {
            ODBaseAction.createConnectionList(request);
            ODBaseAction.setConnection(request, connection, repositoryId);
        } else {
            if (repositoryId == null) {
                repositoryId = request.getParameter("repositoryId");
            }
            Logger.logDebug(ODBaseAction.class, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
            connectionList.put(repositoryId, connection);
        }
        Logger.logExit(ODBaseAction.class, methodName, (ServletRequest)request);
    }

    protected ODFolder openFolder(HttpServletRequest request, ODServer server, String folderName) throws ODException, Exception {
        String methodName = "openFolder";
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "ENTER parms => repositoryId: " + server.getServerName() + " , folderName: " + folderName);
        ODFolder folder = null;
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attempting to openFolder");
            folder = server.openFolder(folderName);
        }
        catch (Exception e) {
            Logger.logWarning((Object)this, methodName, (ServletRequest)request, "attempting to openFolder failed, calling getFolders first");
            server.getFolders(folderName);
            folder = server.openFolder(folderName);
        }
        return folder;
    }

    public static void createConnectionList(HttpServletRequest request) {
        Hashtable connections = new Hashtable();
        request.getSession(true).setAttribute("od_servers", connections);
    }

    protected String getODWEKVersion() {
        String returnVersion = "7.1.2.9";
        try {
            Field[] fields = Class.forName("com.ibm.edms.od.ODVersion").getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!"version".equals(fields[i].getName())) continue;
                returnVersion = (String)fields[i].get(fields[i].getName());
            }
        }
        catch (IllegalAccessException e) {
            returnVersion = "7.1.2.9";
        }
        catch (SecurityException e) {
            returnVersion = "7.1.2.9";
        }
        catch (ClassNotFoundException e) {
            returnVersion = "7.1.2.9";
        }
        return returnVersion;
    }

    public void initConfigInfo(HttpServletRequest request) throws Exception {
        String methodName = "initConfigInfo";
        DesktopConfig desktopConfig = Config.getDesktopConfig(request);
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.setMaxCabinets(repositoryConfig.getMaxCabinets());
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "maxCabinets = " + this.getMaxCabinets());
            this.setShowFieldHoverHelp(desktopConfig.isShowFieldHoverHelp());
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "showFieldHoverHelp = " + this.getShowFieldHoverHelp());
        }
    }

    public int getMaxCabinets() {
        return this.maxCabinets;
    }

    public void setMaxCabinets(int maxCabinets) {
        this.maxCabinets = maxCabinets;
    }

    public int getMaxFolders() {
        return this.maxFolders;
    }

    public void setMaxFolders(int maxFolders) {
        this.maxFolders = maxFolders;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

