/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.container;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.mediator.container.ContainerLogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.struts.actions.LTPASSOLogon;
import com.ibm.ecm.struts.actions.SSOLogonAction;
import com.ibm.ecm.struts.actions.cm.CMLogonAction;
import com.ibm.ecm.struts.actions.p8.P8LogonAction;
import com.ibm.ecm.util.J2EEServerUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.container.ContainerConnection;
import java.io.IOException;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class ContainerLogonAction
extends BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    public static String CONTAINERS = "containers";
    private String protocol = "FileNetP8";
    public static String NEXUS_STANZA = "Navigator";

    protected BaseMediator createMediator(HttpServletRequest request) {
        ContainerLogonMediator containerLogonMediator = new ContainerLogonMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)containerLogonMediator);
        return containerLogonMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        ContainerLogonMediator logonMediator = (ContainerLogonMediator)this.getMediator(request);
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        if (userid == null || userid.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid was not found");
            logonMediator.addError("error.parm.null", "userid");
            this.setRequestHasErrors(request, true);
        }
        if (password == null || password.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "password was not found");
            logonMediator.addError("error.parm.null", "password");
            this.setRequestHasErrors(request, true);
        }
        if (this.getRequestHasErrors(request)) {
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            return false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
    }

    protected ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        HttpSession session = request.getSession(true);
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        Object connection = null;
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String desktopName = request.getParameter("desktop");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        ContainerLogonMediator logonMediator = (ContainerLogonMediator)this.getMediator(request);
        this.protocol = NEXUS_STANZA;
        if (this.protocol == null) {
            this.protocol = "ClientContainer";
        }
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JAAS stanza = " + this.protocol);
            boolean isWebsphere = J2EEServerUtil.getJ2EEAppServerType(this.getServlet().getServletContext()) == "websphere";
            Subject subject = this.doContainerLogin(request, response, userid, password, isWebsphere, logonMediator);
            if (desktopName == null || desktopName.length() == 0) {
                desktopName = Config.getDefaultDesktopName(request);
            }
            if (!Config.getApplicationConfig(request).checkAdminAccessForUser(userid) && desktopName.equalsIgnoreCase("admin")) {
                logonMediator.addError("admin.error.nopermissions", desktopName);
                Logger.logWarning((Object)this, methodName, session, "User " + userid + " does not have access to the Admin application.");
                throw new Exception("User " + userid + " does not have access to the Admin application.");
            }
            logonMediator.setUserid(userid);
            logonMediator.setDesktop(desktopName);
            logonMediator.setPassword("");
            if (session != null) {
                session.setAttribute("session_userid", (Object)userid);
            }
            logonMediator.addMessage("logon.successful", userid);
            boolean ssoLogonRequired = true;
            DesktopConfig desktopConfig = Config.getDesktopConfig(request);
            RepositoryConfig defaultRepository = null;
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "default Repoistory ID = " + desktopConfig.getDefaultRepositoryId());
            if (desktopConfig.getDefaultRepositoryId() != null && !desktopConfig.getDefaultRepositoryId().trim().equals("")) {
                defaultRepository = desktopConfig.getRepository(desktopConfig.getDefaultRepositoryId());
            }
            if (defaultRepository != null && defaultRepository.getType().equalsIgnoreCase("p8")) {
                ContainerLogonAction.setDefaultRepository(request);
                P8LogonAction.createP8Connection(request, response, logonMediator, userid, NEXUS_STANZA, null, subject);
            } else if (defaultRepository != null && defaultRepository.getType().equalsIgnoreCase("cm")) {
                new CMLogonAction().createCMConnection(request, response, logonMediator);
                ssoLogonRequired = false;
            } else if (defaultRepository != null && defaultRepository.getType().equalsIgnoreCase("od")) {
                Logger.logDebug((Object)this, methodName, session, "Something terrible, OD should be Repository authentication ");
            }
            if (!desktopName.equalsIgnoreCase("admin") && ssoLogonRequired) {
                SSOLogonAction.doSSOLogonForP8(request, logonMediator);
                SSOLogonAction.doSSOLogonForCM8(request, logonMediator);
                SSOLogonAction.doSSOLogonForOD(request, response, logonMediator);
            }
            session = Util.replaceSession(request);
        }
        catch (Throwable t) {
            if (logonMediator.getErrors() == null || logonMediator.getErrors() != null && logonMediator.getErrors().isEmpty()) {
                logonMediator.addError("error.bad.userid.password");
            }
            this.logFDC(request, response, null, methodName);
            if (t.getClass().getName().equals("com.filenet.api.exception.EngineRuntimeException") && t.getMessage().contains("SECURITY_INVALID_CREDENTIALS")) {
                Logger.logWarning((Object)this, methodName, (ServletRequest)request, t.getMessage());
            }
            Logger.logError((Object)this, methodName, (ServletRequest)request, t);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    public Subject doContainerLogin(HttpServletRequest request, HttpServletResponse response, String userid, String password, boolean isWebSphere, LogonMediator logonMediator) throws Exception, LoginException {
        String methodName = "doContainerLogin";
        Subject subject = null;
        LoginContext lc = null;
        HttpSession session = request.getSession(true);
        String desktopName = request.getParameter("desktop");
        if (isWebSphere) {
            try {
                subject = LTPASSOLogon.doJAASLogin(userid, password, request, response);
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, e.getMessage());
                logonMediator.setIsAdminUser("false");
                throw e;
            }
        } else {
            lc = new LoginContext(NEXUS_STANZA, new UserPasswordHandler(session, userid, password));
            lc.login();
            if (lc != null) {
                subject = lc.getSubject();
            }
        }
        if (subject == null) {
            logonMediator.setIsAdminUser("false");
            return null;
        }
        this.doContainerLogin(request, userid, logonMediator, subject, lc);
        return subject;
    }

    public void doContainerLogin(HttpServletRequest request, String userid, LogonMediator logonMediator, Subject subject, LoginContext lc) throws Exception {
        String methodName = "doContainerLogin";
        HttpSession session = request.getSession(true);
        String desktopName = request.getParameter("desktop");
        ContainerConnection connection = new ContainerConnection(userid, lc, subject);
        if (desktopName == null || desktopName.length() == 0) {
            desktopName = Config.getDefaultDesktopName(request);
        }
        Hashtable<String, Hashtable<String, ContainerConnection>> connectionList = (Hashtable<String, Hashtable<String, ContainerConnection>>)request.getSession(true).getAttribute(CONTAINERS);
        Hashtable<String, ContainerConnection> connections = null;
        if (connectionList == null) {
            connectionList = new Hashtable<String, Hashtable<String, ContainerConnection>>();
            request.getSession(true).setAttribute(CONTAINERS, connectionList);
        }
        if ((connections = (Hashtable<String, ContainerConnection>)connectionList.get(desktopName)) == null) {
            connections = new Hashtable<String, ContainerConnection>();
        }
        connections.put(userid, connection);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName: " + desktopName);
        connectionList.put(desktopName, connections);
        logonMediator.setContainerConnectionList(connectionList);
        if (!Config.getApplicationConfig(request).checkAdminAccessForUser(userid)) {
            logonMediator.setIsAdminUser("false");
        } else {
            logonMediator.setIsAdminUser("true");
        }
    }

    public static void setDefaultRepository(HttpServletRequest request) {
        String loginRepoId = request.getParameter("repositoryId");
        if (loginRepoId == null) {
            DesktopConfig desktopConfig = Config.getDesktopConfig(request);
            request.setAttribute("repositoryId", (Object)desktopConfig.getDefaultRepositoryId());
        }
    }

    private class UserPasswordHandler
    implements CallbackHandler {
        private String userid;
        private String password;
        private HttpSession session;

        public UserPasswordHandler(HttpSession session, String userid, String password) {
            this.userid = userid;
            this.password = password;
            this.session = session;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String methodName = "handle";
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextOutputCallback) {
                    TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                    switch (toc.getMessageType()) {
                        case 0: {
                            Logger.logInfo((Object)this, methodName, this.session, "INFORMATION: " + toc.getMessage());
                            break;
                        }
                        case 2: {
                            Logger.logInfo((Object)this, methodName, this.session, "ERROR: " + toc.getMessage());
                            break;
                        }
                        case 1: {
                            Logger.logInfo((Object)this, methodName, this.session, "WARNING: " + toc.getMessage());
                        }
                    }
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.userid);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                Logger.logInfo((Object)this, methodName, this.session, "Unexpected callback: " + callbacks[i].toString());
            }
        }
    }
}

