/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISObjectUtils;
import com.ibm.ecm.util.cmis.CMISUtil;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISUnlockAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
        String currentUser = this.connection.getUserId();
        Session session = this.cmisSession;
        synchronized (session) {
            try {
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String typeName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + typeName);
                String[] docIds = request.getParameterValues("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid param values=" + docIds);
                ObjectType typeDef = this.cmisSession.getTypeDefinition(typeName);
                searchResultsMediator.addTypeDefinition((TypeDefinition)typeDef);
                searchResultsMediator.setServer(this.connection);
                ArrayList<CmisObject> hits = new ArrayList<CmisObject>();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of docids:" + docIds.length);
                if (this.cmisSession != null) {
                    for (String id : docIds) {
                        CmisObject item = CMISObjectUtils.getNonCachedObject(this.cmisSession, id, true);
                        if (item instanceof Folder) continue;
                        if (item instanceof Document) {
                            boolean checkedOut;
                            boolean doCancelCheckOut;
                            Document document = (Document)item;
                            boolean checkIfCheckedOut = false;
                            if (checkIfCheckedOut) {
                                document.refresh();
                                if (document.isVersionSeriesCheckedOut().booleanValue()) {
                                    doCancelCheckOut = true;
                                } else {
                                    doCancelCheckOut = true;
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item not checked out");
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "user name currently logged on=" + currentUser);
                                    checkedOut = document.isVersionSeriesCheckedOut();
                                }
                            } else {
                                doCancelCheckOut = true;
                            }
                            Document tempObj = CMISObjectUtils.getLatestNonPwcVersion(document, this.cmisSession);
                            String idLatestVersion = tempObj.getId();
                            if (!doCancelCheckOut) continue;
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item locked " + id);
                            CMISUtil.printProperties("before cancelCheckout", (CmisObject)document);
                            document.cancelCheckOut();
                            CMISUtil.printProperties("after cancelCheckout", (CmisObject)document);
                            checkedOut = document.isVersionSeriesCheckedOut();
                            CmisObject objLmv = this.cmisSession.getObject(idLatestVersion);
                            try {
                                objLmv.refresh();
                                hits.add(objLmv);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item value checkedout  = " + checkedOut + " and checked out by " + currentUser);
                            continue;
                        }
                        throw new Exception("Unsupported type of object");
                    }
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of items found -->  [Vector = " + hits.size());
                searchResultsMediator.setPageSize(this.pageSize);
                searchResultsMediator.setSearchResults(hits);
                searchResultsMediator.setFolderDescription(typeDef.getDisplayName());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                String message = resources.getMessage(request.getLocale(), "error.exception.general", new Object[]{e.getMessage()});
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            searchResultsMediator.addMessage("document.checkin.successful", new Object[0]);
            this.writeJSONMediator(request, response);
        }
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
    }
}

