/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.ForwardPager;
import com.ibm.ecm.util.IteratorWrapper;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISProviderSpecific;
import com.ibm.ecm.util.cmis.CMISQueryContinuationData;
import com.ibm.ecm.util.cmis.CMISQueryUtil;
import com.ibm.ecm.util.cmis.CMISSearchTemplate;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISSearchAction
extends CMISBaseAction {
    public boolean ChangeTableNameToQueryName(JSONObject input, CMISConnection connection) {
        boolean foundAndFixed = false;
        String tableId = (String)input.get("template_name");
        ObjectType cmisType = connection.getCMISSession().getTypeDefinition(tableId);
        if (cmisType != null) {
            String queryName = cmisType.getQueryName();
            input.put("template_name", queryName);
            foundAndFixed = true;
        }
        return foundAndFixed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block18: {
            String methodName = "executeAction";
            Logger.logEntry((Object)this, "executeAction", (ServletRequest)request);
            this.getConfigInfo(request);
            CMISSearchResultsMediator mediator = (CMISSearchResultsMediator)this.getMediator(request);
            String serverName = request.getParameter("repositoryId");
            String templateName = request.getParameter("template_name");
            String desktopName = request.getParameter("desktop");
            String jsonCriteria = request.getParameter("criterias");
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "serverName = " + serverName);
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "templateName = " + templateName);
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "desktopName = " + desktopName);
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "jsonCriteria = " + jsonCriteria);
            if (serverName == null || serverName.trim().length() == 0) {
                mediator.addError("error.parm.null", "repositoryId");
            } else {
                try {
                    try {
                        mediator.setServer(this.connection);
                        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                        if (repositoryConfig != null) {
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "showDocLocation = " + repositoryConfig.isShowDocLocation());
                            mediator.setShowDocLocation(repositoryConfig.isShowDocLocation());
                        }
                        if (CMISProviderSpecific.isSharePoint2013(this.cmisSession)) {
                            this.pageSize = Math.min(100, this.pageSize);
                        }
                        mediator.setPageSize(this.pageSize);
                        String templateString = this.readJSON(request);
                        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "About to parse incoming JSON:" + templateString);
                        JSONObject searchTemplateJson = null;
                        try {
                            searchTemplateJson = (JSONObject)JSON.parse(templateString);
                        }
                        catch (Exception e) {
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Error occured during JSON parse:" + e.getMessage());
                            throw e;
                        }
                        this.ChangeTableNameToQueryName(searchTemplateJson, this.connection);
                        CMISSearchTemplate searchTemplate = new CMISSearchTemplate();
                        searchTemplate.fromJSON(searchTemplateJson);
                        List<SearchTemplate.SearchClass> classes = searchTemplate.getClasses();
                        if (classes != null && classes.size() > 0) {
                            classes.get(0).setSearchSubclasses(true);
                        }
                        if (searchTemplate.getSessions() == null) {
                            searchTemplate.addSession(this.connection.getCMISSession());
                        }
                        CMISQueryContinuationData queryData = new CMISQueryContinuationData();
                        Map<SearchTemplate.ObjectType, String> listOfSearches = searchTemplate.generateQuery(request, this.connection, templateName);
                        int count = 0;
                        for (Map.Entry<SearchTemplate.ObjectType, String> e : listOfSearches.entrySet()) {
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Query string " + ++count + "=" + e.getValue());
                        }
                        OperationContext opCtx = this.connection.getQueryOperationContext();
                        opCtx.setMaxItemsPerPage(this.pageSize);
                        ArrayList allIterators = new ArrayList();
                        for (Map.Entry<SearchTemplate.ObjectType, String> e : listOfSearches.entrySet()) {
                            String sqlString = e.getValue();
                            if (count > 1) {
                                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "More than one query present : count = " + count);
                            }
                            boolean cmisSearchAllVersions = false;
                            if (searchTemplate.getVersionOption() == SearchTemplate.VersionOption.allversions) {
                                cmisSearchAllVersions = true;
                            }
                            ItemIterable resultsObjectSet = this.connection.getCMISSession().query(e.getValue(), cmisSearchAllVersions, opCtx);
                            allIterators.add(resultsObjectSet.iterator());
                            SearchTemplate.ObjectType key = e.getKey();
                            if (key == SearchTemplate.ObjectType.folder) {
                                queryData.folderSQL = sqlString;
                                continue;
                            }
                            if (key != SearchTemplate.ObjectType.document) continue;
                            queryData.documentSQL = sqlString;
                        }
                        mediator.setQueryResultsDisplaySettings(searchTemplate.getResultsDisplay());
                        IteratorWrapper wrapperIterator = new IteratorWrapper(allIterators);
                        ForwardPager pager = new ForwardPager(wrapperIterator, this.pageSize);
                        List hitsResults = pager.loadNextPage();
                        List<CmisObject> hits = CMISQueryUtil.convertQueryResults(hitsResults, this.connection.getCMISSession(), this.connection.getOperationContext());
                        if (!pager.isEndReached()) {
                            queryData.itemsToSkip = pager.getNumberOfItemsRetrieved();
                            queryData.sessionKey = Long.toString(System.currentTimeMillis(), 36);
                            request.getSession().setAttribute(queryData.sessionKey, pager);
                            String data = queryData.saveToString();
                            mediator.setContinuationData(data);
                        }
                        Collection<TypeDefinition> cds = CMISSearchAction.findUniqueTypeDefinitions(hits);
                        mediator.setClassDescriptions(cds);
                        mediator.setSearchResults(hits);
                        mediator.addMessage(pager.getNumberOfItemsRetrieved() == 1 ? "search.results.returnedOne" : "search.results.returned", pager.getNumberOfItemsRetrieved());
                        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, " after adding search results to session.");
                    }
                    catch (Exception e) {
                        this.logFDC(request, response, null, "executeAction");
                        Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)e);
                        mediator.addError("error.exception.general", e);
                        Object var28_31 = null;
                        this.writeJSONMediator(request, response);
                        break block18;
                    }
                    Object var28_30 = null;
                }
                catch (Throwable throwable) {
                    Object var28_32 = null;
                    this.writeJSONMediator(request, response);
                    throw throwable;
                }
                this.writeJSONMediator(request, response);
            }
        }
        Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator searchResultsMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        return searchResultsMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String templateName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "templateName = " + templateName);
        String folderName = request.getParameter("class_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "folderName = " + folderName);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        String jsonCriteria = request.getParameter("criterias");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "jsonCriteria = " + jsonCriteria);
        boolean isAndSearch = this.getBooleanRequestParameter(request, "andSearch", false);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "isPublicSearch = " + isAndSearch);
    }
}

