/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISRemoveFromFolderAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    String folderId = "";
    String singleDocumentId = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
        Session session = this.cmisSession;
        synchronized (session) {
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String[] documentIds = request.getParameterValues("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + documentIds.length + ")");
                String folderId = request.getParameter("folderDocid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPID = " + folderId);
                String folderTypeId = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + folderTypeId);
                searchResultsMediator.addTypeDefinition((TypeDefinition)this.cmisSession.getTypeDefinition(folderTypeId));
                searchResultsMediator.setServer(this.connection);
                if (this.cmisSession != null) {
                    int errorCount = 0;
                    boolean itemsNotFound = false;
                    ArrayList<String> errorItemNames = new ArrayList<String>();
                    for (String documentId : documentIds) {
                        try {
                            Document doc = (Document)this.cmisSession.getObject(documentId);
                            if (documentIds.length == 1) {
                                this.singleDocumentId = documentId;
                            }
                            Folder folder = (Folder)this.cmisSession.getObject(folderId);
                            doc.removeFromFolder((ObjectId)folder);
                        }
                        catch (CmisRuntimeException e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                            String s1 = e.getExceptionName();
                            ++errorCount;
                            errorItemNames.add(documentId);
                        }
                    }
                    if (errorCount == 0) {
                        if (itemsNotFound) {
                            searchResultsMediator.addWarning("removeFromFolder.notFound", new Object[0]);
                        } else if (documentIds.length > 1) {
                            searchResultsMediator.addMessage("removeFromFolder.multi.success", new Object[0]);
                        } else {
                            searchResultsMediator.addMessage("removeFromFolder.single.success", folderId, this.singleDocumentId);
                        }
                    } else if (documentIds.length > 1) {
                        if (errorCount == documentIds.length) {
                            searchResultsMediator.addWarning("removeFromFolder.none", new Object[0]);
                        } else {
                            String docNames = "";
                            Integer errorItemCounter = 0;
                            while (errorItemCounter < errorItemNames.size()) {
                                if (errorItemCounter > 0) {
                                    docNames = docNames + "<br/>";
                                }
                                docNames = docNames + (String)errorItemNames.get(errorItemCounter);
                                Integer n = errorItemCounter;
                                Integer n2 = errorItemCounter = Integer.valueOf(errorItemCounter + 1);
                            }
                            searchResultsMediator.addWarning("removeFromFolder.partial", errorItemCounter.toString(), docNames);
                        }
                    } else {
                        searchResultsMediator.addWarning("removeFromFolder.single.warning", folderId, this.singleDocumentId);
                    }
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String[] itemPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
        String pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + itemPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
        String[] folderPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
        pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + folderPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
    }
}

