/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchCriteriaMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISObjectUtils;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKDataObjectNotFound;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISOpenSearchTemplateAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMISSearchCriteriaMediator searchCriteriaMediator = (CMISSearchCriteriaMediator)this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String itemId = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemId = " + itemId);
        String teamspaceId = request.getParameter("workspaceId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceId = " + teamspaceId);
        String formType = request.getParameter("form_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "formType = " + formType);
        CMISConnection cMISConnection = this.connection;
        synchronized (cMISConnection) {
            try {
                this.getConfigInfo(request);
                Document docWithJsonCriteria = (Document)CMISObjectUtils.getNonCachedObject(this.cmisSession, itemId, true);
                JSONObject json = (JSONObject)JSON.parse(docWithJsonCriteria.getContentStream().getStream());
                searchCriteriaMediator.setRawSearchCriteriaOverride(json);
            }
            catch (Exception e) {
                if (e instanceof DKDataObjectNotFound) {
                    searchCriteriaMediator.addError("error.exception.opensearchnotfound", itemId);
                } else {
                    searchCriteriaMediator.addError("error.exception.general", e.getMessage());
                }
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            mediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        String searchTemplateId = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "searchTemplateId = " + searchTemplateId);
        if (searchTemplateId == null || searchTemplateId.trim().length() < 1) {
            mediator.addError("error.parm.null", "template_name");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        return new CMISSearchCriteriaMediator(request, this.getResources(request), request.getLocale());
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String itemId = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "itemId = " + itemId);
    }
}

