/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.ForwardPager;
import com.ibm.ecm.util.IteratorWrapper;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISCustomPropertyNames;
import com.ibm.ecm.util.cmis.CMISProviderSpecific;
import com.ibm.ecm.util.cmis.CMISQuery;
import com.ibm.ecm.util.cmis.CMISQueryContinuationData;
import com.ibm.ecm.util.cmis.CMISUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISOpenFolderAction
extends CMISBaseAction {
    private static Set<String> sortableFolderProperties = new HashSet<String>();

    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMISQueryContinuationData queryData = new CMISQueryContinuationData();
        this.getConfigInfo(request);
        String filterType = request.getParameter("filter_type");
        queryData.returnOnlyFolders = filterType != null && filterType.equalsIgnoreCase("folderSearch");
        String serverName = request.getParameter("repositoryId");
        String folderId = request.getParameter("docid");
        queryData.orderBy = request.getParameter("order_by");
        if (queryData.orderBy != null && queryData.orderBy.equalsIgnoreCase("!name")) {
            queryData.orderBy = "cmis:name";
        }
        String descendingOrderParam = request.getParameter("order_descending");
        queryData.descending = StringUtils.equals((String)descendingOrderParam, (String)"true");
        Runtime rt = Runtime.getRuntime();
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "totalMemory=" + rt.totalMemory() + ", maxMemory=" + rt.maxMemory() + ", freeMemory=" + rt.freeMemory());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderID: " + folderId);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "return only folders=" + queryData.returnOnlyFolders);
        CMISSearchResultsMediator mediator = (CMISSearchResultsMediator)this.getMediator(request);
        mediator.setServerName(serverName);
        mediator.setPageSize(this.pageSize);
        try {
            ItemIterable chemIter;
            OperationContext opCtx;
            boolean doUseFolderChildrenWorkaround;
            mediator.setServer(this.connection);
            String realFolderId = CMISUtil.getObjectIdentity(folderId);
            if (realFolderId.equals("/")) {
                queryData.returnOnlyFolders = true;
            }
            boolean isCM8 = CMISProviderSpecific.isCM(this.cmisSession);
            boolean isNuxeo = CMISProviderSpecific.isNuxeo(this.cmisSession);
            boolean isChemistry = CMISProviderSpecific.isChemistry(this.cmisSession);
            boolean isCloudoku = CMISProviderSpecific.isCloudoku(this.cmisSession);
            boolean isAlfresco = CMISProviderSpecific.isAlfresco(this.cmisSession);
            boolean doNuxeoWorkaround = isNuxeo && queryData.returnOnlyFolders;
            boolean doAlfrescoWorkaround = isAlfresco && queryData.returnOnlyFolders;
            boolean bl = doUseFolderChildrenWorkaround = isCM8 || isChemistry || isCloudoku;
            if (doNuxeoWorkaround) {
                opCtx = this.cmisSession.createOperationContext();
                HashSet<String> filter = new HashSet<String>();
                filter.add(EnumPropertiesBase.CMIS_NAME.value());
                opCtx.setFilter(filter);
                opCtx.setIncludeAllowableActions(true);
            } else {
                opCtx = this.connection.getOperationContext();
            }
            opCtx.setMaxItemsPerPage(this.pageSize);
            long start = System.currentTimeMillis();
            if (queryData.orderBy != null) {
                opCtx.setOrderBy(queryData.orderBy + (StringUtils.equals((String)descendingOrderParam, (String)"true") ? " DESC" : " ASC"));
            } else if (!isCM8) {
                opCtx.setOrderBy("cmis:name ASC");
            }
            if (queryData.returnOnlyFolders) {
                boolean doODWorkaround;
                boolean bl2 = doODWorkaround = this.cmisSession.getRepositoryInfo().getProductName().indexOf("Content Manager OnDemand") != -1;
                if (doODWorkaround) {
                    chemIter = this.cmisSession.getRootFolder().getChildren();
                } else if (doUseFolderChildrenWorkaround || doNuxeoWorkaround || doAlfrescoWorkaround) {
                    Folder folderToOpen = (Folder)this.cmisSession.getObject(realFolderId, this.cmisSession.createOperationContext());
                    chemIter = folderToOpen.getChildren(opCtx);
                } else {
                    chemIter = this.cmisSession.queryObjects(BaseTypeId.CMIS_FOLDER.value(), " IN_FOLDER('" + realFolderId + "')", false, opCtx);
                }
            } else {
                opCtx.setCacheEnabled(true);
                Folder folderToOpen = (Folder)this.cmisSession.getObject(realFolderId, opCtx);
                folderToOpen.refresh();
                chemIter = doUseFolderChildrenWorkaround ? folderToOpen.getChildren(this.cmisSession.createOperationContext()) : folderToOpen.getChildren(opCtx);
            }
            if (chemIter.iterator().hasNext()) {
                long end = System.currentTimeMillis();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "QueryObjects returned in " + (end - start) + " ms.");
            }
            ForwardPager pager = new ForwardPager(chemIter.iterator(), this.pageSize);
            List<CmisObject> hits = pager.loadNextPage();
            ArrayList<CmisObject> hitsFiltered = new ArrayList<CmisObject>();
            if ((doUseFolderChildrenWorkaround || doNuxeoWorkaround || doAlfrescoWorkaround) && queryData.returnOnlyFolders) {
                for (CmisObject obj : hits) {
                    if (obj instanceof Folder) {
                        hitsFiltered.add(obj);
                    }
                    hits = hitsFiltered;
                }
            }
            if (!pager.isEndReached()) {
                queryData.folderId = folderId;
                queryData.serverName = serverName;
                queryData.sessionKey = Long.toString(System.currentTimeMillis(), 36);
                queryData.itemsToSkip = pager.getNumberOfItemsRetrieved();
                request.getSession().setAttribute(queryData.sessionKey, pager);
                String data = queryData.saveToString();
                mediator.setContinuationData(data);
            }
            Collection<TypeDefinition> cds = CMISOpenFolderAction.findUniqueTypeDefinitions(hits);
            mediator.setClassDescriptions(cds);
            mediator.setServerName(serverName);
            mediator.setSearchResults(hits);
            mediator.setParentDocID(folderId);
            mediator.setMaxResultsReached(pager.isMaxResultsReached());
            mediator.addMessage(hits.size() == 1 ? "openFolder.returnedOne" : "openFolder.returned", hits.size());
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            mediator.addError("error.exception.general", e.getMessage());
        }
        if (Logger.isDebugLogged()) {
            String jsonString = mediator.toJSONString();
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JSON response: " + jsonString);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected ForwardPager<QueryResult> executeCMISQuery(HttpServletRequest request, CMISQueryContinuationData queryData, CMISConnection connection) {
        Iterator documentsIterator = null;
        Iterator foldersIterator = null;
        if (StringUtils.isNotEmpty((String)queryData.documentSQL)) {
            documentsIterator = CMISQuery.executeQueryAsObjectsIterator(request, connection, queryData.documentSQL, null, this.pageSize).iterator();
        }
        if (StringUtils.isNotEmpty((String)queryData.folderSQL)) {
            foldersIterator = CMISQuery.executeQueryAsObjectsIterator(request, connection, queryData.folderSQL, null, this.pageSize).iterator();
        }
        ArrayList allIterators = new ArrayList();
        if (queryData.returnOnlyFolders) {
            allIterators.add(foldersIterator);
        } else if (queryData.descending) {
            if (documentsIterator != null) {
                allIterators.add(documentsIterator);
            }
            if (foldersIterator != null) {
                allIterators.add(foldersIterator);
            }
        } else {
            if (foldersIterator != null) {
                allIterators.add(foldersIterator);
            }
            if (documentsIterator != null) {
                allIterators.add(documentsIterator);
            }
        }
        IteratorWrapper wrapperIterator = new IteratorWrapper(allIterators);
        ForwardPager<QueryResult> pager = new ForwardPager<QueryResult>(wrapperIterator, this.pageSize);
        return pager;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverName = request.getParameter("repositoryId");
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Request Parameter: documentID = " + pid);
        return serverName != null && pid != null;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator mediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        return mediator;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template");
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
    }

    static {
        sortableFolderProperties.add("cmis:name");
        sortableFolderProperties.add("cmis:objectId");
        sortableFolderProperties.add("cmis:lastModifiedBy");
        sortableFolderProperties.add("cmis:lastModificationDate");
        sortableFolderProperties.add(CMISCustomPropertyNames.CONTAINER_TYPE);
    }
}

