/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISMoveToFolderAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
        Session session = this.cmisSession;
        synchronized (session) {
            block8: {
                try {
                    this.getConfigInfo(request);
                    String serverName = request.getParameter("repositoryId");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                    searchResultsMediator.setServerName(serverName);
                    String[] itemPIDs = request.getParameterValues("docid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
                    String sourceFolderId = request.getParameter("folderDocid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPID = " + sourceFolderId);
                    String targetFolderId = request.getParameter("newFolderDocid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "newFolderPID = " + targetFolderId);
                    searchResultsMediator.setServer(this.connection);
                    if (this.cmisSession == null) break block8;
                    int errorCount = 0;
                    Folder sourceFolder = (Folder)this.cmisSession.getObject(sourceFolderId);
                    Folder targetFolder = (Folder)this.cmisSession.getObject(targetFolderId);
                    String targetFolderName = targetFolder.getName();
                    FileableCmisObject objToMove = null;
                    for (String itemPID : itemPIDs) {
                        try {
                            objToMove = (FileableCmisObject)this.cmisSession.getObject(itemPID);
                            objToMove.move((ObjectId)sourceFolder, (ObjectId)targetFolder);
                        }
                        catch (CmisBaseException e) {
                            ++errorCount;
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                            searchResultsMediator.addWarning("moveItems.warning", targetFolderName, objToMove != null ? objToMove.getName() : "unknown");
                        }
                        searchResultsMediator.addMessage("moveItems.success", targetFolderName, objToMove.getName());
                    }
                }
                catch (Exception e) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    searchResultsMediator.addError("error.exception.general", e.getMessage());
                }
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String[] itemPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
        String pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + itemPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
        String[] folderPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
        pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + folderPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
    }
}

