/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISLogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.struts.actions.p8.P8LogonAction;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISSessionUtils;
import com.ibm.ecm.util.cmis.ConnectionUtils;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISLogonAction
extends CMISBaseAction {
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISLogonMediator mediator = new CMISLogonMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        CMISLogonMediator logonMediator = (CMISLogonMediator)this.getMediator(request);
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        if (userid == null || userid.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid was not found");
            logonMediator.addError("error.parm.null", "userid");
            this.setRequestHasErrors(request, true);
        }
        if (password == null || password.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "password was not found");
            logonMediator.addError("error.parm.null", "password");
            this.setRequestHasErrors(request, true);
        }
        if (serverName == null || serverName.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "server name was not found");
            logonMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (this.getRequestHasErrors(request)) {
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            return false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String repoId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repoId = " + repoId);
    }

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        HttpSession httpSession = null;
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "displayName = " + repositoryId);
        String desktopName = request.getParameter("desktop");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        CMISLogonMediator logonMediator = (CMISLogonMediator)this.getMediator(request);
        httpSession = request.getSession(true);
        String serviceDocUrl = null;
        String displayName = null;
        String cmisReposID = null;
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        String compressResponse = null;
        if (repositoryConfig != null && !repositoryConfig.isEmpty()) {
            compressResponse = "true";
            serviceDocUrl = repositoryConfig.getServerName();
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "serviceDocUrl = " + serviceDocUrl);
            displayName = repositoryConfig.getName();
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "displayName = " + displayName);
            cmisReposID = repositoryConfig.getCmisRepositoryID();
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "cmisReposID = " + cmisReposID);
        } else {
            serviceDocUrl = request.getParameter("serverName");
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "serviceDocUrl = " + serviceDocUrl);
            displayName = request.getParameter("displayName");
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "displayName = " + displayName);
            cmisReposID = request.getParameter("cmisRepositoryID");
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "cmisReposID = " + cmisReposID);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "displayName = " + displayName);
        if (serviceDocUrl != null) {
            request.setAttribute("userid", (Object)userid);
            request.setAttribute("password", (Object)password);
            request.setAttribute("repositoryId", (Object)displayName);
            Session session = CMISSessionUtils.createSession(request, serviceDocUrl, cmisReposID, userid, password, compressResponse);
            ConnectionUtils.storeConnectionInHttpSession(request, userid, session);
            CapabilityQuery capQuery = session.getRepositoryInfo().getCapabilities().getQueryCapability();
            logonMediator.setCapabilityQuery(capQuery);
            httpSession = Util.replaceSession(request);
            logonMediator.addMessage("logon.successful", userid);
        } else {
            logonMediator.addError("error.parm.null", "repositoryId");
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public static Hashtable getServerList(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return (Hashtable)session.getAttribute("CMIS_servers");
    }

    public static void removeServerList(HttpServletRequest request) {
        String methodName = "removeServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            Hashtable cmis_server_List = CMISLogonAction.getServerList(request);
            Logger.logDebug(CMISLogonAction.class, methodName, (ServletRequest)request, "   current CMIS connection list: " + cmis_server_List);
            if (cmis_server_List != null) {
                Logger.logInfo(CMISLogonAction.class, methodName, (ServletRequest)request, "current CMIS connection list size: " + cmis_server_List.size());
                session.removeAttribute("CMIS_servers");
                Logger.logDebug(CMISLogonAction.class, methodName, (ServletRequest)request, "   removed all CMIS connections from session: " + cmis_server_List);
            }
        }
    }

    public static void setServerList(HttpServletRequest request, Hashtable connectionList) {
        String methodName = "setServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("CMIS_servers");
            if (connectionList != null) {
                Logger.logDebug(CMISLogonAction.class, methodName, (ServletRequest)request, "   add CMIS connections from session: " + connectionList);
                Object[] keys = connectionList.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    Logger.logDebug(CMISLogonAction.class, methodName, (ServletRequest)request, "   add CMIS connection: " + (String)keys[i]);
                    CMISConnection connection = (CMISConnection)connectionList.get((String)keys[i]);
                    CMISLogonAction.storeNewConnection(request, connection, (String)keys[i]);
                }
            }
        }
    }

    public static void storeNewConnection(HttpServletRequest request, CMISConnection connection, String repositoryId) {
        String methodName = "storeNewConnection";
        Logger.logEntry(ConnectionUtils.class, methodName, (ServletRequest)request);
        HttpSession session = request.getSession(true);
        Hashtable<String, CMISConnection> connectionList = (Hashtable<String, CMISConnection>)session.getAttribute("CMIS_servers");
        if (connectionList == null) {
            connectionList = new Hashtable<String, CMISConnection>();
        }
        Logger.logDebug(ConnectionUtils.class, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
        connectionList.put(repositoryId, connection);
        session.setAttribute("CMIS_servers", connectionList);
        Logger.logExit(ConnectionUtils.class, methodName, (ServletRequest)request);
    }
}

