/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cmis.CMISObjectUtils;
import com.ibm.ecm.util.cmis.CMISUtil;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISLockAction
extends CMISBaseAction {
    private int pageSize = 0;
    private int maxResults = 0;
    private WCDateFormat wcDateFormats = null;
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
        Session session = this.cmisSession;
        synchronized (session) {
            try {
                this.getConfigInfo(request);
                String docId = request.getParameter("docid");
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String typeName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + typeName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
                String[] docIds = request.getParameterValues("docid");
                ObjectType typeDef = this.cmisSession.getTypeDefinition(typeName);
                searchResultsMediator.addTypeDefinition((TypeDefinition)typeDef);
                searchResultsMediator.setServer(this.connection);
                ArrayList<CmisObject> hits = new ArrayList<CmisObject>();
                int errorCount = 0;
                int successCount = 0;
                ArrayList<String> errorItemNames = new ArrayList<String>();
                for (String objectId : docIds) {
                    Document document = null;
                    try {
                        document = (Document)CMISObjectUtils.getNonCachedObject(this.cmisSession, objectId, false);
                        if (!document.isVersionSeriesCheckedOut().booleanValue()) {
                            CMISUtil.printProperties("before checkOut", (CmisObject)document);
                            document.checkOut();
                            Document checkedInObject = (Document)CMISObjectUtils.getNonCachedObject(this.cmisSession, objectId, true);
                            hits.add((CmisObject)checkedInObject);
                            CMISUtil.printProperties("object returned by lock.do, (id=" + checkedInObject.getId() + ")", (CmisObject)checkedInObject);
                            ++successCount;
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item is locked " + objectId);
                            continue;
                        }
                        String checkedOutUserid = document.getVersionSeriesCheckedOutBy();
                        String loggedOnUserid = this.connection.getUserId();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "checked out by =" + checkedOutUserid);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "user name currently logged on=" + loggedOnUserid);
                        if (checkedOutUserid.equalsIgnoreCase(loggedOnUserid)) continue;
                        searchResultsMediator.addError("error.lock.lockedByOtherUser");
                    }
                    catch (CmisRuntimeException e) {
                        ++errorCount;
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        String documentName = document != null ? document.getName() : docId;
                        errorItemNames.add(documentName);
                    }
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of items found -->  [Vector = " + hits.size());
                searchResultsMediator.setPageSize(this.getPageSize());
                searchResultsMediator.setSearchResults(hits);
                searchResultsMediator.setFolderDescription(typeDef.getDisplayName());
                if (docIds.length > 1) {
                    if (errorCount == docIds.length && successCount == 0) {
                        searchResultsMediator.addWarning("document.checkout.none", new Object[0]);
                    } else if (errorCount > 0) {
                        String docNames = "";
                        Integer errorItemCounter = 0;
                        while (errorItemCounter < errorItemNames.size()) {
                            if (errorItemCounter > 0) {
                                docNames = docNames + "<br/>";
                            }
                            docNames = docNames + (String)errorItemNames.get(errorItemCounter);
                            Integer n = errorItemCounter;
                            Integer n2 = errorItemCounter = Integer.valueOf(errorItemCounter + 1);
                        }
                        searchResultsMediator.addWarning("document.checkout.partial", errorItemCounter.toString(), docNames);
                    }
                    if (successCount == 1) {
                        searchResultsMediator.addMessage("document.checkout.multi.success.single", new Object[0]);
                    } else if (successCount > 1) {
                        searchResultsMediator.addMessage("document.checkout.multi.success", String.valueOf(successCount));
                    }
                } else if (errorCount == 0) {
                    searchResultsMediator.addMessage("document.checkout.single.success", new Object[0]);
                } else {
                    searchResultsMediator.addWarning("document.checkout.single", new Object[0]);
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String docId = request.getParameter("docid");
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
    }
}

