/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.ForwardPager;
import com.ibm.ecm.util.IteratorWrapper;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISQueryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumBaseObjectTypeIds;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISGetSearchTemplatesAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        boolean teamspaceMode = false;
        CMISSearchResultsMediator mediator = (CMISSearchResultsMediator)this.getMediator(request);
        CMISConnection cMISConnection = this.connection;
        synchronized (cMISConnection) {
            try {
                String repositoryId = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + repositoryId);
                String teamspaceId = request.getParameter("workspaceId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + teamspaceId);
                if (repositoryId != null) {
                    this.getConfigInfo(request);
                }
                ObjectType typeDef = this.cmisSession.getTypeDefinition(EnumBaseObjectTypeIds.CMIS_DOCUMENT.value());
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " typeDefinition.ID = " + typeDef.getId());
                mediator.addTypeDefinition((TypeDefinition)typeDef);
                String query = "SELECT t.cmis:name, t.cmis:lastModifiedBy, t.cmis:lastModificationDate, t.cmis:contentStreamLength, t.cmis:objectTypeId, t.cmis:isLatestVersion, t.cmis:isVersionSeriesCheckedOut, t.cmis:versionSeriesId, t.cmis:contentStreamMimeType, t.cmis:versionLabel, t.cmis:objectId FROM cmis:document t WHERE ((t.cmis:name LIKE '%_cmisSearchTemplate')) ORDER BY t.cmis:name ASC";
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "saved search query = " + query);
                OperationContext opCtx = this.connection.getOperationContext();
                opCtx.setMaxItemsPerPage(this.pageSize);
                mediator.setPageSize(this.pageSize);
                ArrayList allIterators = new ArrayList();
                ItemIterable resultsObjectSet = this.cmisSession.query(query, true, opCtx);
                allIterators.add(resultsObjectSet.iterator());
                IteratorWrapper wrapperIterator = new IteratorWrapper(allIterators);
                ForwardPager pager = new ForwardPager(wrapperIterator, this.pageSize);
                List hitsResults = pager.loadNextPage();
                List<CmisObject> hits = CMISQueryUtil.convertQueryResults(hitsResults, this.cmisSession, opCtx);
                Collection<TypeDefinition> cds = CMISGetSearchTemplatesAction.findUniqueTypeDefinitions(hits);
                mediator.setClassDescriptions(cds);
                mediator.setSearchResults(hits);
                mediator.addMessage(pager.getNumberOfItemsRetrieved() == 1 ? "search.results.returnedOne" : "search.results.returned", pager.getNumberOfItemsRetrieved());
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " after adding search results to session.");
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            mediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

