/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.ParamConstants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISObjectUtils;
import com.ibm.ecm.util.cmis.OperationContextFactory;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISGetDocumentVersionsAction
extends CMISBaseAction {
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String pid = request.getParameter("docid");
        String version = request.getParameter("requestedVersion");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: requestedVersion = " + version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        String methodName;
        block13: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding("UTF-8");
            }
            actionForward = null;
            CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "about to try");
            try {
                try {
                    String[] docIds = request.getParameterValues("docid");
                    String requestedTypeOfVersion = request.getParameter("requestedVersion");
                    searchResultsMediator.setServer(this.connection);
                    ArrayList<CmisObject> hits = new ArrayList<CmisObject>();
                    for (int i = 0; i < docIds.length; ++i) {
                        Document doc = (Document)CMISObjectUtils.getNonCachedObject(this.cmisSession, docIds[i], true);
                        boolean canGetVersions = false;
                        if (doc.getAllowableActions() != null && doc.getAllowableActions().getAllowableActions().size() > 0) {
                            canGetVersions = doc.getAllowableActions().getAllowableActions().contains(Action.CAN_GET_ALL_VERSIONS);
                        }
                        if (!canGetVersions) continue;
                        searchResultsMediator.addTypeDefinition((TypeDefinition)doc.getType());
                        OperationContext opCtx = OperationContextFactory.getOperationContextCacheDisabled(this.cmisSession, true);
                        if (requestedTypeOfVersion == ParamConstants.PARM_REQUESTED_VERSION_ALL_DOCS_IN_VERSION_SERIES) {
                            List versions = doc.getAllVersions(opCtx);
                            hits.addAll(versions);
                            continue;
                        }
                        Document docVersion = null;
                        if (requestedTypeOfVersion.equals("current")) {
                            docVersion = CMISObjectUtils.getLatestVersion(doc, this.cmisSession, opCtx);
                        } else if (requestedTypeOfVersion.equals("released")) {
                            docVersion = CMISObjectUtils.getLatestMajorVersion(doc, opCtx);
                        } else if (requestedTypeOfVersion.equals("reservation")) {
                            docVersion = CMISObjectUtils.getPwcNonCached(doc, this.cmisSession);
                        }
                        if (docVersion == null) continue;
                        hits.add((CmisObject)docVersion);
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of items found -->  [Vector = " + hits.size());
                    searchResultsMediator.setListDocumentVersions(true);
                    searchResultsMediator.setPageSize(this.pageSize);
                    searchResultsMediator.setSearchResults(hits);
                    searchResultsMediator.setListDocumentVersions(true);
                    searchResultsMediator.setShowCheckoutIfReservation(false);
                }
                catch (Exception e) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    searchResultsMediator.addError("error.exception.general", e.getMessage());
                    this.setRequestHasErrors(request, true);
                    Object var17_18 = null;
                    this.writeJSONMediator(request, response);
                    break block13;
                }
                Object var17_17 = null;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                this.writeJSONMediator(request, response);
                throw throwable;
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator searchResultsMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        return searchResultsMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverName = request.getParameter("repositoryId");
        String pid = request.getParameter("docid");
        boolean valid = this.validateParam(serverName) && this.validateParam(pid);
        return valid;
    }

    protected boolean validateParam(String value) {
        return value != null && value.trim().length() > 0 && !value.equals("null");
    }
}

