/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISDocumentMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.cmis.CMISUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.MessageFormat;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISGetDocumentAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    private static final boolean useLastDocument = true;
    private static final boolean useNio = true;
    private static final boolean useBufferedIo = false;
    private static final boolean reportAccessTime = false;

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        HttpSession session = request.getSession(false);
        String serverName = request.getParameter("repositoryId");
        String folderName = request.getParameter("template_name");
        String documentID = request.getParameter("docid");
        String clientCodebase = request.getHeader("X-Client-Codebase");
        boolean isFilenetViewerRequest = clientCodebase != null && clientCodebase.contains("FnJavaV1Files");
        this.logFDC(request, response, null, methodName);
        String includeSegmentInfoString = request.getParameter("include_segment_info");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: include_segment_info = " + includeSegmentInfoString);
        CMISDocumentMediator documentMediator = (CMISDocumentMediator)this.getMediator(request);
        if (serverName == null || serverName.trim().length() < 1) {
            documentMediator.addError("error.parm.null", "repositoryId");
        }
        if (folderName == null || folderName.trim().length() < 1) {
            documentMediator.addError("error.parm.null", "template_name");
        }
        if (documentID == null || documentID.trim().length() < 1) {
            documentMediator.addError("error.parm.null", "docid");
        }
        try {
            if (serverName == null) {
                documentMediator.addError("error.parm.null", "repositoryId");
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering code area...");
                LastDocument lastDocument = this.getLastDocument(session);
                Document document = null;
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, MessageFormat.format("Last document is available: {0}", String.valueOf(lastDocument != null)));
                if (lastDocument != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, MessageFormat.format("Current document key is: {0}", documentID));
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, MessageFormat.format("Last document key is: {0}", lastDocument.key));
                    if (documentID.equals(lastDocument.key)) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Using the cached LastDocument");
                        document = lastDocument.document;
                    }
                }
                if (document == null) {
                    document = CMISUtil.getDocument(request, this.connection, documentID, documentMediator);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Fetched document");
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Using cached lastDocument.");
                }
                documentMediator.setHit(document);
                boolean handled = false;
                if (!handled) {
                    this.sendContentResponse(request, response, document);
                }
                CMISGetDocumentAction.saveAsLastDocument(session, document, documentID);
            }
        }
        catch (Exception e) {
            if (e.getClass().getName().endsWith("ClosedConnectionException") || e.getClass().getName().endsWith("ClientAbortException")) {
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Client closed connection before reading entire response");
            }
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            if (isFilenetViewerRequest) {
                response.getWriter().write("NOT OK: <dialog>" + e.getMessage());
            }
            documentMediator.addError("error.exception.general", e.getMessage());
            documentMediator.sendErrorResponse(response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    public int logLongToInt(long l, HttpServletRequest request, String Description) {
        int i = (int)l;
        if ((long)i != l) {
            Logger.logWarning((Object)this, Description, (ServletRequest)request, "Conversion of long to integer resulted in loss of data. ");
        }
        return i;
    }

    private void sendContentResponse(HttpServletRequest request, HttpServletResponse response, Document document) throws IOException {
        ContentStream contentElement = document.getContentStream();
        if (contentElement != null) {
            String mimetype = contentElement.getMimeType();
            response.setContentType(mimetype);
            long contentLength = contentElement.getLength();
            if (contentLength != 0L) {
                response.setContentLength(this.logLongToInt(contentLength, request, "ConvertContentStreamLength"));
            }
            String fileName = Util.getValidFileName(contentElement.getFileName());
            String disposition = request.getParameter("disposition");
            if (disposition != null && disposition.equals("attachment")) {
                String browser = request.getHeader("user-agent");
                if (browser != null && browser.indexOf("MSIE") > -1) {
                    response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                } else if (browser.indexOf("Firefox") > -1) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                }
            } else {
                response.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
            }
            ReadableByteChannel in = Channels.newChannel(contentElement.getStream());
            WritableByteChannel out = Channels.newChannel((OutputStream)response.getOutputStream());
            ByteBuffer buffer = ByteBuffer.allocateDirect(32768);
            while (in.read(buffer) != -1 || buffer.position() > 0) {
                buffer.flip();
                out.write(buffer);
                buffer.compact();
            }
        } else {
            response.setContentLength(0);
        }
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISDocumentMediator documentMediator = new CMISDocumentMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)documentMediator);
        return documentMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String folderName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: folderName = " + folderName);
        String documentID = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
        String vsID = request.getParameter("vsId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: vsID = " + vsID);
        String transform = request.getParameter("transform");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        String altID = request.getParameter("templateid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: id = " + altID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsLastDocument(HttpSession session, Document document, String id) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            LastDocument lastDocument = new LastDocument(document, id);
            session.setAttribute("CMISGetDocument.LastDocument", (Object)lastDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LastDocument getLastDocument(HttpSession session) {
        LastDocument lastDocument = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            long age;
            lastDocument = (LastDocument)session.getAttribute("CMISGetDocument.LastDocument");
            if (lastDocument != null && (age = System.currentTimeMillis() - lastDocument.timestamp) > 15000L) {
                session.removeAttribute("CMISGetDocument.LastDocument");
                lastDocument = null;
            }
        }
        return lastDocument;
    }

    private static class LastDocument {
        private static final String LAST_DOCUMENT_KEY = "CMISGetDocument.LastDocument";
        long timestamp = System.currentTimeMillis();
        transient Document document;
        String key;

        private LastDocument(Document document, String id) {
            this.document = document;
            this.key = id;
        }
    }
}

