/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISClassesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISGetContentClassesAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        String methodName;
        block19: {
            String itemListParam;
            methodName = "executeAction";
            actionForward = null;
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            Object synchObject = new Object();
            CMISClassesMediator mediator = (CMISClassesMediator)this.getMediator(request);
            String serverName = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
            String typeId = request.getParameter("class_name");
            if (typeId != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "requested type Id = " + typeId);
                typeId = CMISUtil.mapBaseType(typeId);
            }
            if ((itemListParam = request.getParameter("itemList")) != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemListParam      = " + itemListParam);
            }
            if (serverName == null || serverName.trim().length() < 1) {
                mediator.addError("error.parm.null", "repositoryId");
            }
            try {
                if (serverName != null) {
                    mediator.setServerDisplayName(serverName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, " connection = " + this.cmisSession);
                    Object object = synchObject = this.cmisSession == null ? new Object() : this.cmisSession;
                    synchronized (object) {
                        Object typeDefinitions;
                        if (typeId == null) {
                            if (itemListParam != null && itemListParam.length() > 0) {
                                JSONArray array = JSONArray.parse(itemListParam);
                                String[] classList = new String[array.size()];
                                for (int i = 0; i < array.size(); ++i) {
                                    classList[i] = (String)array.get(i);
                                }
                                List<ObjectType> arrayTypes = this.getTypeDefinitions(this.cmisSession, classList);
                                typeDefinitions = arrayTypes;
                            } else {
                                typeDefinitions = this.cmisSession.getTypeChildren(BaseTypeId.CMIS_DOCUMENT.value(), true);
                            }
                        } else {
                            typeDefinitions = this.cmisSession.getTypeChildren(typeId, true);
                        }
                        if ((itemListParam == null || itemListParam.length() == 0) && typeId == null) {
                            typeId = BaseTypeId.CMIS_DOCUMENT.value();
                        }
                        int classCount = 0;
                        for (ObjectType objType : typeDefinitions) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "class = " + classCount);
                            mediator.addClass(objType, objType.isCreatable());
                            ++classCount;
                        }
                        int classesToDisplay = classCount;
                        if (classesToDisplay > this.getMaxFolders()) {
                            mediator.addMessage("folders.search.successful.maxItems", classCount, this.getMaxFolders());
                            classesToDisplay = this.getMaxFolders();
                        } else {
                            mediator.addMessage("folders.search.successful", classCount);
                        }
                        if (classCount == 0 && typeId == null) {
                            mediator.addWarning("folders.search.nothingfound", new Object[0]);
                        }
                        mediator.setMaxClasses(classesToDisplay);
                        break block19;
                    }
                }
                mediator.addError("error.parm.null");
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISClassesMediator mediator = new CMISClassesMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }

    private List<ObjectType> getTypeDefinitions(Session cmisSession, String[] classList) {
        ArrayList<ObjectType> retVal = new ArrayList<ObjectType>();
        for (int i = 0; i < classList.length; ++i) {
            retVal.add(cmisSession.getTypeDefinition(classList[i]));
        }
        return retVal;
    }
}

