/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.Constants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cmis.CMISCreateObject;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISEditAttributesAction
extends CMISBaseAction
implements Constants {
    private int pageSize = 0;
    private int maxResults = 0;
    private WCDateFormat wcDateFormats = null;
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        Session session = this.cmisSession;
        synchronized (session) {
            CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
            HashMap updatedDocIds = new HashMap(1);
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                String typeId = request.getParameter("template_name");
                String origDocId = request.getParameter("docid");
                String clientSiteVersionControlSetting = request.getParameter("parm_version_control");
                JSONArray jsonArray = (JSONArray)this.getJSONRequest(request);
                JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                JSONArray criteriasJsonArray = (JSONArray)jsonObj.get("criterias");
                JSONArray permissionJsonArray = (JSONArray)jsonObj.get("acl");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + typeId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + origDocId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: versionControl = " + clientSiteVersionControlSetting);
                searchResultsMediator.setServerName(serverName);
                searchResultsMediator.addTypeDefinition((TypeDefinition)this.cmisSession.getTypeDefinition(typeId));
                searchResultsMediator.setServer(this.connection);
                CmisObject item = CMISUtil.getPersistableObject(request, this.connection, origDocId);
                CmisObject updatedItem = this.updateItem(criteriasJsonArray, clientSiteVersionControlSetting, item, request, searchResultsMediator, updatedDocIds);
                ArrayList<CmisObject> hits = new ArrayList<CmisObject>(1);
                hits.add(updatedItem);
                searchResultsMediator.setPageSize(this.getPageSize());
                searchResultsMediator.setUpdatedDocIds(updatedDocIds);
                searchResultsMediator.setSearchResults(hits);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("editProperies.error", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private CmisObject updateItem(JSONArray criteriasJsonArray, String clientSiteVersionControlSetting, CmisObject item, HttpServletRequest request, CMISSearchResultsMediator searchResultsMediator, HashMap updatedDocIds) throws Exception {
        CmisObject updatedItem;
        String methodName = "updateItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        String origDocId = request.getParameter("docid");
        boolean createNewVersion = true;
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "create new version? " + createNewVersion);
        if (this.cmisSession == null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Problems during check out check. Either there is no connection to cm (DKDatastoreICM) or check out is not supported.");
            searchResultsMediator.addError("editProperties.error.server");
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "update Item with values from Edit Properties dialog");
        boolean isCheckedOut = item instanceof Document && ((Document)item).isVersionSeriesCheckedOut() != false;
        Map<String, Object> properties = CMISCreateObject.createPropertiesMapFromJSON(request, criteriasJsonArray, (TypeDefinition)item.getType(), false, isCheckedOut);
        if (!properties.isEmpty()) {
            CMISUtil.printProperties("before update", item);
            updatedItem = item.updateProperties(properties);
            CMISUtil.printProperties("after update, the object returned by updateProperties:", updatedItem);
        } else {
            updatedItem = item;
        }
        updatedDocIds.put(updatedItem.getId(), origDocId);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return updatedItem;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template_name");
        String pid = request.getParameter("docid");
        String strJsonFormData = request.getParameter("criterias");
        return serverName != null && itemTypeName != null && pid != null && strJsonFormData != null;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator mediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        return mediator;
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template_name");
        String pid = request.getParameter("docid");
        String strJsonFormData = request.getParameter("criterias");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: jsonFormData = " + strJsonFormData);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
    }

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String strJsonFormData = this.readJSON(request);
        JSONArray jsonArray = JSONArray.parse(strJsonFormData);
        request.setAttribute("json_post", (Object)jsonArray);
    }
}

