/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISUtil;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISDeleteItemAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String[] pid = request.getParameterValues("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: # docids sent = " + pid.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        BaseMediator deleteItemMediator = this.getMediator(request);
        Session session = this.cmisSession;
        synchronized (session) {
            this.getConfigInfo(request);
            String serverName = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
            String[] itemIds = request.getParameterValues("docid");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of docids:" + itemIds.length);
            if (this.cmisSession != null) {
                for (String objectId : itemIds) {
                    CmisObject object = null;
                    try {
                        object = CMISUtil.getPersistableObject(request, this.connection, objectId);
                    }
                    catch (CmisObjectNotFoundException e) {
                        this.logFDC(request, response, null, methodName);
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        deleteItemMediator.addError("error.exception.general", e.getMessage());
                    }
                    if (object == null) continue;
                    boolean allversions = this.getBooleanRequestParameter(request, "include_all_versions", false);
                    if (object.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
                        try {
                            this.deleteFolderThatHasNoChildFolders(object, allversions, deleteItemMediator);
                        }
                        catch (Exception e) {
                            if (e instanceof CmisConstraintException || e instanceof CmisRuntimeException) {
                                deleteItemMediator.addError("delete.folder.referenced", object != null ? object.getName() : "unknown");
                            } else if (!this.cmisSession.getRepositoryInfo().getCapabilities().isUnfilingSupported().booleanValue() && e instanceof CmisInvalidArgumentException) {
                                deleteItemMediator.addError("delete.folder.unfilenotsupported", object != null ? object.getName() : "unknown");
                            } else {
                                deleteItemMediator.addError("error.exception.general", e.getMessage());
                            }
                            this.logFDC(request, response, null, methodName);
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        }
                        continue;
                    }
                    this.deleteDocument(object, allversions, deleteItemMediator, request, response);
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    private void deleteFolderThatHasNoChildFolders(CmisObject object, boolean allversions, BaseMediator deleteItemMediator) {
        Folder folder = (Folder)object;
        List tree = folder.getFolderTree(1);
        if (tree.isEmpty()) {
            folder.deleteTree(allversions, UnfileObject.UNFILE, false);
        } else {
            folder.delete();
        }
        deleteItemMediator.addMessage("delete.successful", new Object[0]);
    }

    private void deleteAlfrescoFolder(Folder folder, boolean allversions, BaseMediator deleteItemMediator) {
        ItemIterable docs = folder.getChildren();
        if (docs != null) {
            for (CmisObject obj : docs) {
                Document doc = (Document)obj;
                try {
                    doc.refresh();
                    if (doc.getPaths().size() == 1) {
                        doc.delete(allversions);
                        continue;
                    }
                    doc.removeFromFolder((ObjectId)folder);
                }
                catch (CmisObjectNotFoundException e) {}
            }
        }
        folder.delete();
    }

    private void deleteDocument(CmisObject object, boolean allversions, BaseMediator deleteItemMediator, HttpServletRequest request, HttpServletResponse response) {
        try {
            object.delete(allversions);
            deleteItemMediator.addMessage("delete.successful", new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof CmisConstraintException || e instanceof CmisRuntimeException) {
                deleteItemMediator.addError("delete.folder.referenced", object != null ? object.getName() : "unknown");
            } else {
                deleteItemMediator.addError("error.exception.general", e.getMessage());
            }
            String methodName = "deleteDocument";
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String[] pid = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: # docids sent = " + pid.length);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.length < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        BaseMediator baseMediator = new BaseMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }
}

