/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISOpenFolderAction;
import com.ibm.ecm.util.ForwardPager;
import com.ibm.ecm.util.cmis.CMISQueryContinuationData;
import com.ibm.ecm.util.cmis.CMISQueryUtil;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISContinueQueryAction
extends CMISOpenFolderAction {
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getConfigInfo(request);
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMISSearchResultsMediator mediator = (CMISSearchResultsMediator)this.getMediator(request);
        try {
            HttpSession session = request.getSession();
            String continuationData = request.getParameter("continuationData");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "continuationData: " + continuationData);
            CMISQueryContinuationData queryData = new CMISQueryContinuationData(continuationData, false);
            if (queryData.returnOnlyFolders) {
                ForwardPager pager = (ForwardPager)session.getAttribute(queryData.sessionKey);
                List<CmisObject> hits = pager.loadNextPage();
                Collection<TypeDefinition> cds = CMISContinueQueryAction.findUniqueTypeDefinitions(hits);
                mediator.setClassDescriptions(cds);
                mediator.setServerName(queryData.serverName);
                mediator.setSearchResults(hits);
                mediator.setParentDocID(queryData.folderId);
                mediator.setMaxResultsReached(pager.isMaxResultsReached());
                mediator.addMessage(hits.size() == 1 ? "openFolder.returnedOne" : "openFolder.returned", hits.size());
                if (!pager.isEndReached()) {
                    queryData.itemsToSkip = pager.getNumberOfItemsRetrieved();
                    String data = queryData.saveToString();
                    mediator.setContinuationData(data);
                }
            } else {
                String itemsNeededParameter = request.getParameter("itemsNeeded");
                String serverName = request.getParameter("repositoryId");
                ForwardPager<QueryResult> pager = (ForwardPager<QueryResult>)session.getAttribute(queryData.sessionKey);
                if (pager == null) {
                    pager = this.executeCMISQuery(request, queryData, this.connection);
                    pager.loadItems((int)queryData.itemsToSkip);
                }
                mediator.setPageSize(this.pageSize);
                mediator.setServerName(serverName);
                mediator.setServer(this.connection);
                mediator.setContinuation(true);
                OperationContext opCtx = this.connection.getOperationContext();
                opCtx.setMaxItemsPerPage(this.pageSize);
                List<QueryResult> hitsResults = pager.loadNextPage();
                List<CmisObject> hits = CMISQueryUtil.convertQueryResults(hitsResults, this.connection.getCMISSession(), opCtx);
                if (StringUtils.isNotEmpty((String)itemsNeededParameter)) {
                    int itemsNeeded = Integer.parseInt(itemsNeededParameter);
                    while (itemsNeeded > pager.getNumberOfItemsRetrieved() && !pager.isEndReached()) {
                        List<QueryResult> nextPageResults = pager.loadNextPage();
                        List<CmisObject> nextPage = CMISQueryUtil.convertQueryResults(nextPageResults, this.connection.getCMISSession(), opCtx);
                        hits.addAll(nextPage);
                    }
                }
                if (pager.isEndReached()) {
                    session.removeAttribute(queryData.sessionKey);
                } else {
                    queryData.itemsToSkip = pager.getNumberOfItemsRetrieved();
                    continuationData = queryData.saveToString();
                    mediator.setContinuationData(continuationData);
                }
                Collection<TypeDefinition> classDescriptions = CMISContinueQueryAction.findUniqueTypeDefinitions(hits);
                mediator.setClassDescriptions(classDescriptions);
                mediator.setServerName(serverName);
                mediator.setSearchResults(hits);
                mediator.setParentDocID(queryData.folderId);
                mediator.setMaxResultsReached(pager.isMaxResultsReached());
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " after adding search results to session.");
                mediator.addMessage("search.results.returned", pager.getNumberOfItemsRetrieved());
            }
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            mediator.addError("error.exception.general", e.getMessage());
        }
        if (Logger.isDebugLogged()) {
            String jsonString = mediator.toJSONString();
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JSON response: " + jsonString);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String contData = request.getParameter("continuationData");
        String repository = request.getParameter("repositoryId");
        return contData != null && repository != null;
    }
}

