/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISCreateObject;
import com.ibm.ecm.util.cmis.CMISObjectUtils;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISCheckInAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
        searchResultsMediator.setResponseAsHtml(((FileUploadActionForm)form).getUploadFile() != null);
        Session session = this.cmisSession;
        synchronized (session) {
            String className = null;
            String securityPolicyId = null;
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                className = request.getParameter("template_name");
                String objectId = request.getParameter("docid");
                String criterias = request.getParameter("criterias");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + (serverName != null ? serverName : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: className = " + (className != null ? className : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + (objectId != null ? objectId : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: criterias = " + (criterias != null ? criterias : ""));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: securityPolicy = " + (securityPolicyId != null ? securityPolicyId : ""));
                searchResultsMediator.setServer(this.connection);
                searchResultsMediator.setServerName(serverName);
                ObjectType typeDef = this.cmisSession.getTypeDefinition(className);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " typeDefinition = " + typeDef.getId());
                searchResultsMediator.addTypeDefinition((TypeDefinition)typeDef);
                Document doc = (Document)CMISObjectUtils.getNonCachedObject(this.cmisSession, objectId, false);
                JSONArray criteriasJsonArray = JSONArray.parse(criterias);
                CMISUtil.printProperties("before checkin", (CmisObject)doc);
                boolean asMinorVersion = this.getBooleanRequestParameter(request, "asMinorVersion", false);
                ObjectId objectIdOfCheckedInDoc = CMISCreateObject.checkIn(request, this.getUtils(request), doc, this.cmisSession, criteriasJsonArray, form, asMinorVersion);
                ArrayList<CmisObject> hits = new ArrayList<CmisObject>(1);
                Document newDoc = (Document)CMISObjectUtils.getNonCachedObject(this.cmisSession, objectIdOfCheckedInDoc, true);
                CMISUtil.printProperties("aftercheckin", (CmisObject)newDoc);
                hits.add((CmisObject)newDoc);
                searchResultsMediator.setSearchResults(hits);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        Boolean maxFileSizeExceeded;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.createMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + (serverName != null ? serverName : ""));
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + (pid != null ? pid : ""));
        if (serverName == null || serverName.trim().length() < 1) {
            searchResultsMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        searchResultsMediator.setServerName(serverName);
        if (pid == null || pid.trim().length() < 1) {
            searchResultsMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        if ((maxFileSizeExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxFileSizeExceeded.booleanValue()) {
            searchResultsMediator.addError("import.filesize.exceed.maxlength");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + (serverName != null ? serverName : ""));
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + (pid != null ? pid : ""));
        String itemTypeName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + (itemTypeName != null ? itemTypeName : ""));
        String partMimeType = request.getParameter("mimetype");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partMimeType = " + (partMimeType != null ? partMimeType : ""));
        String partLength = request.getParameter("parm_part_length");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partLength = " + (partLength != null ? partLength : ""));
        String partFileName = request.getParameter("parm_part_filename");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partFileName = " + (partFileName != null ? partFileName : ""));
    }
}

