/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.ConnectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISBaseAction
extends BaseAction {
    int maxFolders = Integer.MAX_VALUE;
    protected boolean showFieldHoverHelp = false;
    private boolean initialized = false;
    protected int pageSize;
    protected WCDateFormat wcDateFormats = null;
    protected CMISConnection connection;
    protected Session cmisSession;

    @Override
    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "execute";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        try {
            this.preUserExit(request);
            if (!(mapping.getPath().endsWith("/logon") || mapping.getPath().endsWith("/changePassword") || mapping.getPath().endsWith("/logoff") || mapping.getPath().endsWith("/getProfile"))) {
                this.connection = ConnectionUtils.getConnection(request);
                if (this.connection != null) {
                    String altOutput;
                    this.cmisSession = this.connection.getCMISSession();
                    request.setAttribute("CMIS_server", (Object)this.connection);
                    if (mapping.getPath().endsWith("/getContentItems") && (altOutput = request.getParameter("alt_output")) != null && altOutput.equalsIgnoreCase("JSON")) {
                        BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                        String message = this.getResources(request).getMessage(request.getLocale(), "properties.download.successful");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, message);
                        request.setAttribute("mediator", (Object)mediator);
                        this.writeJSONMediator(request, response);
                        return actionForward;
                    }
                } else {
                    String altOutput;
                    Logger.logError((Object)this, methodName, (ServletRequest)request, "The connection object was not found!");
                    if (mapping.getPath().endsWith("/getDocument") && ((altOutput = request.getParameter("alt_output")) == null || !altOutput.equalsIgnoreCase("JSON"))) {
                        response.sendError(500, "error.server.connection.null");
                        return actionForward;
                    }
                    BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                    mediator.addError("error.server.connection.null");
                    request.setAttribute("mediator", (Object)mediator);
                    this.writeJSONMediator(request, response);
                    return actionForward;
                }
            }
            if (!this.initialized) {
                this.initConfigInfo(request);
                this.initialized = true;
            }
            actionForward = this.executeAction(mapping, form, request, response);
            this.postUserExit(request);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            throw e;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected static Collection<TypeDefinition> findUniqueTypeDefinitionsForQueryResults(List<QueryResult> qryResults, CMISConnection session) {
        HashMap<String, ObjectType> mapOfCDs = new HashMap<String, ObjectType>();
        for (QueryResult row : qryResults) {
            String typeId = (String)row.getPropertyValueById("cmis:objectTypeId");
            ObjectType cd = session.getCMISSession().getTypeDefinition(typeId);
            String id = cd.getId();
            mapOfCDs.put(id, cd);
        }
        return mapOfCDs.values();
    }

    protected static Collection<TypeDefinition> findUniqueTypeDefinitions(List<CmisObject> objects) {
        HashMap<String, ObjectType> mapOfCDs = new HashMap<String, ObjectType>();
        for (CmisObject obj : objects) {
            ObjectType cd = obj.getType();
            String id = cd.getId();
            mapOfCDs.put(id, cd);
        }
        return mapOfCDs.values();
    }

    protected String getFileExtension(HttpServletRequest request) throws Exception {
        String methodName = "getFileExtension";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String fileName = (String)this.getAttribute(request, "parm_part_filename");
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "No file extension was specified");
            throw new Exception("No file extension");
        }
        String extension = fileName.substring(index + 1, fileName.length());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "File extension is " + extension);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return extension;
    }

    protected abstract ActionForward executeAction(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected void preUserExit(HttpServletRequest request) {
    }

    protected void postUserExit(HttpServletRequest request) {
    }

    public void getConfigInfo(HttpServletRequest request) throws Exception {
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.pageSize = repositoryConfig.getPageSize();
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
        }
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public void initConfigInfo(HttpServletRequest request) throws Exception {
        String methodName = "initConfigInfo";
        DesktopConfig desktopConfig = Config.getDesktopConfig(request);
        this.setShowFieldHoverHelp(desktopConfig.isShowFieldHoverHelp());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "showFiledFieldHelp = " + this.getShowFieldHoverHelp());
    }

    public int getMaxFolders() {
        return this.maxFolders;
    }

    public void setMaxFolders(int maxFolders) {
        this.maxFolders = maxFolders;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

