/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISObjectUtils;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMISAddToFolderAction
extends CMISBaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
        Session session = this.cmisSession;
        synchronized (session) {
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String[] documentIds = request.getParameterValues("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + documentIds.length + ")");
                String[] folderIds = request.getParameterValues("folderDocid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderIds.length + ")");
                String folderName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + folderName);
                searchResultsMediator.setServer(this.connection);
                if (this.cmisSession != null) {
                    int errorCount = 0;
                    for (String folderPID : folderIds) {
                        Folder folder = (Folder)this.cmisSession.getObject(folderPID);
                        for (String documentId : documentIds) {
                            Document doc = (Document)CMISObjectUtils.getNonCachedObject(this.cmisSession, documentId, true);
                            try {
                                doc.addToFolder((ObjectId)folder, true);
                            }
                            catch (Exception addtoFolderException) {
                                ++errorCount;
                                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)addtoFolderException);
                                searchResultsMediator.addWarning("addToFolder.warning", new Object[0]);
                            }
                        }
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Doing updates via UpdatingBatch");
                    String messageKey = null;
                    if (errorCount == 0) {
                        if (documentIds.length == 1 && folderIds.length == 1) {
                            messageKey = "addToFolder.success.singleitem.singlefolder";
                        } else if (documentIds.length > 1 && folderIds.length == 1) {
                            messageKey = "addToFolder.success.multiitem.singlefolder";
                        } else if (documentIds.length == 1 && folderIds.length > 1) {
                            messageKey = "addToFolder.success.singleitem.multifolder";
                        } else if (documentIds.length == 1 && folderIds.length > 1) {
                            messageKey = "addToFolder.success.multiitem.multifolder";
                        }
                    } else {
                        messageKey = "addToFolder.success.some.added";
                    }
                    searchResultsMediator.addMessage(messageKey, new Object[0]);
                }
            }
            catch (CmisRuntimeException re) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)re);
                searchResultsMediator.addError(re.getMessage());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator mediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String[] itemPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
        String pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + itemPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
        String[] folderPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
        pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + folderPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
    }
}

