/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISSearchTemplate;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumBaseObjectTypeIds;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISAddSearchTemplateAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMISSearchResultsMediator mediator = (CMISSearchResultsMediator)this.getMediator(request);
        Session session = this.cmisSession;
        synchronized (session) {
            try {
                String repositoryId = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + repositoryId);
                String workspaceId = request.getParameter("workspaceId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + workspaceId);
                this.getConfigInfo(request);
                String str = this.readJSON(request);
                JSONObject json = (JSONObject)JSON.parse(str);
                CMISSearchTemplate searchTemplate = new CMISSearchTemplate();
                searchTemplate.fromJSON(json);
                String name = (String)json.get("name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "name = " + name);
                String description = (String)json.get("description");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description = " + description);
                String parentFolderId = (String)json.get("parentFolderId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parentFolderId = " + parentFolderId);
                mediator.setServer(this.connection);
                if (this.cmisSession != null) {
                    // empty if block
                }
                ObjectType typeDef = this.cmisSession.getTypeDefinition(EnumBaseObjectTypeIds.CMIS_DOCUMENT.value());
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " typeDefinition.ID = " + typeDef.getId());
                mediator.addTypeDefinition((TypeDefinition)typeDef);
                Document newObject = null;
                newObject = this.CreateSearchTemplate(name + "_cmisSearchTemplate", description, parentFolderId, json.serialize(), this.cmisSession);
                if (newObject != null) {
                    ArrayList<CmisObject> hits = new ArrayList<CmisObject>(1);
                    hits.add((CmisObject)newObject);
                    mediator.setSearchResults(hits);
                }
            }
            catch (Exception de) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)de);
                String msgKey = "error.exception.general";
                Object[] msgInserts = new Object[1];
                Logger.logError((Object)this, methodName, (ServletRequest)request, de.getMessage());
                mediator.addError(msgKey, msgInserts);
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private Document CreateSearchTemplate(String fileName, String description, String folderID, String searchTemplatePayload, Session session) {
        String mimetype = "application/json; charset=UTF-8";
        byte[] buf = null;
        try {
            buf = searchTemplatePayload.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        ContentStream contentStream = session.getObjectFactory().createContentStream(fileName, (long)buf.length, mimetype, (InputStream)input);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", EnumBaseObjectTypeIds.CMIS_DOCUMENT.value());
        properties.put("cmis:name", fileName);
        Folder parentFolder = folderID != null && folderID.length() > 0 ? (Folder)this.cmisSession.getObject(folderID) : this.cmisSession.getRootFolder();
        return parentFolder.createDocument(properties, contentStream, VersioningState.MAJOR);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            mediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

