/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cmis.CMISSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.struts.actions.cmis.CMISBaseAction;
import com.ibm.ecm.util.cmis.CMISCreateObject;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMISAddItemAction
extends CMISBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String contentType = request.getParameter("parm_content_source_type");
        if (contentType != null && (contentType.equalsIgnoreCase("Document") || contentType.equalsIgnoreCase("Item"))) {
            String criterias = request.getParameter("criterias");
            JSONArray criteriasJsonArray = JSONArray.parse(criterias);
            request.setAttribute("json_post", (Object)criteriasJsonArray);
        } else if (contentType.equalsIgnoreCase("Folder")) {
            String strJsonFormData = this.readJSON(request);
            JSONArray jsonArray = JSONArray.parse(strJsonFormData);
            request.setAttribute("json_post", (Object)jsonArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMISSearchResultsMediator searchResultsMediator = (CMISSearchResultsMediator)this.getMediator(request);
        searchResultsMediator.setResponseAsHtml(((FileUploadActionForm)form).getUploadFile() != null);
        Session session = this.cmisSession;
        synchronized (session) {
            String contentType = null;
            String typeId = null;
            String securityPolicyId = null;
            try {
                Folder parentFolder;
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                typeId = request.getParameter("template_name");
                typeId = CMISUtil.mapBaseType(typeId);
                contentType = request.getParameter("parm_content_source_type");
                String folderPID = request.getParameter("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: className = " + typeId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: contentType = " + contentType);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: parent folderID = " + folderPID);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: securityPolicy = " + securityPolicyId);
                searchResultsMediator.setServer(this.connection);
                searchResultsMediator.setServerName(serverName);
                ObjectType typeDef = this.cmisSession.getTypeDefinition(typeId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " typeDefinition.ID = " + typeDef.getId());
                searchResultsMediator.addTypeDefinition((TypeDefinition)typeDef);
                if (folderPID != null && folderPID.length() > 0) {
                    parentFolder = (Folder)this.cmisSession.getObject(folderPID);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parent folder was retrieved with the id = " + parentFolder);
                } else {
                    parentFolder = this.cmisSession.getRootFolder();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "root folder is used for parent");
                }
                Folder newObject = null;
                if (contentType.equalsIgnoreCase("Document") || contentType.equalsIgnoreCase("Item")) {
                    String criterias = request.getParameter("criterias");
                    String permissions = request.getParameter("acl");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criterias = " + criterias);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "permissions = " + permissions);
                    JSONArray criteriasJsonArray = JSONArray.parse(criterias);
                    boolean asMinorVersion = this.getBooleanRequestParameter(request, "asMinorVersion", false);
                    newObject = CMISCreateObject.createDocument(request, this.getUtils(request), parentFolder, this.cmisSession, criteriasJsonArray, form, typeDef, asMinorVersion);
                } else if (contentType.equalsIgnoreCase("Folder")) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "create folder");
                    JSONArray jsonArray = (JSONArray)this.getJSONRequest(request);
                    JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                    JSONArray criteriasJsonArray = (JSONArray)jsonObj.get("criterias");
                    newObject = CMISCreateObject.createFolder(request, parentFolder, this.cmisSession, criteriasJsonArray, typeDef);
                }
                if (newObject != null) {
                    ArrayList<CmisObject> hits = new ArrayList<CmisObject>(1);
                    hits.add((CmisObject)newObject);
                    searchResultsMediator.setSearchResults(hits);
                    CMISUtil.printProperties("after create", newObject);
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        Boolean maxFileSizeExceeded;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if ((maxFileSizeExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxFileSizeExceeded.booleanValue()) {
            baseMediator.addError("import.filesize.exceed.maxlength");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMISSearchResultsMediator baseMediator = new CMISSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String contentType = request.getParameter("parm_content_source_type");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "contentType = " + contentType);
    }
}

