/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm.workflow;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.common.DKDocRoutingServiceICM;
import com.ibm.mm.sdk.common.DKDocRoutingServiceMgmtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMSuspendProcessAction
extends CMBaseAction {
    public static final int SUSPEND_FOREVER = 52560000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        BaseMediator mediator = this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                Vector<String> pidStrings = new Vector<String>();
                int pidCounter = 0;
                String pidString = request.getParameter("workItemId" + pidCounter);
                while (pidString != null) {
                    pidStrings.add(pidString);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "PID" + ++pidCounter + ">" + pidString);
                    pidString = request.getParameter("workItemId" + pidCounter);
                }
                String suspendTimeInMinsString = String.valueOf(this.getSuspendTimeInMins(request));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Suspend Time In Mins = " + suspendTimeInMinsString);
                DKDatastoreICM dkDatastoreICM = this.getDataStore(request);
                DKDocRoutingServiceICM dkDocRoutingServiceICM = this.getDKDocRoutingServiceICM(request);
                DKDocRoutingServiceMgmtICM dkDocRoutingServiceMgmtICM = dkDocRoutingServiceICM.getDocRoutingServiceMgmt();
                CMConnection connection = this.getConnection(request);
                int suspendTimeInMins = Integer.parseInt(suspendTimeInMinsString);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Suspend time in minutes = " + suspendTimeInMins);
                Object arrayList = null;
                if (arrayList == null || arrayList.cardinality() <= 0) {
                    for (int i = 0; i < pidStrings.size(); ++i) {
                        String pid = (String)pidStrings.elementAt(i);
                        dkDocRoutingServiceICM.suspendProcess(pid, suspendTimeInMins, null);
                    }
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getLocalizedMessage());
            }
            if (mediator.getErrors() == null || mediator.getErrors() != null && mediator.getErrors().isEmpty()) {
                mediator.addMessage("worklist.suspendworkflow.successful", new Object[0]);
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        BaseMediator baseMediator = new BaseMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    private int getSuspendTimeInMins(HttpServletRequest request) {
        String methodName = "getSuspendTimeInMins";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        int suspendTimeInMins = 52560000;
        String suspendOption = request.getParameter("radioSuspend");
        if (suspendOption.equalsIgnoreCase("Until")) {
            String suspendUntilDate = request.getParameter("suspendUntilDate");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Suspend Until Date: " + suspendUntilDate);
            if (suspendUntilDate != null && !suspendUntilDate.equals("")) {
                suspendTimeInMins = CMSuspendProcessAction.getSuspendTimeInMinutes(suspendUntilDate);
            }
        } else if (suspendOption.equalsIgnoreCase("For")) {
            String suspendForCount = request.getParameter("suspendForCount");
            String suspendForUnits = request.getParameter("suspendForUnits");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Suspend For Count: " + suspendForCount);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Suspend For Units: " + suspendForUnits);
            if (suspendForCount != null && !suspendForCount.equals("")) {
                suspendTimeInMins = CMSuspendProcessAction.getSuspendTimeInMinutes(Integer.valueOf(suspendForCount), suspendForUnits);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return suspendTimeInMins;
    }

    public static int getSuspendTimeInMinutes(int suspendValue, String unit) {
        int suspendTimeInMins = 52560000;
        if ("HOURS".equals(unit)) {
            suspendTimeInMins = suspendValue * 60;
        } else if ("DAYS".equals(unit)) {
            suspendTimeInMins = suspendValue * 60 * 24;
        } else if ("WEEKS".equals(unit)) {
            suspendTimeInMins = suspendValue * 60 * 24 * 7;
        } else if ("MONTHS".equals(unit)) {
            suspendTimeInMins = suspendValue * 60 * 24 * 30;
        } else if ("YEARS".equals(unit)) {
            suspendTimeInMins = suspendValue * 60 * 24 * 365;
        }
        return suspendTimeInMins;
    }

    public static int getSuspendTimeInMinutes(String date) {
        int day;
        int month;
        int year;
        try {
            StringTokenizer tk = new StringTokenizer(date, "-");
            year = Integer.parseInt(tk.nextToken());
            month = Integer.parseInt(tk.nextToken());
            day = Integer.parseInt(tk.nextToken());
        }
        catch (NumberFormatException e) {
            return 0;
        }
        Calendar till = Calendar.getInstance();
        long currentTimeMillis = till.getTime().getTime();
        till.set(year, month - 1, day, 0, 0);
        long suspendTimeInMins = (till.getTime().getTime() - currentTimeMillis) / 60000L;
        return Math.round(suspendTimeInMins);
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
    }
}

