/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.workflow.CMWorkListMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.mm.sdk.common.DKDocRoutingServiceICM;
import com.ibm.mm.sdk.common.DKDocRoutingServiceMgmtICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.text.Collator;
import java.util.Arrays;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMGetWorkListsAction
extends CMBaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        String worklistSearch = request.getParameter("worklist_desc");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "worklistSearch = " + worklistSearch);
        CMWorkListMediator worklistMediator = (CMWorkListMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            DKDocRoutingServiceICM dkDocRoutingServiceICM = this.getDKDocRoutingServiceICM(request);
            DKDocRoutingServiceMgmtICM dkDocRoutingServiceMgmtICM = dkDocRoutingServiceICM.getDocRoutingServiceMgmt();
            int worklistSize = 0;
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Retrieving worklists from the OOAPIs");
                String[] worklistNames = dkDocRoutingServiceMgmtICM.listWorkListNames();
                Arrays.sort(worklistNames, Collator.getInstance(request.getLocale()));
                worklistSize = worklistNames.length;
                Vector filteredWorklists = CMUtil.getFilteredWorklists(worklistSearch, worklistNames, request);
                worklistSize = filteredWorklists.size();
                if (worklistSize > 0) {
                    if (worklistSize > this.getMaxWorklists()) {
                        worklistMediator.addMessage("worklist.mywork.retrieve.successful.maxWorklists", worklistSize, this.getMaxWorklists());
                        worklistSize = this.getMaxWorklists();
                    } else {
                        worklistMediator.addMessage("worklist.mywork.retrieve.successful", worklistSize, this.getMaxWorklists());
                    }
                } else {
                    worklistMediator.addWarning("worklist.mywork.error.noworklists", new Object[0]);
                }
                worklistMediator.setMaxWorklists(worklistSize);
                worklistMediator.setWorklistsVec(filteredWorklists);
                worklistMediator.setDkDocRoutingServiceICM(dkDocRoutingServiceICM);
            }
            catch (DKException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                this.logFDC(request, response, null, methodName);
                if (e.errorCode() == 7917) {
                    worklistMediator.addError("worklist.mywork.error.privilege");
                }
                worklistMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMWorkListMediator worklistMediator = new CMWorkListMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)worklistMediator);
        return worklistMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String worklistSearch = request.getParameter("worklist_desc");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "worklistSearch = " + worklistSearch);
    }
}

