/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm.workflow;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKDocRoutingServiceICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKPid;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.DKWorkPackageICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMGetWorkItemsAction
extends CMBaseAction {
    private WCDateFormat wcDateFormats = null;
    private int pageSize = 0;
    private static String ORDER_BY_NAME_COLUMN = "!Name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        boolean orderAscending;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
        String entityName = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String worklistName = request.getParameter("worklist_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "WorklistName passed in - " + worklistName);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "User id = " + userid);
        String orderBy = request.getParameter("order_by");
        boolean bl = orderAscending = !this.getBooleanRequestParameter(request, "order_descending", false);
        if (orderBy == null || orderBy.length() < 1) {
            orderBy = "name";
            orderAscending = true;
        } else if (orderBy.equalsIgnoreCase(ORDER_BY_NAME_COLUMN)) {
            orderBy = "name";
        }
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            this.getConfigInfo(request);
            searchResultsMediator.setWorklistName(worklistName);
            try {
                DKDocRoutingServiceICM dkDocRoutingServiceICM = new DKDocRoutingServiceICM((dkDatastore)dsICM);
                dsICM.setOption(71, (Object)new Integer(1));
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                dkCollection workPackagesColl = dkDocRoutingServiceICM.listWorkPackages(worklistName, userid);
                dkIterator iter = workPackagesColl.createIterator();
                CMSearchResults results = this.buildWCItemsFromWorkItems(request, iter);
                results.setIsWorkflowResults(true);
                searchResultsMediator.setWorkflowMode(true);
                searchResultsMediator.setSearchResults(results);
                searchResultsMediator.setSortType(1, orderAscending, orderBy, true);
                searchResultsMediator.setSortIndex(3);
                if (results.getCount() > 0) {
                    String itemTypeName = results.getCurrentItemType();
                    DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(itemTypeName);
                    Vector<DKComponentTypeDefICM> entities = this.buildComponentTypesFromItemType(results.getItemTypes(), dsDefICM);
                    searchResultsMediator.setEntities(entities);
                    searchResultsMediator.setItemType(itemType);
                    searchResultsMediator.setSearchResults(results);
                    searchResultsMediator.setDateFormats(this.getDateFormats());
                    dkCollection referenceAttributes = itemType.listAttrGroups(99);
                    searchResultsMediator.setReferenceAttributes(referenceAttributes);
                    DKSequentialCollection compTypes = (DKSequentialCollection)itemType.listSubEntities();
                    searchResultsMediator.setChildComponents((dkCollection)compTypes);
                    RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                    if (repositoryConfig != null) {
                        String folderNameProperty;
                        String docNameProperty;
                        String[] folderDefaultColumns;
                        if (searchResultsMediator.getDisplayColumns() == null && (folderDefaultColumns = repositoryConfig.getFolderDefaultColumns()) != null && (folderDefaultColumns.length > 1 || folderDefaultColumns.length == 1 && folderDefaultColumns[0] != null && folderDefaultColumns[0].length() > 0)) {
                            searchResultsMediator.setDisplayColumns(folderDefaultColumns);
                        }
                        if ((docNameProperty = repositoryConfig.getDocNameProperty()) != null && docNameProperty.length() > 0) {
                            searchResultsMediator.setDocNameProperty(docNameProperty);
                        }
                        if ((folderNameProperty = repositoryConfig.getFolderNameProperty()) != null && folderNameProperty.length() > 0) {
                            searchResultsMediator.setFolderNameProperty(folderNameProperty);
                        }
                    }
                    searchResultsMediator.addMessage("worklist.workitems.retrieve.successful", worklistName);
                    dkDocRoutingServiceICM = null;
                }
            }
            catch (DKException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                this.logFDC(request, response, null, methodName);
                if (e.getErrorId() == 0) {
                    searchResultsMediator.addError("error.server.unavailable");
                }
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private Vector<DKComponentTypeDefICM> buildComponentTypesFromItemType(Vector<String> itemTypes, DKDatastoreDefICM dsDefICM) throws Exception {
        Vector<DKComponentTypeDefICM> entities = new Vector<DKComponentTypeDefICM>();
        for (int i = 0; i < itemTypes.size(); ++i) {
            String itemType = itemTypes.get(i);
            DKComponentTypeDefICM componentType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(itemType);
            entities.add(componentType);
        }
        return entities;
    }

    @Override
    public void getConfigInfo(HttpServletRequest request) throws Exception {
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
            this.pageSize = repositoryConfig.getPageSize();
        }
    }

    private CMSearchResults buildWCItemsFromWorkItems(HttpServletRequest request, dkIterator workPackageIter) {
        String methodName = "buildWCItemsFromWorkItems";
        CMConnection connection = this.getConnection(request);
        DKDatastoreICM datastore = this.getDataStore(request);
        CMSearchResults results = new CMSearchResults(request, connection);
        results.setPageSize(this.getPageSize());
        String entityName = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        Vector<CMItem> workItems = new Vector<CMItem>();
        Vector<String> itemTypes = new Vector<String>();
        try {
            boolean firstItem = true;
            boolean validEntityName = this.isValidateEntityName(entityName, workPackageIter);
            if (!validEntityName) {
                entityName = null;
            }
            DKSequentialCollection workItemDDOs = new DKSequentialCollection();
            workPackageIter.reset();
            int workItemCounter = 0;
            while (workPackageIter.more()) {
                DKWorkPackageICM workPackage = (DKWorkPackageICM)workPackageIter.next();
                ++workItemCounter;
                DKPid _pid = CMBaseUtil.makeDKPid(workPackage.getItemPidString());
                String itemEntityName = CMBaseUtil._getEntityName(_pid.getObjectType());
                if (!itemTypes.contains(itemEntityName)) {
                    itemTypes.add(itemEntityName);
                }
                if (firstItem) {
                    if (entityName == null || entityName.length() == 0) {
                        entityName = itemEntityName;
                    }
                    results.setCurrentItemType(entityName);
                    firstItem = false;
                }
                if (entityName == null || entityName.length() <= 0) continue;
                DKDDO ddo = CMBaseUtil.makeDDOForPid(workPackage.getItemPidString(), datastore);
                workItemDDOs.addElement((Object)ddo);
                CMItem wcItem = new CMItem(request, connection);
                wcItem.setItem(ddo, "");
                wcItem.setDateFormats(this.getDateFormats());
                wcItem.setWorkPackage(workPackage);
                wcItem.setRetrieved(true);
                workItems.add(wcItem);
            }
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.getDataStore(request));
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.basePropertyAclName(true);
            dkRetrieveOptions.resourceContent(false);
            dkRetrieveOptions.partsList(true);
            dkRetrieveOptions.partsAttributes(true);
            dkRetrieveOptions.behaviorPartsAttributesCoreOnly(true);
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            dkRetrieveOptions.functionVersionLatest(true);
            DKDatastoreICM dsICM = this.getDataStore(request);
            dsICM.retrieveObjects((dkCollection)workItemDDOs, dkRetrieveOptions.dkNVPair());
            results.newResults(workItems, true, false, true);
            results.setItemTypes(itemTypes);
        }
        catch (DKUsageError e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        return results;
    }

    private boolean isValidateEntityName(String entityName, dkIterator workPackageIter) {
        String methodName = "isValidateEntityName";
        boolean found = false;
        if (entityName != null && entityName.length() > 0) {
            workPackageIter.reset();
            try {
                while (workPackageIter.more()) {
                    DKWorkPackageICM workPackage = (DKWorkPackageICM)workPackageIter.next();
                    DKPid _pid = CMBaseUtil.makeDKPid(workPackage.getItemPidString());
                    String itemEntityName = CMBaseUtil._getEntityName(_pid.getObjectType());
                    if (!itemEntityName.equalsIgnoreCase(entityName)) continue;
                    found = true;
                    break;
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return found;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    @Override
    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator mediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        mediator.setConnection(this.getConnection(request));
        return mediator;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String entityName = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String worklistName = request.getParameter("worklist_name");
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "WorklistName passed in - " + worklistName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "User id = " + userid);
    }
}

