/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.cm.CMSearchTemplate;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKChildCollection;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMUpdateSearchTemplateAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dataStore;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMSearchResultsMediator mediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dataStore = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                this.getConfigInfo(request);
                String repositoryId = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
                String pid = request.getParameter("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "pid = " + pid);
                String str = this.readJSON(request);
                JSONObject json = (JSONObject)JSON.parse(str);
                CMSearchTemplate searchTemplate = new CMSearchTemplate();
                searchTemplate.fromJSON(json);
                DKDDO ddo = dataStore.createDDOFromPID(pid);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dataStore);
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                dkRetrieveOptions.childListOneLevel(true);
                dkRetrieveOptions.childAttributes(true);
                dkRetrieveOptions.functionVersionLatest(true);
                ddo.retrieve(dkRetrieveOptions.dkNVPair());
                DKDatastoreExtICM dataStoreExt = this.getDataStoreExt(request);
                if (!dataStoreExt.isCheckedOut((dkDataObject)ddo)) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Search is not checked out");
                    mediator.addError("checkin.error.notCheckedOut");
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Search is checked out");
                String name = (String)json.get("name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "name = " + name);
                String description = (String)json.get("description");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description = " + description);
                ddo.setData(ddo.dataId("ICM$NAME"), (Object)name);
                ddo.setData(ddo.dataId("clbDescription"), (Object)description);
                ddo.setData(ddo.dataId("clbAutoRun"), (Object)(searchTemplate.isAutoRun() ? 1 : 0));
                ddo.setData(ddo.dataId("clbShowInTree"), (Object)(searchTemplate.isShowInTree() ? 1 : 0));
                DKChildCollection children = (DKChildCollection)ddo.getData(ddo.dataId("CHILD", "ICMSearchData"));
                if (children != null) {
                    DKDDO child = (DKDDO)children.createIterator().next();
                    child.setData(child.dataId("ATTR", "clbSearchJSON"), (Object)searchTemplate.toPersistableJSON().toString());
                }
                dataStore.updateObject((dkDataObject)ddo, 0);
                ddo.retrieve(dkRetrieveOptions.dkNVPair());
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dataStore.datastoreDef();
                DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity("ICMSearch");
                mediator.setConnection(this.getConnection(request));
                mediator.setItemType(itemType);
                mediator.setReferenceAttributes(itemType.listAttrGroups(99));
                mediator.setDateFormats(this.getDateFormats());
                CMConnection connection = this.getConnection(request);
                dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                dkRetrieveOptions.basePropertyAclName(true);
                CMItem item = connection.retrieveItem(ddo.getPidObject().pidString(), request, dkRetrieveOptions);
                CMSearchResults searchResults = new CMSearchResults(request, connection);
                Vector<CMItem> items = new Vector<CMItem>();
                items.add(item);
                searchResults.newResults(items, true, false, false);
                mediator.setSearchResults(searchResults);
                mediator.addMessage("document.checkin.successful", new Object[0]);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String docId = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + docId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (docId == null || docId.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String docId = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "docId = " + docId);
    }
}

