/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMAnnotationsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMUpdateAnnotationsAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        BaseMediator annotationsMediator = null;
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Reading anotation data from request");
                byte[] buf = null;
                int numRead = 0;
                int totalBytesRead = 0;
                ServletInputStream requestInputStream = request.getInputStream();
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(4096);
                buf = new byte[4096];
                numRead = requestInputStream.read(buf);
                while (numRead != -1) {
                    totalBytesRead += numRead;
                    byteOutputStream.write(buf, 0, numRead);
                    numRead = requestInputStream.read(buf);
                }
                requestInputStream.close();
                byteOutputStream.close();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Total bytes read: " + totalBytesRead);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Annotations in JSON format.  Converting to CM format.");
                int annotationPosition = 1400;
                String annotationPositionString = request.getParameter("annotation_position");
                if (annotationPositionString != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "annotation_position = " + annotationPositionString);
                    try {
                        annotationPosition = Integer.parseInt(annotationPositionString);
                        String apiVersion = dsICM.getAPIVersion();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "CM API Version: " + apiVersion);
                        if (apiVersion.startsWith("8.3") && apiVersion.compareTo("8.3.0.950") < 0) {
                            annotationPosition &= 0xFFFFFF;
                        } else if (apiVersion.startsWith("8.4.0")) {
                            annotationPosition &= 0xFFFFFF;
                        } else if (apiVersion.startsWith("8.4.1") && apiVersion.compareTo("8.4.1.100") < 0) {
                            annotationPosition &= 0xFFFFFF;
                        }
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "adjusted annotation position: " + annotationPosition);
                    }
                    catch (NumberFormatException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        if (annotationsMediator != null) {
                            annotationsMediator.addError("error.exception.general", e.getMessage());
                        }
                        response.setStatus(400);
                    }
                }
                Locale.setDefault(request.getLocale());
                String jsonAnnotationString = new String(byteOutputStream.toByteArray(), "UTF-8");
                JSONObject jsonAnnotationObject = JSONObject.parse(jsonAnnotationString);
                annotationsMediator = new CMAnnotationsMediator(request, this.getResources(request), request.getLocale());
                ((CMAnnotationsMediator)annotationsMediator).fromJSONObject(jsonAnnotationObject, annotationPosition);
                request.setAttribute("mediator", (Object)annotationsMediator);
                CMObject newAnnotation = ((CMAnnotationsMediator)annotationsMediator).getAnnotation();
                String pid = request.getParameter("docid");
                CMConnection connection = this.getConnection(request);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.partsList(true);
                dkRetrieveOptions.partsAttributes(true);
                CMItem item = connection.retrieveItem(pid, request, dkRetrieveOptions);
                boolean newVersion = ((CMAnnotationsMediator)annotationsMediator).isNewVersion();
                int partNum = 0;
                int currentAnnotationCount = item.getAnnotationCount();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Current annotation part count: " + currentAnnotationCount + "; part being replaced=" + partNum);
                if (currentAnnotationCount > partNum) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Updating existing annotation part");
                    item.updateAnnotation(partNum, newAnnotation, newVersion);
                } else if (currentAnnotationCount <= partNum) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Adding new annotation part");
                    if (newVersion) {
                        CMObject emptyAnnotation = new CMObject(new byte[0], "application/vnd.ibm.modcap");
                        item.addAnnotation(emptyAnnotation);
                        item.updateAnnotation(partNum, newAnnotation, true);
                    } else {
                        item.addAnnotation(newAnnotation);
                    }
                }
            }
            catch (IOException e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                if (annotationsMediator != null) {
                    annotationsMediator.addError("error.exception.general", e.getMessage());
                }
                response.setStatus(400);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                if (annotationsMediator != null) {
                    annotationsMediator.addError("error.exception.general", e.getMessage());
                }
                response.setStatus(500);
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMAnnotationsMediator baseMediator = new CMAnnotationsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
    }
}

