/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMUnlockItemAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM dsICM = this.getDataStore(request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering synchronized block");
        DKDatastoreICM dKDatastoreICM = dsICM;
        synchronized (dKDatastoreICM) {
            try {
                String docId = request.getParameter("docid");
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                String entityName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
                searchResultsMediator.setDateFormats(WCDateFormat.getDefaultDateFormats(request));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
                String[] docIds = request.getParameterValues("docid");
                DKDatastoreICM ds = this.getDataStore(request);
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)ds.datastoreDef();
                DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(entityName);
                searchResultsMediator.setItemType(itemType);
                dkCollection referenceAttributes = itemType.listAttrGroups(99);
                searchResultsMediator.setReferenceAttributes(referenceAttributes);
                DKSequentialCollection compTypes = (DKSequentialCollection)itemType.listSubEntities();
                searchResultsMediator.setChildComponents((dkCollection)compTypes);
                searchResultsMediator.setConnection(this.getConnection(request));
                DKDatastoreExtICM dsExt = this.getDataStoreExt(request);
                Vector<String> errorItemNames = new Vector<String>();
                Vector<CMItem> vectorHits = new Vector<CMItem>(docIds.length);
                ArrayList<String> errorItemMessages = new ArrayList<String>();
                CMItem item = null;
                CMConnection connection = this.getConnection(request);
                if (ds != null && ds.isConnected() && dsExt.isSupported("checkIn")) {
                    for (int i = 0; i < docIds.length; ++i) {
                        try {
                            DKDDO icmddo = ds.createDDOFromPID(docIds[i]);
                            item = new CMItem(request, connection, icmddo, "", false, false, false);
                            item.setDateFormats(WCDateFormat.getDefaultDateFormats(request));
                            vectorHits.add(item);
                            if (dsExt.isCheckedOut((dkDataObject)icmddo)) {
                                dsExt.checkIn((dkDataObject)icmddo);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item is unlocked " + docIds[i]);
                            } else {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item not checked out");
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "user name currently logged on=" + dsExt.getDatastore().userName());
                            }
                            boolean checkedOut = item.isCheckedOut();
                            String user = item.getCheckedOutUserid();
                            item.getAttrName();
                            item.getAttrValues();
                            item.getMimeType();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item value unlocked  = " + checkedOut + " and checked out by " + user + " getAttrName= " + item.getAttrName() + "");
                            continue;
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                            if (item == null) continue;
                            errorItemNames.add(item.getName());
                            errorItemMessages.add(e.getLocalizedMessage());
                        }
                    }
                }
                CMSearchResults newSearchResults = new CMSearchResults(request, connection);
                newSearchResults.newResults(vectorHits, false, false, false);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of items found -->  [Vector = " + vectorHits.size() + "] [SearchResults Bean = " + newSearchResults.getCount() + "]");
                searchResultsMediator.setSearchResults(newSearchResults);
                if (docIds.length > 1) {
                    if (errorItemNames.size() == 0) {
                        searchResultsMediator.addMessage("document.cancelcheckout.multi.success", String.valueOf(docIds.length));
                    } else {
                        String docNames = "";
                        for (int i = 0; i < errorItemNames.size(); ++i) {
                            if (i > 0) {
                                docNames = docNames + "<br/><br/>";
                            }
                            docNames = docNames + ((String)errorItemNames.get(i)).toString() + ": " + (String)errorItemMessages.get(i);
                        }
                        searchResultsMediator.addWarning("document.cancelcheckout.partial", errorItemNames.size(), docNames);
                    }
                } else if (errorItemNames.size() == 0) {
                    searchResultsMediator.addMessage("document.cancelcheckout.successful", new Object[0]);
                } else {
                    searchResultsMediator.addMessage("document.cancelcheckout.error", new Object[0]);
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Leaving synchronized block");
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
    }
}

