/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.struts.actions.cm.CMOpenItemTypeAction;
import com.ibm.ecm.struts.actions.cm.CMQueryContinuationData;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.ecm.util.cm.CMSearchTemplate;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDataObjectNotFound;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMSearchAction
extends CMBaseAction {
    private boolean includeMIMETypes = true;
    private boolean useMaxResults = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, "executeAction", (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        DKDatastoreICM dataStore = this.getDataStore(request);
        CMSearchResultsMediator mediator = (CMSearchResultsMediator)this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        String templateName = request.getParameter("template_name");
        String teamspaceId = request.getParameter("teamspaceId");
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "repositoryId = " + repositoryId);
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "template_name = " + templateName);
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "teamspaceId = " + teamspaceId);
        String includeRecords = request.getParameter("include_records");
        String includeLocked = request.getParameter("include_locked");
        String jsonCriteria = request.getParameter("criterias");
        String orderBy = request.getParameter("order_by");
        boolean orderDescending = this.getBooleanRequestParameter(request, "order_descending", false);
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "PARM_SEARCH_INCLUDE_RECORDS = " + includeRecords);
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "PARM_SEARCH_INCLUDE_LOCKED_ITEMS = " + includeLocked);
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "jsonCriteria = " + jsonCriteria);
        ActionForward actionForward = null;
        DKDatastoreICM dKDatastoreICM = dataStore;
        synchronized (dKDatastoreICM) {
            try {
                if (repositoryId != null) {
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "New results request");
                    this.getConfigInfo(request);
                    CMConnection connection = this.getConnection(request);
                    CMSearchTemplate searchTemplate = new CMSearchTemplate();
                    String templateString = this.readJSON(request);
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "json = " + templateString);
                    JSONObject searchTemplateJson = (JSONObject)JSON.parse(templateString);
                    if (!searchTemplateJson.isEmpty()) {
                        searchTemplate.fromJSON(searchTemplateJson);
                    } else if (templateName != null && templateName.length() > 0) {
                        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                        dkRetrieveOptions.baseAttributes(true);
                        dkRetrieveOptions.childAttributes(true);
                        dkRetrieveOptions.childListOneLevel(true);
                        CMItem cmItem = connection.retrieveItem(templateName, request, dkRetrieveOptions);
                        CMItem[] children = cmItem.getAttrItems("ICMSearchData");
                        String value = children[0].getAttrValue("clbSearchJSON");
                        JSONObject json = (JSONObject)JSON.parse(value);
                        searchTemplate.load(request, dataStore, Config.getRepositoryConfig(request), json);
                    } else {
                        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "No criteria or search ID specified");
                        mediator.addError("error.exception.general");
                        this.writeJSONMediator(request, response);
                        Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
                        return actionForward;
                    }
                    List<SearchTemplate.SearchFolder> folders = searchTemplate.getFolders();
                    if (folders != null) {
                        for (SearchTemplate.SearchFolder folder : folders) {
                            if (!folder.getId().equals(SearchTemplate.THIS_TEAMSPACE_ID)) continue;
                            if (teamspaceId != null && teamspaceId.length() > 0) {
                                folder.setId(teamspaceId);
                                continue;
                            }
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "No teamspace ID to substitute macro");
                            mediator.addError("search.exception.unsupportedTeamspaceSearch", searchTemplate.getDisplayName());
                            this.writeJSONMediator(request, response);
                            Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
                            return actionForward;
                        }
                    }
                    CMQueryService queryService = new CMQueryService(request, connection, dataStore);
                    queryService.setSearchForCheckedItems(includeLocked != null && includeLocked.equalsIgnoreCase("true"));
                    SearchTemplate.ObjectType objectType = searchTemplate.getObjectType();
                    if (objectType != null && objectType == SearchTemplate.ObjectType.document) {
                        queryService.setSearchForDocuments(true);
                    } else if (objectType != null && objectType == SearchTemplate.ObjectType.folder) {
                        queryService.setSearchForFolders(true);
                    } else {
                        queryService.setSearchForFolders(false);
                        queryService.setSearchForDocuments(false);
                    }
                    SearchTemplate.VersionOption versionOption = searchTemplate.getVersionOption();
                    boolean retrieveLatestVersion = versionOption != null && versionOption == SearchTemplate.VersionOption.currentversion;
                    queryService.setVersion(retrieveLatestVersion ? "LATEST_VERSION" : "ALL_VERSIONS");
                    queryService.setPropertyTextSearchAnded(searchTemplate.isPropertyTextAnded());
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "retrieveLatestVersion = " + retrieveLatestVersion);
                    if (searchTemplate.getResultsDisplay() != null && (orderBy == null || orderBy.length() == 0)) {
                        orderBy = searchTemplate.getResultsDisplay().getSortByProperty();
                        orderDescending = !searchTemplate.getResultsDisplay().getSortAscending();
                    }
                    String entityName = searchTemplate.getFirstClassName();
                    if (orderBy != null) {
                        if (entityName.equals("$common")) {
                            try {
                                CMSearchConstants.SystemAttribute.valueOf(orderBy);
                                queryService.setSortBy(orderBy);
                                queryService.setSortDescending(orderDescending);
                            }
                            catch (Exception e) {
                                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Order by is not a system attribute. Results will be sorted after the query.");
                                String sortAfterQueryProperty = orderBy.equalsIgnoreCase("!Name") ? "name" : orderBy;
                                mediator.setSortType(1, !orderDescending, sortAfterQueryProperty, false);
                            }
                        } else {
                            queryService.setSortBy(orderBy);
                            queryService.setSortDescending(orderDescending);
                        }
                    }
                    Locale locale = request.getLocale();
                    String queryString = queryService.generateQueryExpression(searchTemplate, searchTemplate.isAndSearch(), resources, locale);
                    queryString = queryService.addQueryConditions(queryString);
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Query String = " + queryString);
                    CMBaseAction.QueryOutput out = this.runQuery(request, dataStore, queryString, 0, this.pageSize, retrieveLatestVersion, this.useMaxResults, true);
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "initial search returned count: " + out.count);
                    boolean hasMore = out.hasMore;
                    if (hasMore) {
                        String entityNames = entityName;
                        List<SearchTemplate.SearchClass> classes = searchTemplate.getClasses();
                        if (classes != null && classes.size() > 0) {
                            entityNames = "";
                            for (SearchTemplate.SearchClass searchClass : classes) {
                                if (!entityNames.isEmpty()) {
                                    entityNames = entityNames + ",";
                                }
                                entityNames = entityNames + searchClass.getName();
                            }
                        }
                        CMQueryContinuationData data = new CMQueryContinuationData(queryString, entityNames, retrieveLatestVersion, this.useMaxResults, mediator.getSortAfterQueryProperty(), mediator.getSortAscending(), mediator.getFoldersFirst());
                        String serializedContinuationData = data.saveToString();
                        mediator.setContinuationData(serializedContinuationData);
                    }
                    CMSearchResults results = new CMSearchResults(request, connection);
                    results.newResults(out.items, this.includeMIMETypes, true, false, true);
                    mediator.setShowVersions(!retrieveLatestVersion);
                    mediator.setDateFormats(this.wcDateFormats);
                    mediator.setSearchResults(results);
                    DKDatastoreDefICM datastoreDef = (DKDatastoreDefICM)dataStore.datastoreDef();
                    DKComponentTypeDefICM itemType = null;
                    if (entityName.equals("$common")) {
                        mediator.setAllItemtypesView(true);
                        Collection<DKComponentTypeDefICM> itemTypes = this.getUniqueItemTypes(request, out.items, datastoreDef);
                        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Unique item type count: " + itemTypes.size());
                        mediator.setEntities(itemTypes);
                        mediator.setChildComponents(null);
                        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dataStore.datastoreDef();
                        dkCollection attributes = dsDefICM.listAttrs();
                        mediator.setAttrColl(attributes);
                        mediator.setAllowNonSystemAttributeSorting(!hasMore);
                    } else {
                        List<SearchTemplate.SearchClass> classes = searchTemplate.getClasses();
                        if (classes != null && classes.size() > 0) {
                            for (SearchTemplate.SearchClass searchClass : classes) {
                                DKComponentTypeDefICM it = (DKComponentTypeDefICM)datastoreDef.retrieveEntity(searchClass.getName());
                                if (it == null) {
                                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Item type not found: " + searchClass.getName());
                                    continue;
                                }
                                if (itemType == null && classes.size() == 1) {
                                    itemType = it;
                                    mediator.setItemType(it);
                                }
                                mediator.addEntity(it);
                                searchClass.setDisplayName(it.getDescription());
                                this.intersect(mediator, it);
                            }
                        }
                    }
                    int resultsTotal = results.getCount();
                    if (resultsTotal >= this.maxResults) {
                        mediator.addMessage("search.results.returned.limit", this.maxResults);
                    } else {
                        mediator.addMessage(resultsTotal == 1 ? "search.results.returnedOne" : "search.results.returned", resultsTotal);
                    }
                    if (searchTemplate.getResultsDisplay() != null) {
                        mediator.setDisplayColumns(searchTemplate.getResultsDisplay().getColumns());
                        if (itemType != null) {
                            mediator.setNameProperty(CMBaseUtil.getNameAttrForEntity(request, itemType));
                        }
                        if (orderBy != null && orderBy.length() > 0) {
                            mediator.setSortByProperty(orderBy);
                            mediator.setSortDirection(orderDescending ? -1 : 1);
                        } else {
                            mediator.setSortDirection(0);
                        }
                    }
                } else {
                    mediator.addError("error.parm.null", "repositoryId");
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, "executeAction");
                Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)e);
                if (e instanceof DKDataObjectNotFound) {
                    mediator.addError("error.exception.opensearchnotfound", templateName);
                }
                if (e.getMessage() != null && e.getMessage().indexOf("DGL5055A") > -1) {
                    mediator.addError("search.exception.textSearchNotStarted", e);
                }
                mediator.addError("error.exception.general", e);
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
        return actionForward;
    }

    private void intersect(CMSearchResultsMediator criteriaMediator, DKComponentTypeDefICM itemType) throws Exception {
        criteriaMediator.setResultAttributes(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getResultAttributes(), itemType.listAllAttributes()));
        criteriaMediator.setReferenceAttributes(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getReferenceAttributes(), itemType.listAttrGroups(99)));
        criteriaMediator.setChildComponents(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getChildComponents(), itemType.listSubEntities()));
    }

    public void getConfigInfo(HttpServletRequest request) throws Exception {
        super.getConfigInfo(request);
        String methodName = "getConfigInfo";
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.maxItemTypes = repositoryConfig.getMaxItemTypes();
            this.includeMIMETypes = this.getBooleanRequestParameter(request, "includeMIMETypesInSearchResults", repositoryConfig.getIncludeMIMETypesInSearchResults());
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
            if (repositoryConfig.getMaxResults() > 0) {
                this.setMaxResults(repositoryConfig.getMaxResults());
                this.useMaxResults = true;
            } else {
                this.setMaxResults(Integer.MAX_VALUE);
                this.useMaxResults = false;
            }
        }
        Logger.logDebug((Object)this, "getConfigInfo", (ServletRequest)request, "includeMIMETypes = " + this.includeMIMETypes);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator mediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        mediator.setConnection(this.getConnection(request));
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "template_name = " + entityName);
        String searchConjunction = request.getParameter("andSearch");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "PARM_TEMPLATE_IS_AND_SEARCH = " + searchConjunction);
        String includeRecords = request.getParameter("include_records");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "PARM_SEARCH_INCLUDE_RECORDS = " + includeRecords);
        String includeLocked = request.getParameter("include_locked");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "PARM_SEARCH_INCLUDE_LOCKED_ITEMS = " + includeLocked);
        String includeAllVersions = request.getParameter("include_all_versions");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "PARM_SEARCH_INCLUDE_ALL_VERSIONS = " + includeAllVersions);
        String jsonCriteria = request.getParameter("criterias");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "jsonCriteria = " + jsonCriteria);
    }
}

