/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.struts.actions.cm.CMOpenItemTypeAction;
import com.ibm.ecm.struts.actions.cm.CMQueryContinuationData;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMRetrieveNextPageAction
extends CMBaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, "executeAction", (ServletRequest)request);
        this.getConfigInfo(request);
        DKDatastoreICM dataStore = this.getDataStore(request);
        CMSearchResultsMediator mediator = (CMSearchResultsMediator)this.getMediator(request);
        mediator.setConnection(this.getConnection(request));
        mediator.setContinuation(true);
        String itemsNeededParameter = request.getParameter("itemsNeeded");
        int itemsToSkip = Integer.parseInt(request.getParameter("skip"));
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "ContinuationData found, skip items: " + itemsToSkip);
        DKDatastoreICM dKDatastoreICM = dataStore;
        synchronized (dKDatastoreICM) {
            try {
                RepositoryConfig repositoryConfig;
                this.getConfigInfo(request);
                int newItemsToRetrieve = this.pageSize;
                if (itemsNeededParameter != null && !itemsNeededParameter.equals("")) {
                    double itemsNeeded = Integer.parseInt(itemsNeededParameter);
                    double itemsNeededToReturn = itemsNeeded - (double)itemsToSkip;
                    int numberOfPagesNeeded = (int)Math.ceil(itemsNeededToReturn / (double)this.pageSize);
                    newItemsToRetrieve = numberOfPagesNeeded * this.pageSize;
                }
                String contDataStr = request.getParameter("continuationData");
                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "continuationData: " + contDataStr);
                CMQueryContinuationData data = new CMQueryContinuationData(contDataStr);
                String queryString = data.getQuery();
                String itemType = data.getItemType();
                boolean retrieveLatestVersion = data.isRetrieveLatestVersion();
                boolean useMaxResults = data.isUsingMaxResults();
                if (useMaxResults && (repositoryConfig = Config.getRepositoryConfig(request)).getMaxResults() > 0) {
                    this.setMaxResults(repositoryConfig.getMaxResults());
                }
                DKDatastoreDefICM datastoreDef = (DKDatastoreDefICM)dataStore.datastoreDef();
                if (itemType.equals("$common")) {
                    mediator.setChildComponents(null);
                } else {
                    String[] itemTypes = itemType.split(",");
                    for (int i = 0; i < itemTypes.length; ++i) {
                        DKComponentTypeDefICM typeDef = (DKComponentTypeDefICM)datastoreDef.retrieveEntity(itemTypes[i]);
                        if (typeDef == null) {
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Item type not found: " + itemTypes[i]);
                            continue;
                        }
                        if (i == 0) {
                            mediator.setItemType(typeDef);
                        }
                        mediator.addEntity(typeDef);
                        this.intersect(mediator, typeDef);
                    }
                }
                String sortAfterQueryProperty = data.getSortAfterQueryProperty();
                if (!sortAfterQueryProperty.isEmpty()) {
                    mediator.setSortType(1, data.getSortAfterQueryAscending(), sortAfterQueryProperty, data.getSortAfterFoldersFirst());
                }
                CMBaseAction.QueryOutput out = this.runQuery(request, dataStore, queryString, itemsToSkip, newItemsToRetrieve, retrieveLatestVersion, useMaxResults, true);
                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "query for the next page retrieved item count: " + out.count);
                if (out.hasMore) {
                    mediator.setContinuationData(contDataStr);
                }
                if (out.count != 0) {
                    Collection<DKComponentTypeDefICM> itemTypes = this.getUniqueItemTypes(request, out.items, datastoreDef);
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "unique folder item types count: " + itemTypes.size());
                    mediator.setEntities(itemTypes);
                }
                CMConnection connection = this.getConnection(request);
                CMSearchResults results = new CMSearchResults(request, connection);
                results.newResults(out.items, true, false, true);
                mediator.setSearchResults(results);
                mediator.setMaxResultsReached(out.maxResultsReached);
                mediator.addMessage(out.position == this.maxResults ? "openFolder.returned.limit" : "openFolder.returned", out.position);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, "executeAction");
                Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
        return null;
    }

    private void intersect(CMSearchResultsMediator criteriaMediator, DKComponentTypeDefICM itemType) throws Exception {
        criteriaMediator.setResultAttributes(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getResultAttributes(), itemType.listAllAttributes()));
        criteriaMediator.setReferenceAttributes(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getReferenceAttributes(), itemType.listAttrGroups(99)));
        criteriaMediator.setChildComponents(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getChildComponents(), itemType.listSubEntities()));
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        MessageResources resources = this.getResources(request);
        CMSearchResultsMediator mediator = new CMSearchResultsMediator(request, resources, request.getLocale());
        mediator.setDateFormats(this.wcDateFormats);
        mediator.setAllItemtypesView(true);
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String contData = request.getParameter("continuationData");
        String repository = request.getParameter("repositoryId");
        return contData != null && repository != null;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
    }
}

