/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMRemoveFromFolderAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                String[] itemPIDs = request.getParameterValues("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
                String folderPID = request.getParameter("folderDocid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPID = " + folderPID);
                String entityName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(entityName);
                searchResultsMediator.setItemType(itemType);
                dkCollection referenceAttributes = itemType.listAttrGroups(99);
                searchResultsMediator.setReferenceAttributes(referenceAttributes);
                DKSequentialCollection compTypes = (DKSequentialCollection)itemType.listSubEntities();
                searchResultsMediator.setChildComponents((dkCollection)compTypes);
                searchResultsMediator.setConnection(this.getConnection(request));
                if (dsICM != null && dsICM.isConnected()) {
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.basePropertyAclName(true);
                    dkRetrieveOptions.linksOutbound(true);
                    DKDDO folderDDO = dsICM.createDDO(folderPID);
                    DKPidICM folderPIDObject = (DKPidICM)folderDDO.getPidObject();
                    if (folderPIDObject.getVersionNumber().equals("0")) {
                        folderPIDObject.setVersionNumber("1");
                        dkRetrieveOptions.functionVersionLatest(true);
                    }
                    folderDDO.retrieve(dkRetrieveOptions.dkNVPair());
                    CMConnection connection = this.getConnection(request);
                    CMItem folderItem = new CMItem(request, connection, folderPID);
                    folderItem.setItem(folderDDO, null);
                    folderItem.setDateFormats(this.getDateFormats());
                    String itemPID = null;
                    CMItem tempItem = null;
                    DKDDO tempDDO = null;
                    CMItem[] toBeDeletedItems = new CMItem[itemPIDs.length];
                    for (int iItemCounter = 0; iItemCounter < itemPIDs.length; ++iItemCounter) {
                        itemPID = itemPIDs[iItemCounter];
                        tempDDO = dsICM.createDDO(itemPID);
                        tempItem = new CMItem(request, connection, itemPID);
                        tempItem.setItem(tempDDO, null);
                        tempItem.setDateFormats(this.getDateFormats());
                        toBeDeletedItems[iItemCounter] = tempItem;
                    }
                    dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.basePropertyAclName(true);
                    dkRetrieveOptions.linksOutbound(false);
                    CMItem.retrieveItemGroup(request, toBeDeletedItems, dkRetrieveOptions);
                    ArrayList<String> errorItemNames = new ArrayList<String>();
                    ArrayList<String> errorItemMessages = new ArrayList<String>();
                    String folderName = folderItem.getName();
                    int errorCount = 0;
                    String itemName = "";
                    boolean itemsNotFound = false;
                    for (int iItemCounter = 0; iItemCounter < toBeDeletedItems.length; ++iItemCounter) {
                        try {
                            itemName = toBeDeletedItems[iItemCounter].getName();
                            folderItem.removeFolderItem(toBeDeletedItems[iItemCounter]);
                            continue;
                        }
                        catch (Exception removeItemFromFolderException) {
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)removeItemFromFolderException);
                            if (removeItemFromFolderException instanceof ArrayIndexOutOfBoundsException) {
                                itemsNotFound = true;
                                continue;
                            }
                            ++errorCount;
                            errorItemNames.add(itemName);
                            errorItemMessages.add(removeItemFromFolderException.getLocalizedMessage());
                        }
                    }
                    if (errorCount == 0) {
                        if (itemsNotFound) {
                            searchResultsMediator.addWarning("removeFromFolder.notFound", new Object[0]);
                        } else if (itemPIDs.length > 1) {
                            searchResultsMediator.addMessage("removeFromFolder.multi.success", new Object[0]);
                        } else {
                            searchResultsMediator.addMessage("removeFromFolder.single.success", folderName, itemName);
                        }
                    } else if (itemPIDs.length > 1) {
                        String docNames = "";
                        Integer errorItemCounter = 0;
                        while (errorItemCounter < errorItemNames.size()) {
                            String docName = (String)errorItemNames.get(errorItemCounter);
                            String reason = (String)errorItemMessages.get(errorItemCounter);
                            if (docNames.length() > 0) {
                                docNames = docNames + "<br/><br/>";
                            }
                            docNames = docNames + docName + ": " + reason;
                            Integer n = errorItemCounter;
                            Integer n2 = errorItemCounter = Integer.valueOf(errorItemCounter + 1);
                        }
                        searchResultsMediator.addWarning("removeFromFolder.partial", errorItemCounter.toString(), docNames);
                    } else {
                        searchResultsMediator.addWarning("removeFromFolder.single.warning", folderName, itemName);
                    }
                }
            }
            catch (DKException de) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)de);
                String errorMsg = "error.exception.general";
                switch (de.getErrorId()) {
                    case 5160: 
                    case 5161: 
                    case 5162: 
                    case 5163: 
                    case 5164: 
                    case 5165: {
                        errorMsg = "error.rmserver.exception";
                        break;
                    }
                    default: {
                        errorMsg = "error.exception.general";
                    }
                }
                searchResultsMediator.addError(errorMsg, de.getMessage());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String[] itemPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
        String pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + itemPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
        String[] folderPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
        pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + folderPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
    }
}

