/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class CMQueryContinuationData {
    private static final String SALT = "upiOIM38DciARw4lwlOI";
    private String query;
    private String itemType;
    private String sortAfterQueryProperty;
    private boolean retrieveLatestVersion = false;
    private boolean useMaxResults = false;
    private boolean sortAfterQueryAscending = true;
    private boolean sortAfterFoldersFirst = true;

    public CMQueryContinuationData(String serializedForm) throws UnsupportedEncodingException {
        String[] parts = StringUtils.splitPreserveAllTokens((String)serializedForm, (char)'*');
        this.query = new String(Base64.decodeBase64((String)parts[0]), "UTF-8");
        this.itemType = new String(Base64.decodeBase64((String)parts[1]), "UTF-8");
        this.retrieveLatestVersion = new Boolean(new String(Base64.decodeBase64((String)parts[2]), "UTF-8"));
        this.useMaxResults = new Boolean(new String(Base64.decodeBase64((String)parts[3]), "UTF-8"));
        this.sortAfterQueryProperty = new String(Base64.decodeBase64((String)parts[4]), "UTF-8");
        this.sortAfterQueryAscending = new Boolean(new String(Base64.decodeBase64((String)parts[5]), "UTF-8"));
        this.sortAfterFoldersFirst = new Boolean(new String(Base64.decodeBase64((String)parts[6]), "UTF-8"));
        String checksum = parts[7];
        String calculatedChecksum = this.calculateChecksum();
        if (!StringUtils.equals((String)checksum, (String)calculatedChecksum)) {
            throw new RuntimeException("Invalid checksum!");
        }
    }

    public CMQueryContinuationData(String query, String itemType, boolean retrieveLatestVersion, boolean useMaxResults, String sortAfterQueryProperty, boolean sortAfterQueryAscending, boolean sortAfterFoldersFirst) {
        this.query = query;
        this.itemType = itemType;
        this.retrieveLatestVersion = retrieveLatestVersion;
        this.useMaxResults = useMaxResults;
        this.sortAfterQueryProperty = sortAfterQueryProperty != null ? sortAfterQueryProperty : "";
        this.sortAfterQueryAscending = sortAfterQueryAscending;
        this.sortAfterFoldersFirst = sortAfterFoldersFirst;
    }

    public String saveToString() throws UnsupportedEncodingException {
        String checksum = this.calculateChecksum();
        String result = StringUtils.join((Object[])new String[]{Base64.encodeBase64String((byte[])this.query.getBytes("UTF-8")).trim(), Base64.encodeBase64String((byte[])this.itemType.getBytes("UTF-8")).trim(), Base64.encodeBase64String((byte[])("" + this.retrieveLatestVersion).getBytes("UTF-8")), Base64.encodeBase64String((byte[])("" + this.useMaxResults).getBytes("UTF-8")), Base64.encodeBase64String((byte[])this.sortAfterQueryProperty.getBytes("UTF-8")).trim(), Base64.encodeBase64String((byte[])("" + this.sortAfterQueryAscending).getBytes("UTF-8")).trim(), Base64.encodeBase64String((byte[])("" + this.sortAfterFoldersFirst).getBytes("UTF-8")).trim(), checksum}, (char)'*');
        return result;
    }

    public String getQuery() {
        return this.query;
    }

    public String getItemType() {
        return this.itemType;
    }

    public boolean isRetrieveLatestVersion() {
        return this.retrieveLatestVersion;
    }

    public boolean isUsingMaxResults() {
        return this.useMaxResults;
    }

    public String getSortAfterQueryProperty() {
        return this.sortAfterQueryProperty;
    }

    public boolean getSortAfterQueryAscending() {
        return this.sortAfterQueryAscending;
    }

    public boolean getSortAfterFoldersFirst() {
        return this.sortAfterFoldersFirst;
    }

    private String calculateChecksum() {
        byte[] checksumBytes = DigestUtils.sha256((String)(SALT + this.query + this.itemType + this.retrieveLatestVersion + this.useMaxResults + this.sortAfterQueryProperty + this.sortAfterQueryAscending + this.sortAfterFoldersFirst));
        String checksumString = Base64.encodeBase64String((byte[])checksumBytes).trim();
        return checksumString;
    }
}

