/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchCriteriaMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.struts.actions.cm.CMOpenItemTypeAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.cm8.CM8FolderUtils;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cm.CMSearchTemplate;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDataObjectNotFound;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMOpenSearchTemplateAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMSearchCriteriaMediator searchCriteriaMediator = (CMSearchCriteriaMediator)this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String itemId = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemId = " + itemId);
        String teamspaceId = request.getParameter("workspaceId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceId = " + teamspaceId);
        String formType = request.getParameter("form_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "formType = " + formType);
        CMSearchTemplate searchTemplate = new CMSearchTemplate();
        searchCriteriaMediator.setSearchTemplate(searchTemplate);
        DKDatastoreICM dsICM = this.getDataStore(request);
        CMItem cmItem = null;
        DKDatastoreICM dKDatastoreICM = dsICM;
        synchronized (dKDatastoreICM) {
            try {
                this.getConfigInfo(request);
                CMConnection connection = this.getConnection(request);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.childAttributes(true);
                dkRetrieveOptions.childListOneLevel(true);
                cmItem = connection.retrieveItem(itemId, request, dkRetrieveOptions);
                CMItem[] children = cmItem.getAttrItems("ICMSearchData");
                String value = children[0].getAttrValue("clbSearchJSON");
                JSONObject json = (JSONObject)JSON.parse(value);
                value = cmItem.getAttrValue("clbAutoRun");
                searchTemplate.setAutoRun(value != null && value.equals("1"));
                value = cmItem.getAttrValue("clbShowInTree");
                searchTemplate.setShowInTree(value != null && value.equals("1"));
                searchTemplate.load(request, dsICM, Config.getRepositoryConfig(request), json);
                Teamspace teamspace = null;
                if (teamspaceId != null) {
                    CM8TeamspaceService teamspaceService = new CM8TeamspaceService(request, connection, this.wcDateFormats);
                    teamspace = teamspaceService.retrieveTeamspace(teamspaceId, "searches", "instance");
                }
                this.updateFolders(connection, searchTemplate.getFolders(), teamspace);
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                String itemTypeName = searchTemplate.getFirstClassName();
                if (itemTypeName.equals("$common")) {
                    searchCriteriaMediator.setAttributes(dsDefICM.listAttrs());
                } else {
                    List<SearchTemplate.SearchClass> classes = searchTemplate.getClasses();
                    if (classes != null && classes.size() > 0) {
                        for (SearchTemplate.SearchClass searchClass : classes) {
                            DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(searchClass.getName());
                            if (itemType == null) continue;
                            searchClass.setDisplayName(itemType.getDescription());
                            this.intersect(searchCriteriaMediator, itemType);
                        }
                    }
                }
                dkCollection attributes = searchCriteriaMediator.getAttributes();
                if (attributes == null) {
                    searchCriteriaMediator.addError("cannot.be.opened");
                }
            }
            catch (Exception e) {
                if (e instanceof DKDataObjectNotFound) {
                    searchCriteriaMediator.addError("error.exception.opensearchnotfound", itemId);
                } else {
                    searchCriteriaMediator.addError("error.exception.general", e.getMessage());
                }
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void intersect(CMSearchCriteriaMediator criteriaMediator, DKComponentTypeDefICM itemType) throws Exception {
        criteriaMediator.setAttributes(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getAttributes(), itemType.listAllAttributes()));
        criteriaMediator.setChildComponents(CMOpenItemTypeAction.intersectAttributes(criteriaMediator.getChildComponents(), itemType.listSubEntities()));
        dkCollection foreignKeys = itemType.listForeignKeys();
        Logger.logDebug((Object)this, "intersect", (ServletRequest)this.request, "fkNames = " + (foreignKeys == null ? "" : Arrays.asList(foreignKeys).toString()));
        criteriaMediator.setForeignKeys(CMOpenItemTypeAction.intersectForeignKeys(criteriaMediator.getForeignKeys(), foreignKeys));
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            mediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        String searchTemplateId = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "searchTemplateId = " + searchTemplateId);
        if (searchTemplateId == null || searchTemplateId.trim().length() < 1) {
            mediator.addError("error.parm.null", "template_name");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        return new CMSearchCriteriaMediator(request, this.getResources(request), request.getLocale());
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String itemId = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "itemId = " + itemId);
    }

    private void updateFolders(CMConnection connection, List<SearchTemplate.SearchFolder> folders, Teamspace teamspace) throws Exception {
        if (folders != null) {
            for (SearchTemplate.SearchFolder folder : folders) {
                String pathName = null;
                if (folder.getId().equals(SearchTemplate.THIS_TEAMSPACE_ID) || teamspace != null && folder.getId().equals(teamspace.getId())) {
                    pathName = pathName != null ? "/" + (teamspace != null ? teamspace.getName() : folder.getId()) + pathName : "/" + (teamspace != null ? teamspace.getName() : folder.getId());
                } else {
                    DKDDO ddoItem = connection.getDatastore().createDDOFromPID(folder.getId());
                    while (ddoItem != null) {
                        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                        dkRetrieveOptions.baseAttributes(true);
                        ddoItem.retrieve(dkRetrieveOptions.dkNVPair());
                        CMItem item = new CMItem(this.request, connection, ddoItem, "");
                        item.setItemState(2);
                        String name = item.getName();
                        if (ddoItem.getObjectType().equals("ICMTeamspace")) {
                            if (name.equals("Teamspaces")) break;
                            name = item.getAttrValue("clbTitle");
                        } else if (name.equals("ICMROOTFOLDER")) break;
                        pathName = pathName != null ? "/" + name + pathName : "/" + name;
                        ddoItem = CM8FolderUtils.getParent(this.request, connection.getDatastore(), ddoItem);
                    }
                }
                folder.setPathName(pathName);
            }
        }
    }
}

