/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMAttributesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKForeignKeyDefICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkAttrDef;
import com.ibm.mm.sdk.common.dkAttrGroupDef;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMOpenItemTypeAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    private WCDateFormat wcDateFormats = null;
    private boolean forSearch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String actionName = mapping.getName();
        this.forSearch = actionName != null && actionName.equals("openSearchTemplate");
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMAttributesMediator attributesMediator = (CMAttributesMediator)this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String itemTypeName = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemTypeName = " + itemTypeName);
        String[] itemTypeNames = itemTypeName.split(",");
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                this.getConfigInfo(request);
                CMConnection connection = this.getConnection(request);
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                if (itemTypeName.equals("$common")) {
                    attributesMediator.setAttrColl(dsDefICM.listAttrs());
                } else {
                    for (int i = 0; i < itemTypeNames.length; ++i) {
                        DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(itemTypeNames[i]);
                        if (itemType == null) continue;
                        CMEntity entity = new CMEntity(connection, (dkEntityDef)itemType);
                        this.intersect(attributesMediator, entity);
                        String message = resources.getMessage(request.getLocale(), "class.open.successful", new Object[]{entity.getDKDescription()});
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, message);
                    }
                }
                dkCollection attributes = attributesMediator.getAttrColl();
                if (attributes == null) {
                    attributesMediator.addError("cannot.be.opened");
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                attributesMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void intersect(CMAttributesMediator attributesMediator, CMEntity cmEntity) throws Exception {
        attributesMediator.addCMEntity(cmEntity);
        DKComponentTypeDefICM itemType = cmEntity.getItemType();
        attributesMediator.setAttrColl(CMOpenItemTypeAction.intersectAttributes(attributesMediator.getAttrColl(), itemType.listAllAttributes()));
        attributesMediator.setChildComponents(CMOpenItemTypeAction.intersectAttributes(attributesMediator.getChildComponents(), itemType.listSubEntities()));
        attributesMediator.setReferenceAttributes(CMOpenItemTypeAction.intersectAttributes(attributesMediator.getReferenceAttributes(), itemType.listAttrGroups(99)));
        dkCollection currentKeys = attributesMediator.getForeignKeys();
        dkCollection newKeys = itemType.listForeignKeys();
        Logger.logDebug((Object)this, "intersect", (ServletRequest)this.request, "current: " + (currentKeys == null ? "" : currentKeys.getName()) + ", new: " + (newKeys == null ? "" : newKeys.getName()));
        attributesMediator.setForeignKeys(CMOpenItemTypeAction.intersectForeignKeys(currentKeys, newKeys));
    }

    static dkCollection intersectAttributes(dkCollection currentAttributes, dkCollection newAttributes) throws DKUsageError {
        DKSequentialCollection intersection = new DKSequentialCollection();
        if (currentAttributes == null) {
            return newAttributes;
        }
        if (newAttributes == null) {
            return null;
        }
        dkIterator i = currentAttributes.createIterator();
        block0: while (i.more()) {
            Object attribute = i.next();
            String name = CMOpenItemTypeAction.getAttributeName(attribute);
            if (name == null) continue;
            dkIterator i2 = newAttributes.createIterator();
            while (i2.more()) {
                Object attribute2 = i2.next();
                String name2 = CMOpenItemTypeAction.getAttributeName(attribute2);
                if (!name.equals(name2)) continue;
                boolean textSearchable = attribute instanceof DKAttrDefICM && ((DKAttrDefICM)attribute).isTextSearchable();
                boolean textSearchable2 = attribute2 instanceof DKAttrDefICM && ((DKAttrDefICM)attribute2).isTextSearchable();
                intersection.addElement(textSearchable != textSearchable2 && textSearchable ? attribute2 : attribute);
                continue block0;
            }
        }
        return intersection;
    }

    private static String getAttributeName(Object attribute) {
        return attribute instanceof dkAttrDef ? ((dkAttrDef)attribute).getName() : (attribute instanceof dkEntityDef ? ((dkEntityDef)attribute).getName() : (attribute instanceof dkAttrGroupDef ? ((dkAttrGroupDef)attribute).getName() : null));
    }

    static dkCollection intersectForeignKeys(dkCollection currentKeys, dkCollection newKeys) throws DKException {
        String methodName = "intersectForeignKeys";
        DKSequentialCollection intersection = new DKSequentialCollection();
        if (currentKeys == null) {
            return newKeys;
        }
        if (newKeys == null) {
            return null;
        }
        dkIterator i = currentKeys.createIterator();
        while (i.more()) {
            DKForeignKeyDefICM key = (DKForeignKeyDefICM)i.next();
            String schema = key.getTargetSchemaName();
            String type = key.getTargetCompTypeName();
            Object[] sources = key.listSourceAttrNames();
            Object[] targets = key.listTargetAttrNames();
            dkIterator i2 = newKeys.createIterator();
            while (i2.more()) {
                boolean sameTarget;
                DKForeignKeyDefICM key2 = (DKForeignKeyDefICM)i2.next();
                String schema2 = key2.getTargetSchemaName();
                String type2 = key2.getTargetCompTypeName();
                Object[] sources2 = key2.listSourceAttrNames();
                Object[] targets2 = key2.listTargetAttrNames();
                boolean bl = sameTarget = schema != null && !schema.isEmpty() && schema.equals(schema2);
                if (!sameTarget) {
                    boolean bl2 = sameTarget = type != null && !type.isEmpty() && type.equals(type2) && Arrays.equals(sources, sources2) && Arrays.equals(targets, targets2);
                }
                if (!sameTarget) continue;
                intersection.addElement((Object)key);
            }
        }
        return intersection;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        if (serverName == null || serverName.length() == 0) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMAttributesMediator attributesMediator = new CMAttributesMediator(request, this.getResources(request), request.getLocale(), this.forSearch);
        return attributesMediator;
    }

    public void getConfigInfo(HttpServletRequest request) throws Exception {
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
        }
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String itemTypeName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "itemTypeName = " + itemTypeName);
    }
}

