/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.struts.actions.cm.CMQueryContinuationData;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMOpenFolderAction
extends CMBaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dataStore;
        boolean orderAscending;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, "executeAction", (ServletRequest)request);
        this.getConfigInfo(request);
        String parentId = request.getParameter("docid");
        String filterType = request.getParameter("filter_type");
        String workspaceId = request.getParameter("workspaceId");
        String orderBy = request.getParameter("order_by");
        boolean bl = orderAscending = !this.getBooleanRequestParameter(request, "order_descending", false);
        if (orderBy == null || orderBy.length() < 1) {
            orderBy = "name";
            orderAscending = true;
        } else if (orderBy.equalsIgnoreCase("!Name")) {
            orderBy = "name";
        }
        CMSearchResultsMediator mediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dataStore = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                DKDatastoreDefICM datastoreDef;
                DKDDO parentFolder;
                if (parentId.equals("/")) {
                    String configuredRootFolderId = this.getRootFolderId();
                    if (configuredRootFolderId != null) {
                        parentId = configuredRootFolderId;
                        parentFolder = dataStore.createDDOFromPID(parentId);
                    } else {
                        parentFolder = dataStore.getRootFolder();
                    }
                } else {
                    parentFolder = dataStore.createDDOFromPID(parentId);
                }
                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Recreated Folder DDO.");
                DKPidICM pid = (DKPidICM)parentFolder.getPidObject();
                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "pid for Folder: " + pid);
                String parentFolderItemTypeName = CMBaseUtil._getEntityName(pid.getObjectType());
                String parentFolderPrimaryId = pid.getPrimaryId();
                String queryString = this.buildFolderContentQueryString(parentFolderPrimaryId, filterType);
                CMBaseAction.QueryOutput out = null;
                CMConnection connection = this.getConnection(request);
                if (connection.getAllItemTypesSortNotSupported() || orderBy.equalsIgnoreCase("name") || orderBy.equalsIgnoreCase("{NAME}")) {
                    mediator.setSortType(1, orderAscending, orderBy, true);
                } else {
                    String sortBy = null;
                    try {
                        CMSearchConstants.SystemAttribute sa = CMSearchConstants.SystemAttribute.valueOf(orderBy);
                        sortBy = sa.getAttributeName();
                    }
                    catch (Exception e) {
                        sortBy = orderBy;
                    }
                    String sortedQueryString = queryString + " [@LASTCHANGEDUSERID] SORTBY (@" + sortBy + (orderAscending ? " ASCENDING" : " DESCENDING") + ")";
                    try {
                        out = this.runQuery(request, dataStore, sortedQueryString, 0, this.pageSize, true, false, true);
                    }
                    catch (Exception e) {
                        connection.setAllItemTypesSortNotSupported(true);
                        mediator.setSortType(1, orderAscending, orderBy, true);
                    }
                }
                mediator.setSortIndex(3);
                if (out == null) {
                    out = this.runQuery(request, dataStore, queryString, 0, this.pageSize, true, false, true);
                }
                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "containeeList size: " + out.count);
                if (out.hasMore) {
                    CMQueryContinuationData data = mediator.getSearchSortType() == 1 ? new CMQueryContinuationData(queryString, parentFolderItemTypeName, true, false, mediator.getSortAfterQueryProperty(), mediator.getSortAscending(), mediator.getFoldersFirst()) : new CMQueryContinuationData(queryString, parentFolderItemTypeName, true, false, null, true, true);
                    String serializedContinuationData = data.saveToString();
                    mediator.setContinuationData(serializedContinuationData);
                }
                if (out.count != 0) {
                    datastoreDef = (DKDatastoreDefICM)dataStore.datastoreDef();
                    Collection<DKComponentTypeDefICM> itemTypes = this.getUniqueItemTypes(request, out.items, datastoreDef);
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "unique folder item types count: " + itemTypes.size());
                    mediator.setEntities(itemTypes);
                }
                datastoreDef = (DKDatastoreDefICM)dataStore.datastoreDef();
                DKComponentTypeDefICM parentFolderItemType = (DKComponentTypeDefICM)datastoreDef.retrieveEntity(parentFolderItemTypeName);
                DKSequentialCollection compTypes = (DKSequentialCollection)parentFolderItemType.listSubEntities();
                dkCollection referenceAttributes = parentFolderItemType.listAttrGroups(99);
                mediator.setItemType(parentFolderItemType);
                mediator.setChildComponents((dkCollection)compTypes);
                mediator.setReferenceAttributes(referenceAttributes);
                CMSearchResults results = new CMSearchResults(request, connection);
                results.newResults(out.items, true, false, true);
                mediator.setSearchResults(results);
                mediator.setParentDocID(parentId);
                mediator.setMaxResultsReached(out.maxResultsReached);
                CM8TeamspaceService teamspaceService = null;
                if (workspaceId != null && workspaceId.length() > 0) {
                    teamspaceService = new CM8TeamspaceService(request, connection, this.getDateFormats());
                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "retrieving teamspace");
                    Teamspace teamspace = teamspaceService.retrieveTeamspace(workspaceId, "columns", "instance");
                    if (teamspace != null) {
                        SearchTemplate.ResultsDisplay colProps = teamspace.getColumnProperties();
                        if (colProps != null && colProps.getColumns() != null && colProps.getColumns().length > 0) {
                            String[] props = colProps.getColumns();
                            mediator.setDisplayColumns(props);
                            mediator.setAllItemtypesView(true);
                            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dataStore.datastoreDef();
                            dkCollection attributes = dsDefICM.listAttrs();
                            mediator.setAttrColl(attributes);
                        }
                    } else {
                        Logger.logInfo((Object)this, "executeAction", (ServletRequest)request, "teamspace not found!");
                    }
                }
                if (out.count == this.maxResults) {
                    mediator.addMessage("openFolder.returned.limit", new Object[0]);
                } else {
                    mediator.addMessage(out.count == 1 ? "openFolder.returnedOne" : "openFolder.returned", out.count);
                }
                RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                if (repositoryConfig != null) {
                    String folderNameProperty;
                    String docNameProperty;
                    String[] folderDefaultColumns;
                    if (mediator.getDisplayColumns() == null && (folderDefaultColumns = repositoryConfig.getFolderDefaultColumns()) != null && (folderDefaultColumns.length > 1 || folderDefaultColumns.length == 1 && folderDefaultColumns[0] != null && folderDefaultColumns[0].length() > 0)) {
                        mediator.setDisplayColumns(folderDefaultColumns);
                    }
                    if ((docNameProperty = repositoryConfig.getDocNameProperty()) != null && docNameProperty.length() > 0) {
                        mediator.setDocNameProperty(docNameProperty);
                    }
                    if ((folderNameProperty = repositoryConfig.getFolderNameProperty()) != null && folderNameProperty.length() > 0) {
                        mediator.setFolderNameProperty(folderNameProperty);
                    }
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, "executeAction");
                Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
        return null;
    }

    protected String buildFolderContentQueryString(String parentFolderPrimaryId, String filterType) {
        String queryString = "/* [";
        if (filterType != null && (filterType.equals("folderSearch") || filterType.equals("searchAndFolderSearch"))) {
            queryString = queryString + "(@SEMANTICTYPE = 2) AND ";
        }
        String inboundLink = "(INBOUNDLINK[@LINKTYPE = \"DKFolder\"]/@SOURCEITEMREF = \"" + parentFolderPrimaryId + "\")]";
        queryString = queryString + inboundLink;
        if (filterType != null && filterType.equals("searchAndFolderSearch")) {
            queryString = queryString + " | /ICMSearch[@clbShowInTree = 1 AND " + inboundLink;
        }
        return queryString;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template");
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        return serverName != null && pid != null;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        MessageResources resources = this.getResources(request);
        CMConnection connection = this.getConnection(request);
        CMSearchResultsMediator mediator = new CMSearchResultsMediator(request, resources, request.getLocale());
        mediator.setConnection(connection);
        mediator.setDateFormats(this.wcDateFormats);
        mediator.setAllItemtypesView(true);
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template");
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
    }
}

