/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.Constants;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.mediator.cm.CMLogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.LTPASSOLogon;
import com.ibm.ecm.struts.actions.SSOLogonAction;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.util.J2EEServerUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.mm.sdk.common.DKDatabaseLogonFailure;
import com.ibm.mm.sdk.common.DKDatastoreAccessError;
import com.ibm.mm.sdk.common.DKInvalidPasswordException;
import com.ibm.mm.sdk.common.DKLogonFailure;
import com.ibm.mm.sdk.common.DKPasswordExpiredException;
import com.ibm.mm.sdk.common.DKServerNotAvailable;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.internal.PConnectHandleICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMLogonAction
extends CMBaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    public static final String CM8_SERVER_TYPE = "cm";
    private static final String RECORD_TYPE_CONTENT = "Content";
    private static final String RECORD_TYPE_PLAIN = "Plain";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        Object connection = null;
        LogonMediator logonMediator = (LogonMediator)this.getMediator(request);
        try {
            this.createCMConnection(request, response, logonMediator);
            HttpSession session = Util.replaceSession(request);
        }
        catch (DKPasswordExpiredException e) {
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "A connect failed  due to password expired");
            logonMediator.addError("error.password.expired");
        }
        catch (DKInvalidPasswordException e) {
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "A connect failed  due to invalud password");
            logonMediator.addError("error.bad.userid.password");
        }
        catch (DKDatabaseLogonFailure e) {
            Logger.logError(this, methodName, (ServletRequest)request, "A connect failed due to database login failure", e);
            logonMediator.addError("error.server.unavailable");
        }
        catch (DKLogonFailure e) {
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "A connect failed  due to bad userid or password");
            logonMediator.addError("error.bad.userid.password");
        }
        catch (DKServerNotAvailable e) {
            Logger.logError(this, methodName, (ServletRequest)request, "A connect failed  due to server unavailable", e);
            logonMediator.addError("error.server.unavailable");
        }
        catch (DKDatastoreAccessError e) {
            if (e.getErrorId() == 7334 && e.errorCode() == 7173) {
                RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                String serverName = null;
                if (repositoryConfig != null) {
                    serverName = repositoryConfig.getServerName();
                }
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "User id is locked on Server." + serverName);
                logonMediator.addError("error.userid.locked", serverName);
            } else {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                logonMediator.addError("error.fatal", e.getLocalizedMessage(), new Integer(e.getErrorId()));
            }
        }
        catch (DKUsageError e) {
            if (e.errorCode() == 7917) {
                String serverName = request.getParameter("serverName");
                RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                if (repositoryConfig != null && repositoryConfig.getServerName() != null) {
                    serverName = repositoryConfig.getServerName();
                }
                logonMediator.addError("repository.error.nopermissions", serverName);
                Logger.logError(this, methodName, (ServletRequest)request, "User do not have the appropriate permissions to access the following server: ", e);
            } else {
                logonMediator.addError("error.exception.general", e.getLocalizedMessage());
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && (e.getCause() instanceof AuthenticationException || e.getCause().getClass().getCanonicalName().equals("com.ibm.websphere.security.auth.WSLoginFailedException"))) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, e.getMessage());
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "An SSO Connect failed: " + e.getClass().getName() + ": " + e.getMessage());
                logonMediator.addError("error.bad.userid.password");
            }
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            logonMediator.addError("error.exception.general", e.getLocalizedMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private boolean isCM842(DKDatastoreICM dataStore) throws Exception {
        PConnectHandleICM connectHandle = (PConnectHandleICM)dataStore.handle("DSICM").handle();
        String lsVersion = connectHandle.getLSVersion();
        long lVersion = 0L;
        if (lsVersion != null) {
            StringTokenizer parser = new StringTokenizer(lsVersion, ".");
            int version = Integer.valueOf(parser.nextToken());
            int release = Integer.valueOf(parser.nextToken());
            int CSD = Integer.valueOf(parser.nextToken());
            int fixpack = Integer.valueOf(parser.nextToken());
            lVersion = (long)version * 1000000000L + (long)release * 1000000L + (long)CSD * 1000L + (long)fixpack;
        }
        return lVersion < 8004003000L;
    }

    public void createCMConnection(HttpServletRequest request, HttpServletResponse response, LogonMediator logonMediator) throws Exception {
        String methodName = "createCMConnection";
        HttpSession session = request.getSession(true);
        String userid = request.getParameter("userid");
        String password = request.getParameter("password");
        String desktopName = request.getParameter("desktop");
        Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        String loginRepoId = request.getParameter("repositoryId");
        Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "loginRepoId = " + loginRepoId);
        String serverName = request.getParameter("serverName");
        Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "serverName = " + serverName);
        String useSSO = request.getParameter("useSSO");
        if (useSSO == null) {
            useSSO = "false";
        }
        Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "useSSO = " + useSSO);
        if (userid != null && userid.length() > 32) {
            Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "A connect failed exception due to invalid userid -- too long");
            logonMediator.addError("error.bad.userid.password");
        } else if (password != null && password.length() > 32) {
            Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "A connect failed exception due to invalid password -- too long");
            logonMediator.addError("error.bad.userid.password");
        } else {
            CMConnection connection;
            String strLangCodes;
            boolean isSSOLogin;
            boolean isDefaultRepo = false;
            ArrayList<RepositoryConfig> cm8SSORepositoryList = new ArrayList<RepositoryConfig>();
            RepositoryConfig repositoryConfig = null;
            DesktopConfig desktopConfig = Config.getDesktopConfig(request);
            String defaultRepositoryId = desktopConfig.getDefaultRepositoryId();
            if (serverName == null) {
                repositoryConfig = Config.getRepositoryConfig(request);
                boolean bl = isDefaultRepo = repositoryConfig != null && repositoryConfig.getObjectId() != null && repositoryConfig.getObjectId().equals(defaultRepositoryId);
                if (repositoryConfig == null) {
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "repository config is " + repositoryConfig + " null so looking for defaultRepo config");
                    if (defaultRepositoryId != null) {
                        repositoryConfig = desktopConfig.getRepository(defaultRepositoryId);
                        if (loginRepoId == null) {
                            loginRepoId = repositoryConfig.getObjectId();
                        }
                    }
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, " defaultRepo config" + repositoryConfig);
                }
                if (repositoryConfig != null) {
                    serverName = repositoryConfig.getServerName();
                    useSSO = repositoryConfig.getUseSSO();
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "serverName = " + serverName + " useSSO=" + useSSO);
                }
            }
            if (logonMediator.getCurrentRepositoryId() == null) {
                logonMediator.setCurrentRepositoryId(serverName);
            }
            boolean bl = isSSOLogin = useSSO != null && useSSO.equalsIgnoreCase("TRUE");
            if (isSSOLogin) {
                Map<String, RepositoryConfig> map = desktopConfig.getRepositoryMap();
                for (Map.Entry<String, RepositoryConfig> pairs : map.entrySet()) {
                    String useSSORepo;
                    String repoId = pairs.getKey();
                    RepositoryConfig ssoRepoConfig = pairs.getValue();
                    if (ssoRepoConfig == null) continue;
                    if (repoId != null && repoId.equals(loginRepoId)) {
                        Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "The CM8 server  for logging in '" + ssoRepoConfig.getServerName() + " repoId " + repoId);
                        continue;
                    }
                    if (!ssoRepoConfig.getType().equals(CM8_SERVER_TYPE) || (useSSORepo = ssoRepoConfig.getUseSSO()) == null || !useSSORepo.equalsIgnoreCase("TRUE")) continue;
                    cm8SSORepositoryList.add(ssoRepoConfig);
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "The CM8 server is configured for SSO '" + ssoRepoConfig.getServerName() + " repoID=" + repoId);
                }
            }
            try {
                boolean isWebsphere;
                boolean bl2 = isWebsphere = J2EEServerUtil.getJ2EEAppServerType(this.getServlet().getServletContext()) == "websphere";
                if (isDefaultRepo || isSSOLogin) {
                    Logger.logInfo(CMLogonAction.class, methodName, (ServletRequest)request, "Creating the Container Login defaultRepositoryId=" + defaultRepositoryId);
                    Subject subject = new ContainerLogonAction().doContainerLogin(request, response, userid, password, isWebsphere, logonMediator);
                } else {
                    Logger.logInfo(CMLogonAction.class, methodName, (ServletRequest)request, "Skipping  the Container Login repoId=" + repositoryConfig.getObjectId() + "defaultRepositoryId=" + defaultRepositoryId);
                }
                if (Config.getApplicationConfig(request).checkAdminAccessForUser(userid)) {
                    logonMediator.setIsAdminUser("true");
                } else {
                    logonMediator.setIsAdminUser("false");
                }
            }
            catch (Throwable t) {
                logonMediator.setIsAdminUser("false");
            }
            if (isSSOLogin) {
                isSSOLogin = LTPASSOLogon.doesLtpaTokenExists(request);
            }
            Date date = Logger.logPerf((Object)this, methodName, (ServletRequest)request, "CM login start");
            String connectString = null;
            String langCode = CMUtil.getLanguageCode(request.getLocale());
            if (repositoryConfig != null && (strLangCodes = repositoryConfig.getLanguageCodes()) != null) {
                String[] langCodes;
                for (String code : langCodes = strLangCodes.split(",")) {
                    if (!code.equals(langCode)) continue;
                    connectString = "LANG=" + langCode;
                    break;
                }
            }
            if (isDefaultRepo || userid != null && password != null) {
                Logger.logInfo(CMLogonAction.class, methodName, (ServletRequest)request, "isDefaultRepo=" + isDefaultRepo + " defaultRepositoryId=" + defaultRepositoryId + " userid=" + userid + " password non empty?" + (password == null));
                connection = CMConnection.login(serverName, userid, password, connectString);
            } else if (isSSOLogin) {
                connection = CMConnection.trustedLogin(serverName, request);
                if (userid == null && connection != null) {
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "user id is NULL. So setting it from trusted logon Connection object.");
                    userid = connection.getUserid();
                }
            } else {
                connection = CMConnection.login(serverName, userid, password, connectString);
            }
            Logger.logPerf(this, methodName, (ServletRequest)request, date, "CM login completed");
            if (session != null && userid != null) {
                session.setAttribute("session_userid", (Object)userid);
            }
            Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "No action errors returned");
            CMLogonAction.storeNewConnection(request, connection, loginRepoId);
            if (logonMediator instanceof CMLogonMediator) {
                ((CMLogonMediator)logonMediator).setConnection(connection);
                ((CMLogonMediator)logonMediator).setRepositoryId(loginRepoId);
            }
            Hashtable<String, String> privTable = this.getPriv(request, response, repositoryConfig);
            DKDatastoreICM dataStore = this.getDataStore(request, repositoryConfig);
            if (dataStore != null) {
                String recordType;
                boolean isRecordsManagerEnabled = CMUtil.isRecordsManagerEnabled(dataStore);
                String string = recordType = isRecordsManagerEnabled ? RECORD_TYPE_CONTENT : RECORD_TYPE_PLAIN;
                if (logonMediator instanceof CMLogonMediator) {
                    CMLogonMediator cmLogonMediator = (CMLogonMediator)logonMediator;
                    cmLogonMediator.setRecordType(recordType);
                    if (connection != null) {
                        connection.setDataStoreRecordType(recordType);
                    }
                    boolean isCM842 = this.isCM842(dataStore);
                    cmLogonMediator.setCM842(isCM842);
                }
                Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "Repository Record Type: " + recordType);
            }
            Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("cm_servers");
            logonMediator.setCM8ConnectionList(connectionList);
            Hashtable<String, Hashtable<String, String>> aclConnectionList = (Hashtable<String, Hashtable<String, String>>)request.getSession(true).getAttribute("cm_servers_permissions");
            if (aclConnectionList == null) {
                aclConnectionList = new Hashtable<String, Hashtable<String, String>>();
            }
            aclConnectionList.put(loginRepoId, privTable);
            request.getSession(true).setAttribute("cm_servers_permissions", aclConnectionList);
            if (isSSOLogin) {
                SSOLogonAction.doSSOLogonForCM8(request, logonMediator, userid);
                SSOLogonAction.doSSOLogonForP8(request, logonMediator);
                SSOLogonAction.doSSOLogonForOD(request, response, logonMediator);
            }
            logonMediator.addMessage("logon.successful", connection.getUserid());
        }
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        LogonMediator logonMediator = (LogonMediator)this.getMediator(request);
        if (serverName == null || serverName.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "server name was not found");
            logonMediator.addError("error.parm.null");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    public static void storeNewConnection(HttpServletRequest request, CMConnection connection, String repositoryId) {
        String methodName = "storeNewConnection";
        if (repositoryId == null) {
            repositoryId = request.getParameter("repositoryId");
        }
        if (connection != null) {
            Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "The connection object is connected");
            CMLogonAction.setConnection(request, connection, repositoryId);
            HttpSession session = request.getSession(false);
            session.setAttribute(repositoryId, (Object)connection);
        } else {
            Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "There was not a valid connection created by the action bean");
        }
    }

    public static Hashtable getServerList(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return (Hashtable)session.getAttribute("cm_servers");
    }

    public static void removeServerList(HttpServletRequest request) {
        String methodName = "removeServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            Hashtable cm_server_List = CMLogonAction.getServerList(request);
            Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "   current CM connection list: " + cm_server_List);
            if (cm_server_List != null) {
                Logger.logInfo(CMLogonAction.class, methodName, (ServletRequest)request, "current CM connection list size: " + cm_server_List.size());
                session.removeAttribute("cm_servers");
                Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "   removed CM connection list from session: " + cm_server_List);
                Object[] repoIds = cm_server_List.keySet().toArray();
                for (int i = 0; i < repoIds.length; ++i) {
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "   remove CM connection from session: " + (String)repoIds[i]);
                    session.removeAttribute((String)repoIds[i]);
                }
            }
        }
    }

    public static void setServerList(HttpServletRequest request, Hashtable connectionList) {
        String methodName = "setServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("cm_servers");
            if (connectionList != null) {
                Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "   add CM connections from session: " + connectionList);
                Object[] keys = connectionList.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "   add CM connection: " + (String)keys[i]);
                    CMConnection connection = (CMConnection)connectionList.get((String)keys[i]);
                    CMLogonAction.storeNewConnection(request, connection, (String)keys[i]);
                }
            }
        }
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMLogonMediator logonMediator = new CMLogonMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)logonMediator);
        return logonMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repoId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "repoId = " + repoId);
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
    }
}

