/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.Constants;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMLogoffMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMLogoffAction
extends CMBaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        ActionForward actionForward = null;
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String configInfo = request.getParameter("service_CM_configInfo");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "configURL = " + configInfo);
        String desktopName = request.getParameter("desktop");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        String displayName = "";
        CMConnection connection = null;
        CMLogoffMediator logoffMediator = (CMLogoffMediator)this.getMediator(request);
        DKDatastoreICM dsICM = this.getDataStore(request);
        try {
            if (dsICM != null) {
                RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                if (repositoryConfig != null) {
                    displayName = repositoryConfig.getName();
                }
                connection = this.getConnection(request);
                DKDatastoreICM dKDatastoreICM = dsICM;
                synchronized (dKDatastoreICM) {
                    connection.logout();
                    this.removeConnection(request);
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "No action errors returned by JWTLogoffActionBean");
            }
            logoffMediator.addMessage("logoff.successful", displayName);
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            logoffMediator.addError("error.server.unavailable");
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        CMLogoffMediator LogoffMediator = (CMLogoffMediator)this.getMediator(request);
        if (serverName == null || serverName.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "server name was invalid");
            LogoffMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMLogoffMediator logoffMediator = new CMLogoffMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)logoffMediator);
        return logoffMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String configInfo = request.getParameter("service_CM_configInfo");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "configURL = " + configInfo);
    }
}

