/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMLockItemAction
extends CMBaseAction {
    private int pageSize = 0;
    private int maxResults = 0;
    private WCDateFormat wcDateFormats = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM dsICM = this.getDataStore(request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering synchronized block");
        DKDatastoreICM dKDatastoreICM = dsICM;
        synchronized (dKDatastoreICM) {
            try {
                this.getConfigInfo(request);
                String docId = request.getParameter("docid");
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                String entityName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
                String[] docIds = request.getParameterValues("docid");
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(entityName);
                searchResultsMediator.setItemType(itemType);
                dkCollection referenceAttributes = itemType.listAttrGroups(99);
                searchResultsMediator.setReferenceAttributes(referenceAttributes);
                DKSequentialCollection compTypes = (DKSequentialCollection)itemType.listSubEntities();
                searchResultsMediator.setChildComponents((dkCollection)compTypes);
                searchResultsMediator.setConnection(this.getConnection(request));
                DKDatastoreExtICM dsExt = this.getDataStoreExt(request);
                Vector<CMItem> vectorHits = new Vector<CMItem>(docIds.length);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of docids:" + docIds.length);
                CMItem item = null;
                CMConnection connection = this.getConnection(request);
                if (dsICM != null && dsICM.isConnected() && dsExt.isSupported("checkOut")) {
                    int errorCount = 0;
                    int successCount = 0;
                    ArrayList<String> errorItemNames = new ArrayList<String>();
                    ArrayList<CMItem> errorItems = new ArrayList<CMItem>();
                    ArrayList<String> errorItemMessages = new ArrayList<String>();
                    for (int i = 0; i < docIds.length; ++i) {
                        try {
                            DKDDO icmddo = dsICM.createDDOFromPID(docIds[i]);
                            item = new CMItem(request, connection, icmddo, "");
                            item.setItemState(1);
                            item.setDateFormats(this.getDateFormats());
                            vectorHits.add(item);
                            if (!dsExt.isCheckedOut((dkDataObject)icmddo)) {
                                dsExt.checkOut((dkDataObject)icmddo);
                                ++successCount;
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item is checked out " + docIds[i]);
                            } else {
                                String checkedOutUserid = dsExt.checkedOutUserid((dkDataObject)icmddo);
                                String loggedOnUserid = dsExt.getDatastore().userName();
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "checked out by =" + checkedOutUserid);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "user name currently logged on=" + loggedOnUserid);
                                if (docIds.length == 1 && !checkedOutUserid.equalsIgnoreCase(loggedOnUserid)) {
                                    searchResultsMediator.addError("error.lock.lockedByOtherUser");
                                }
                            }
                            boolean checkedOut = item.isCheckedOut();
                            String user = item.getCheckedOutUserid();
                            item.getAttrName();
                            item.getAttrValues();
                            item.getMimeType();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item value checked out = " + checkedOut + " and checked out by " + user);
                            continue;
                        }
                        catch (Exception checkoutException) {
                            ++errorCount;
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)checkoutException);
                            errorItemNames.add(docIds[i]);
                            errorItemMessages.add(checkoutException.getLocalizedMessage());
                            try {
                                DKDDO tempDDO = dsICM.createDDOFromPID(docIds[i]);
                                CMItem tempItem = new CMItem(request, connection, docIds[i]);
                                tempItem.setItem(tempDDO, null);
                                tempItem.setDateFormats(this.getDateFormats());
                                errorItems.add(tempItem);
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    if (docIds.length > 1) {
                        if (errorCount > 0) {
                            try {
                                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
                                dkRetrieveOptions.baseAttributes(true);
                                dkRetrieveOptions.basePropertyAclName(true);
                                dkRetrieveOptions.linksOutbound(false);
                                CMItem[] errorItemsArr = errorItems.toArray(new CMItem[errorItems.size()]);
                                CMItem.retrieveItemGroup(request, errorItemsArr, dkRetrieveOptions);
                                errorItemNames.clear();
                                for (int itemCounter = 0; itemCounter < errorItemsArr.length; ++itemCounter) {
                                    errorItemNames.add(errorItemsArr[itemCounter].getName());
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            String docNames = "";
                            for (int iErrorCounter = 0; iErrorCounter < errorItemNames.size(); ++iErrorCounter) {
                                String docName = (String)errorItemNames.get(iErrorCounter);
                                String reason = (String)errorItemMessages.get(iErrorCounter);
                                if (docNames.length() > 0) {
                                    docNames = docNames + "<br/><br/>";
                                }
                                docNames = docNames + docName + ": " + reason;
                            }
                            searchResultsMediator.addWarning("document.checkout.partial", String.valueOf(errorItems.size()), docNames);
                        }
                        if (successCount == 1) {
                            searchResultsMediator.addMessage("document.checkout.multi.success.single", new Object[0]);
                        } else if (successCount > 1) {
                            searchResultsMediator.addMessage("document.checkout.multi.success", String.valueOf(successCount));
                        }
                    } else if (errorCount == 0) {
                        searchResultsMediator.addMessage("document.checkout.single.success", new Object[0]);
                    } else {
                        searchResultsMediator.addWarning("document.checkout.single", new Object[0]);
                    }
                }
                CMSearchResults newSearchResults = new CMSearchResults(request, connection);
                newSearchResults.setPageSize(this.getPageSize());
                newSearchResults.setWcDateFormats(this.getDateFormats());
                newSearchResults.newResults(vectorHits, false, false, false);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of items found -->  [Vector = " + vectorHits.size() + "] [SearchResults Bean = " + newSearchResults.getCount() + "]");
                searchResultsMediator.setDateFormats(this.getDateFormats());
                searchResultsMediator.setSearchResults(newSearchResults);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Leaving synchronized block");
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    public void getConfigInfo(HttpServletRequest request) throws Exception {
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.pageSize = repositoryConfig.getPageSize();
            this.maxResults = repositoryConfig.getMaxResults();
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
        }
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String docId = request.getParameter("docid");
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
    }
}

