/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.Constants;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMTeamspaceListMediator;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMListTeamspaces
extends CMBaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String teamspaceType = request.getParameter("workspaceType");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceType = " + teamspaceType);
        if (teamspaceType == null) {
            teamspaceType = "instance";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceType = " + teamspaceType);
        String configInfo = request.getParameter("service_CM_configInfo");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "configURL = " + configInfo);
        String desktopName = request.getParameter("desktop");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        String teamspaceId = request.getParameter("workspaceId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceId = " + teamspaceId);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            CMTeamspaceListMediator teamspaceListMediator = (CMTeamspaceListMediator)this.getMediator(request);
            try {
                if (dsICM != null) {
                    CMConnection connection = this.getConnection(request);
                    CM8TeamspaceService teamspaceService = new CM8TeamspaceService(request, connection, this.getDateFormats());
                    if (teamspaceId != null && teamspaceId.length() > 0) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieve teamspace by id");
                        Teamspace teamspace = teamspaceService.retrieveTeamspace(teamspaceId, "allData", teamspaceType);
                        ArrayList<Teamspace> teamspaces = new ArrayList<Teamspace>();
                        if (teamspace != null) {
                            if (teamspace.getState().equals("deleted")) {
                                teamspaceListMediator.addError("openTeamspace.error.failed.deleted");
                            } else {
                                teamspaces.add(teamspace);
                                teamspaceListMediator.setTeamspaces(teamspaces);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Teamspaces were retrieved");
                                teamspaceListMediator.addMessage("workspaces.retrieve.successful", new Object[0]);
                            }
                        } else {
                            teamspaceListMediator.addError("retrieveTeamspace.error.failed");
                        }
                    } else {
                        List<Teamspace> teamspaces;
                        if (teamspaceType.equals("template")) {
                            String retrieval = "template";
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieve list of teamspaces");
                            teamspaces = teamspaceService.retrieveTeamspaces(teamspaceType, "all", retrieval);
                        } else {
                            String retrieval = "instance";
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieve list of teamspaces");
                            teamspaces = teamspaceService.retrieveTeamspaces(teamspaceType, "published", retrieval);
                        }
                        Collections.sort(teamspaces, new Comparator<Teamspace>(){

                            @Override
                            public int compare(Teamspace w1, Teamspace w2) {
                                return w1.getName().compareTo(w2.getName());
                            }
                        });
                        teamspaceListMediator.setTeamspaces(teamspaces);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Teamspaces were retrieved");
                        teamspaceListMediator.addMessage("workspaces.retrieve.successful", new Object[0]);
                    }
                }
            }
            catch (SecurityException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, "This could be a case where user has ItemSuperAcess but does not have systemacl priv");
                teamspaceListMediator.addError("openTeamspace.error.failed", e.getCause().getMessage());
            }
            catch (Throwable e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, e);
                teamspaceListMediator.addError("retrieveTeamspace.error.failed", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, "validateRequest", (ServletRequest)request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, "validateRequest", (ServletRequest)request, "serverName = " + serverName);
        CMTeamspaceListMediator teamspaceListMediator = (CMTeamspaceListMediator)this.getMediator(request);
        if (serverName == null || serverName.trim().length() < 1) {
            teamspaceListMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, "validateRequest", (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMTeamspaceListMediator teamspaceListMediator = new CMTeamspaceListMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)teamspaceListMediator);
        return teamspaceListMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String configInfo = request.getParameter("service_CM_configInfo");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "configURL = " + configInfo);
    }
}

