/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.configuration.UserConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.ListFavoritesMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMListFavoritesAction
extends CMBaseAction {
    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator searchResultsMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        searchResultsMediator.setConnection(this.getConnection(request));
        return searchResultsMediator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName;
        block26: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding("UTF-8");
            }
            CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "get datastore");
            DKDatastoreICM dsICM = this.getDataStore(request);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "gott datastore");
            DKDatastoreICM dKDatastoreICM = dsICM;
            synchronized (dKDatastoreICM) {
                try {
                    try {
                        CMConnection connection = this.getConnection(request);
                        String osId = request.getParameter("repositoryId");
                        CMSearchResults wcSearchResults = new CMSearchResults(request, connection);
                        Map<String, UserConfig> userConfigs = this.getConfiguration(request);
                        Collection<FavoriteConfig> favoriteList = new ArrayList<FavoriteConfig>();
                        for (UserConfig userConfig : userConfigs.values()) {
                            for (FavoriteConfig favoriteConfig : userConfig.getFavoriteList()) {
                                if (!favoriteConfig.getRepositoryId().equals(osId.trim())) continue;
                                favoriteList.add(favoriteConfig);
                            }
                        }
                        if (favoriteList.size() > 1) {
                            favoriteList = this.sortFavorites(favoriteList);
                        }
                        Vector<CMItem> resultsVector = new Vector<CMItem>();
                        for (FavoriteConfig favoriteConfig : favoriteList) {
                            String pid = favoriteConfig.getItemId();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
                            if (!this.validateParam(pid)) {
                                searchResultsMediator.addError("error.parm.null", "docid");
                                this.setRequestHasErrors(request, true);
                            }
                            CMItem item = null;
                            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                            try {
                                item = this.retrieveItem(request, dsICM, pid);
                                if (!item.isRetrieved()) {
                                    item = null;
                                }
                            }
                            catch (Throwable e) {
                                Logger.logError((Object)this, methodName, (ServletRequest)request, e);
                                item = null;
                            }
                            if (item == null) {
                                searchResultsMediator.addError("listFavorites.items.notfound", new Object[0]);
                                this.setRequestHasErrors(request, true);
                                continue;
                            }
                            String itemTypeName = item.getEntityName();
                            DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(itemTypeName);
                            searchResultsMediator.setItemType(itemType);
                            dkCollection referenceAttributes = itemType.listAttrGroups(99);
                            searchResultsMediator.setReferenceAttributes(referenceAttributes);
                            DKSequentialCollection compTypes = (DKSequentialCollection)itemType.listSubEntities();
                            searchResultsMediator.setChildComponents((dkCollection)compTypes);
                            searchResultsMediator.setDateFormats(WCDateFormat.getDefaultDateFormats(request));
                            if (item != null) {
                                resultsVector.add(item);
                            }
                            if (pid.equals("/")) continue;
                            DKPidICM pidICM = new DKPidICM(pid);
                            if (!pidICM.getVersionNumber().equals("0")) {
                                searchResultsMediator.setShowVersions(true);
                            }
                            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                            dkRetrieveOptions.baseAttributes(true);
                            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                            dkRetrieveOptions.childListOneLevel(true);
                            dkRetrieveOptions.childAttributes(true);
                            CMItem cmItem = connection.retrieveItem(pid, request, dkRetrieveOptions);
                            Hashtable<String, String[]> attrNameValuePairs = new Hashtable<String, String[]>();
                            dkIterator iter = compTypes.createIterator();
                            while (iter.more()) {
                                DKComponentTypeDefICM compType = (DKComponentTypeDefICM)iter.next();
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "     - " + compType.getName() + ":  " + compType.getDescription());
                                CMItem[] childComponentInstances = cmItem.getAttrItems(compType.getName());
                                if (childComponentInstances == null || childComponentInstances.length <= 0) continue;
                                String[] attrNames = childComponentInstances[0].getAttrNames();
                                for (int z = 0; z < attrNames.length; ++z) {
                                    String attrName = attrNames[z];
                                    short attrType = childComponentInstances[0].getAttrType(attrName);
                                    String childAttrName = compType.getName() + "@$" + attrName;
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "     - add " + childAttrName);
                                    String[] childAttrValues = new String[childComponentInstances.length];
                                    for (int j = 0; j < childComponentInstances.length; ++j) {
                                        if (attrType == 48) {
                                            try {
                                                int ri;
                                                CMItem[] items = childComponentInstances[j].getAttrItems(attrName);
                                                if (items.length <= 0 || (ri = 0) >= items.length) continue;
                                                CMItem refItem = items[ri];
                                                childAttrValues[j] = refItem.getPidString();
                                            }
                                            catch (Throwable t) {
                                                childAttrValues[j] = "";
                                            }
                                            continue;
                                        }
                                        childAttrValues[j] = childComponentInstances[j].getAttrValues()[z].trim();
                                    }
                                    if (childAttrValues == null) continue;
                                    attrNameValuePairs.put(childAttrName, childAttrValues);
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "     - added " + childAttrName);
                                }
                            }
                            searchResultsMediator.setAttrNameValuePairs(attrNameValuePairs);
                        }
                        wcSearchResults.newResults(resultsVector, true, false, false);
                        searchResultsMediator.setSearchResults(wcSearchResults);
                    }
                    catch (Exception e) {
                        this.logFDC(request, response, null, methodName);
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        String favoriteAction = request.getParameter("action");
                        if (favoriteAction != null && favoriteAction.equalsIgnoreCase("favorite")) {
                            searchResultsMediator.addError("error.exception.favoriteNotFound");
                        } else {
                            searchResultsMediator.addError("error.exception.general", e.getMessage());
                        }
                        this.setRequestHasErrors(request, true);
                        Object var42_46 = null;
                        this.writeJSONMediator(request, response);
                        break block26;
                    }
                    Object var42_45 = null;
                }
                catch (Throwable throwable) {
                    Object var42_47 = null;
                    this.writeJSONMediator(request, response);
                    throw throwable;
                }
                this.writeJSONMediator(request, response);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private Collection<FavoriteConfig> sortFavorites(Collection<FavoriteConfig> favoriteList) {
        ArrayList<FavoriteConfig> resultList = new ArrayList<FavoriteConfig>();
        resultList.addAll(this.findFavoritesByType(favoriteList, "teamspace"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "folder"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "search"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "document"));
        return resultList;
    }

    private Collection<FavoriteConfig> findFavoritesByType(Collection<FavoriteConfig> favoriteList, String type) {
        ArrayList<FavoriteConfig> resultList = new ArrayList<FavoriteConfig>();
        for (FavoriteConfig favorite : favoriteList) {
            if (favorite.getType() == null || !favorite.getType().equals(type)) continue;
            resultList.add(favorite);
        }
        Collections.sort(resultList);
        return resultList;
    }

    private Map<String, UserConfig> getConfiguration(HttpServletRequest request) throws Exception {
        String methodName = "getConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String userIds = request.getParameter("userid");
        String[] ids = userIds.split(",");
        LinkedHashMap<String, UserConfig> userConfigs = new LinkedHashMap<String, UserConfig>();
        try {
            for (String id : ids) {
                if (userConfigs.get(id = id.toLowerCase(request.getLocale())) != null) continue;
                userConfigs.put(id, Config.getUserConfig(appName, id));
            }
        }
        catch (Exception e) {
            ListFavoritesMediator listFavoritesMediator = (ListFavoritesMediator)this.getMediator(request);
            listFavoritesMediator.addError("desktop.configError");
            Logger.logError((Object)this, "getConfiguration", (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return userConfigs;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        String userName = request.getParameter("userid");
        String action = request.getParameter("action");
        String id = request.getParameter("id");
        String osId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: app name = " + appName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: desktop name = " + desktopName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: user id = " + userName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: action = " + action);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: id = " + id);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: os id = " + osId);
        if (userName == null || userName.trim().length() == 0 || osId == null || osId.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "userid", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    protected boolean validateParam(String value) {
        return value != null && value.trim().length() > 0 && !value.equals("null");
    }

    public CMItem retrieveItem(HttpServletRequest request, DKDatastoreICM dsICM, String pid) throws Exception {
        DKDDO ddoItem;
        String methodName = "retrieveItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMItem item = null;
        if (pid.equals("/")) {
            if (this.getRootFolderId() != null) {
                pid = this.getRootFolderId();
                ddoItem = dsICM.createDDOFromPID(pid);
            } else {
                ddoItem = dsICM.getRootFolder();
            }
        } else {
            ddoItem = dsICM.createDDOFromPID(pid);
        }
        CMConnection connection = this.getConnection(request);
        item = new CMItem(request, connection, ddoItem, "");
        item.setItemState(1);
        item.setDateFormats(WCDateFormat.getDefaultDateFormats(request));
        item.getAttrName();
        item.getAttrValues();
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item with pid " + item.getPidString() + " retrieve");
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return item;
    }
}

